/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.entity.mob.natural;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.entity.base.FixedMovesetEntity;
import org.thecelestialworkshop.celestisynth.common.entity.goals.ActionStoppableMoveToTargetGoal;
import org.thecelestialworkshop.celestisynth.common.entity.goals.AnimatedMultiTriggerGoal;
import org.thecelestialworkshop.celestisynth.common.entity.goals.AnimatedTriggerGoal;
import org.thecelestialworkshop.celestisynth.common.registry.CSParticleTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.util.ParticleUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Veilguard
extends Monster
implements GeoEntity,
FixedMovesetEntity,
CSWeaponUtil {
    private static final EntityDataAccessor<Integer> ACTION = SynchedEntityData.m_135353_(Veilguard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_TICK = SynchedEntityData.m_135353_(Veilguard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int ACTION_MELEE = 1;
    public static final int ACTION_SMASH = 2;
    public static final int ACTION_RAGE = 3;
    public int nextAttack = 1;

    public Veilguard(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22279_, (double)0.18f).m_22268_(Attributes.f_22281_, 13.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22284_, 20.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new AnimatedTriggerGoal<Veilguard>(this, 1, 60.0, 50.0, (double)(this.m_20205_() + 3.0f), mob -> this.nextAttack == 1, () -> this.drillPunch(false)));
        this.f_21345_.m_25352_(1, new AnimatedTriggerGoal<Veilguard>(this, 2, 50.0, 25.0, (double)(this.m_20205_() + 4.0f), mob -> this.nextAttack == 2, () -> this.smash(false)));
        this.f_21345_.m_25352_(1, new AnimatedMultiTriggerGoal<Veilguard>(this, 3, 60.0, (double)(this.m_20205_() + 4.0f), mob -> this.nextAttack == 3, new AnimatedMultiTriggerGoal.Triggerable(20, () -> this.drillPunch(true)), new AnimatedMultiTriggerGoal.Triggerable(25, () -> this.drillPunch(true)), new AnimatedMultiTriggerGoal.Triggerable(40, () -> this.smash(true))));
        this.f_21345_.m_25352_(2, new ActionStoppableMoveToTargetGoal<Veilguard>(this, 1.0, true, (double)(this.m_20205_() + 2.0f)));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{Veilguard.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, entity -> !(entity instanceof Veilguard)));
    }

    public void loopAttack() {
        this.nextAttack = 1 + this.f_19796_.m_188503_(3);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAction() == 1 && this.getAnimationTick() > 0 && this.getAnimationTick() < 45) {
            this.m_5496_((SoundEvent)CSSoundEvents.HEARTBEAT.get(), 0.15f, 1.5f);
            List<LivingEntity> targets = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(8.0)).stream().filter(e -> e != this).toList();
            for (LivingEntity target : targets) {
                Player player;
                if (target instanceof Player && (player = (Player)target).m_7500_()) continue;
                target.m_20256_(target.m_20184_().m_82549_(this.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_(0.05)));
            }
        }
    }

    public void smash(boolean isRage) {
        AABB aabb = new AABB(this.m_20182_().m_82492_(4.0, 2.0, 4.0), this.m_20182_().m_82520_(4.0, 2.0, 4.0)).m_82386_(0.0, 2.0, 0.0).m_82383_(this.m_20154_().m_82490_(3.5));
        List<LivingEntity> targets = this.m_9236_().m_45976_(LivingEntity.class, aabb).stream().filter(e -> e != this).toList();
        this.m_5496_((SoundEvent)CSSoundEvents.WIND_STRIKE.get(), 0.3f, 0.5f);
        this.m_5496_((SoundEvent)CSSoundEvents.BASS_PULSE.get(), 0.3f, 1.5f);
        this.m_5496_((SoundEvent)CSSoundEvents.GROUND_IMPACT_WATER.get(), 0.3f, 1.0f);
        for (int i = 0; i < 45; ++i) {
            for (int j = 0; j < 5; ++j) {
                Vec3 vec = this.m_20154_().m_82490_(3.5);
                ParticleUtil.sendParticle(this.m_9236_(), (SimpleParticleType)CSParticleTypes.RAINFALL_ENERGY_SMALL.get(), this.m_20182_().m_82520_(0.0, 0.25, 0.0).m_82520_(vec.m_7096_(), 0.0, vec.m_7094_()).m_82520_((double)(Mth.m_14031_((float)i) * (float)j), 0.0, (double)(Mth.m_14089_((float)i) * (float)j)), Vec3.f_82478_.m_82520_((double)Mth.m_14031_((float)i) * 0.05, 0.05, (double)Mth.m_14089_((float)i) * 0.05));
                ParticleUtil.sendParticle(this.m_9236_(), ParticleTypes.f_123759_, this.m_20182_().m_82520_(0.0, 0.25, 0.0).m_82520_(vec.m_7096_(), 0.0, vec.m_7094_()).m_82520_((double)(Mth.m_14031_((float)i) * (float)j), 0.0, (double)(Mth.m_14089_((float)i) * (float)j)), Vec3.f_82478_.m_82520_((double)Mth.m_14031_((float)i) * 0.05, 0.05, (double)Mth.m_14089_((float)i) * 0.05));
            }
        }
        for (LivingEntity target : targets) {
            if (!this.m_7327_((Entity)target)) continue;
            target.m_20256_(this.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_(-3.0));
        }
        if (isRage) {
            this.m_20256_(this.m_20154_().m_82541_().m_82490_(-3.5).m_82492_(0.0, 3.0, 0.0));
        }
        this.loopAttack();
    }

    public void drillPunch(boolean isRage) {
        AABB aabb = new AABB(this.m_20182_().m_82492_(2.0, 2.0, 2.0), this.m_20182_().m_82520_(2.0, 2.0, 2.0)).m_82386_(0.0, 2.0, 0.0).m_82383_(this.m_20154_().m_82490_(3.5));
        List<LivingEntity> targets = this.m_9236_().m_45976_(LivingEntity.class, aabb).stream().filter(e -> e != this).toList();
        this.m_5496_((SoundEvent)CSSoundEvents.WIND_STRIKE.get(), 0.3f, 0.5f);
        if (!targets.isEmpty()) {
            this.m_5496_((SoundEvent)CSSoundEvents.BASS_PULSE.get(), 0.3f, 1.5f);
            for (int i = 0; i < 90; ++i) {
                ParticleUtil.sendParticle(this.m_9236_(), (SimpleParticleType)CSParticleTypes.RAINFALL_BEAM.get(), this.m_20182_().m_82520_(0.0, 2.0, 0.0).m_82549_(this.m_20154_().m_82490_(3.5)), Vec3.f_82478_.m_82520_(this.f_19796_.m_188583_() * 0.2, this.f_19796_.m_188583_() * 0.2, this.f_19796_.m_188583_() * 0.2));
            }
        }
        for (LivingEntity target : targets) {
            if (!this.m_7327_((Entity)target)) continue;
            if (isRage) {
                target.m_20256_(this.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_(-1.5));
                target.f_19802_ = 0;
                continue;
            }
            target.m_20256_(this.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_(-3.0));
        }
        if (isRage) {
            this.m_20256_(this.m_20154_().m_82541_().m_82490_(1.25));
        } else {
            this.loopAttack();
        }
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)living.m_6336_());
            if (this.getAction() == 1) {
                f += living.m_21223_() * 0.2f;
            }
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            pEntity.m_20254_(i * 4);
        }
        if (flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
        }
        return flag;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 5, state -> {
            if (this.getAction() == 3) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.veilguard.rage"));
            }
            if (this.getAction() == 2) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.veilguard.smash"));
            }
            if (this.getAction() == 1) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.veilguard.attack"));
            }
            if (state.isMoving()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.veilguard.walk"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.veilguard.idle"));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void setAction(int action) {
        this.f_19804_.m_135381_(ACTION, (Object)action);
    }

    @Override
    public int getAction() {
        return (Integer)this.f_19804_.m_135370_(ACTION);
    }

    @Override
    public int getAnimationTick() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_TICK);
    }

    @Override
    public void setAnimationTick(int tick) {
        this.f_19804_.m_135381_(ANIMATION_TICK, (Object)tick);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTION, (Object)0);
        this.f_19804_.m_135372_(ANIMATION_TICK, (Object)0);
    }
}

