/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.attack.poltergeist;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.thecelestialworkshop.celestisynth.api.animation.player.PlayerAnimationContainer;
import org.thecelestialworkshop.celestisynth.api.item.AttackHurtTypes;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.attack.base.WeaponAttackInstance;
import org.thecelestialworkshop.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import org.thecelestialworkshop.celestisynth.common.entity.base.CSEffectEntity;
import org.thecelestialworkshop.celestisynth.common.entity.helper.CSVisualType;
import org.thecelestialworkshop.celestisynth.common.entity.skillcast.SkillCastPoltergeistWard;
import org.thecelestialworkshop.celestisynth.common.registry.CSEntityTypes;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;
import org.thecelestialworkshop.celestisynth.common.registry.CSVisualTypes;

public class PoltergeistCosmicSteelAttack
extends WeaponAttackInstance {
    public static final String IS_IMPACT_LARGE = "cs.isImpactLarge";
    public static final String QUEUE_COMBO_LARGE = "cs.queueComboLarge";
    public static final String SMASH_HEIGHT = "cs.poltergeistSmashHeight";
    public static final String SMASH_COUNT_FOR_PASSIVE = "cs.smashCountForPassive";

    public PoltergeistCosmicSteelAttack(Player player, ItemStack stack) {
        super(player, stack);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_POLTERGEIST_SMASH.get();
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public int getAttackStopTime() {
        return 20;
    }

    @Override
    public boolean getCondition() {
        return !this.player.m_6144_();
    }

    @Override
    public void startUsing() {
        this.useAndDamageItem(this.getStack(), this.level, (LivingEntity)this.player, 5);
        this.getTagExtras().m_128379_(QUEUE_COMBO_LARGE, false);
    }

    @Override
    public void tickAttack() {
        boolean isGiantImpact = this.getTagExtras().m_128471_(IS_IMPACT_LARGE);
        if (this.getTimerProgress() == 5 && this.getTagExtras().m_128471_(IS_IMPACT_LARGE)) {
            this.player.m_5997_(0.0, 1.0, 0.0);
        }
        if (this.getTimerProgress() == 18) {
            int groundY = this.getFloorPositionUnderPlayer(this.level, this.player.m_20183_()).m_123342_();
            this.player.m_20334_(0.0, (double)groundY - this.player.m_20186_(), 0.0);
            this.player.f_19789_ = 0.0f;
        }
        if (this.getTimerProgress() == 20) {
            CSVisualType crack = isGiantImpact ? (CSVisualType)CSVisualTypes.POLTERGEIST_IMPACT_CRACK_LARGE.get() : (CSVisualType)CSVisualTypes.POLTERGEIST_IMPACT_CRACK.get();
            double range = isGiantImpact ? 6.5 : 4.0;
            double xx = this.calculateXLook((LivingEntity)this.player) * 3.0;
            double zz = this.calculateZLook((LivingEntity)this.player) * 3.0;
            this.player.m_5496_(SoundEvents.f_11858_, 1.0f, 1.75f);
            this.player.m_5496_((SoundEvent)CSSoundEvents.LOUD_IMPACT.get(), 1.5f, 1.0f);
            CSEffectEntity.createInstance((LivingEntity)this.player, null, crack, xx, isGiantImpact ? -1.3 : -0.5, zz);
            this.doImpact(isGiantImpact, xx, zz, range);
            if (isGiantImpact) {
                if (!this.level.m_5776_()) {
                    SkillCastPoltergeistWard projectile = (SkillCastPoltergeistWard)((EntityType)CSEntityTypes.POLTERGEIST_WARD.get()).m_20615_(this.level);
                    projectile.setOwnerUUID(this.player.m_20148_());
                    projectile.m_6027_(this.player.m_20185_() + xx, this.player.m_20186_(), this.player.m_20189_() + zz);
                    this.level.m_7967_((Entity)projectile);
                }
                this.shakeScreensForNearbyPlayers((Entity)this.player, this.level, 24.0, 60, 30, 0.035f);
            } else {
                CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.POLTERGEIST_WARD_SUMMON_SMALL.get(), xx, 1.0, zz);
                this.shakeScreensForNearbyPlayers((Entity)this.player, this.level, 12.0, 30, 15, 0.01f);
            }
            this.addComboPoint(this.getStack(), this.player);
            if (this.getTagController().m_128451_(SMASH_HEIGHT) > 1) {
                this.player.m_36335_().m_41527_(this.getStack().m_41720_());
            }
            if (this.getTagExtras().m_128471_(QUEUE_COMBO_LARGE)) {
                this.player.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19596_, 80, 1));
                this.getTagExtras().m_128379_(IS_IMPACT_LARGE, true);
                this.getTagExtras().m_128379_(QUEUE_COMBO_LARGE, false);
            }
        }
    }

    public void doImpact(boolean isGiantImpact, double kbX, double kbZ, double range) {
        for (Entity entityBatch : this.iterateEntities(this.level, this.createAABB((Vec3i)this.player.m_20183_().m_7918_((int)kbX, 1, (int)kbZ), range))) {
            LivingEntity target;
            if (entityBatch instanceof LivingEntity && (target = (LivingEntity)entityBatch) != this.player && target.m_6084_() && !this.player.m_7307_((Entity)target)) {
                float dmgCalc = isGiantImpact ? 1.5f : 1.2f;
                float attributedDmg = this.calculateAttributeDependentDamage((LivingEntity)this.player, this.stack, dmgCalc);
                float smashHeightAdd = this.getTagController().m_128451_(SMASH_HEIGHT);
                this.initiateAbilityAttack((LivingEntity)this.player, target, attributedDmg + smashHeightAdd, AttackHurtTypes.NO_KB);
                target.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19597_, 20, 2));
                target.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19604_, 100, 0));
                target.f_19864_ = true;
                target.m_20334_((target.m_20185_() - (this.player.m_20185_() + kbX)) / 3.0, (target.m_20186_() - this.player.m_20186_()) / 3.0, (target.m_20189_() - (this.player.m_20189_() + kbZ)) / 3.0);
                CSWeaponUtil.disableRunningWeapon((Entity)target);
                if (!this.level.m_5776_()) {
                    CSEntityCapabilityProvider.get(target).ifPresent(data -> data.setPhantomTag((LivingEntity)this.player, 100));
                }
                if (target.m_21224_()) {
                    this.player.m_36335_().m_41527_(this.getStack().m_41720_());
                    this.getTagExtras().m_128379_(QUEUE_COMBO_LARGE, true);
                }
            }
            if (!(entityBatch instanceof Projectile)) continue;
            Projectile projectile = (Projectile)entityBatch;
            projectile.m_20334_(0.0, 1.2, 0.0);
        }
    }

    @Override
    public void stopUsing() {
        this.getTagController().m_128405_(SMASH_HEIGHT, 0);
        this.getTagExtras().m_128379_(QUEUE_COMBO_LARGE, false);
    }

    @Override
    public BlockPos getFloorPositionUnderPlayer(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        do {
            mutablePos.m_122173_(Direction.DOWN);
            this.getTagController().m_128405_(SMASH_HEIGHT, this.getTagController().m_128451_(SMASH_HEIGHT) + 1);
        } while (mutablePos.m_123342_() > level.m_141937_() && level.m_8055_((BlockPos)mutablePos).m_60647_((BlockGetter)level, (BlockPos)mutablePos, PathComputationType.LAND));
        return new BlockPos(mutablePos.m_123341_(), mutablePos.m_123342_(), mutablePos.m_123343_());
    }

    public void addComboPoint(ItemStack itemStack, Player player) {
        boolean isImpactLarge = this.attackExtras(itemStack).m_128471_(IS_IMPACT_LARGE);
        if (!isImpactLarge && this.attackExtras(itemStack).m_128451_(SMASH_COUNT_FOR_PASSIVE) < 9) {
            player.m_216990_(SoundEvents.f_11852_);
            this.attackExtras(itemStack).m_128405_(SMASH_COUNT_FOR_PASSIVE, this.attackExtras(itemStack).m_128451_(SMASH_COUNT_FOR_PASSIVE) + 1);
        } else if (!isImpactLarge && this.attackExtras(itemStack).m_128451_(SMASH_COUNT_FOR_PASSIVE) >= 9) {
            player.m_216990_(SoundEvents.f_11860_);
            this.attackExtras(itemStack).m_128379_(IS_IMPACT_LARGE, true);
        } else if (isImpactLarge) {
            this.attackExtras(itemStack).m_128379_(IS_IMPACT_LARGE, false);
            this.attackExtras(itemStack).m_128405_(SMASH_COUNT_FOR_PASSIVE, 0);
        }
    }
}

