/*
 * Decompiled with CFR 0.152.
 */
package org.thecelestialworkshop.celestisynth.common.attack.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.thecelestialworkshop.celestisynth.api.animation.player.AnimationManager;
import org.thecelestialworkshop.celestisynth.api.animation.player.PlayerAnimationContainer;
import org.thecelestialworkshop.celestisynth.api.item.CSWeaponUtil;
import org.thecelestialworkshop.celestisynth.common.registry.CSPlayerAnimations;
import org.thecelestialworkshop.celestisynth.common.registry.CSSoundEvents;

public abstract class WeaponAttackInstance
implements CSWeaponUtil {
    public final Player player;
    public final Level level;
    public final ItemStack stack;
    public final int heldDuration;
    public static final SoundEvent[] BASE_WEAPON_EFFECTS = new SoundEvent[]{(SoundEvent)CSSoundEvents.SWORD_SWING.get(), (SoundEvent)CSSoundEvents.SWORD_SWING_FIRE.get(), (SoundEvent)CSSoundEvents.AIR_SWING.get(), (SoundEvent)CSSoundEvents.SWORD_CLASH.get(), (SoundEvent)CSSoundEvents.FIRE_SHOOT.get(), (SoundEvent)CSSoundEvents.IMPACT_HIT.get()};

    public WeaponAttackInstance(Player player, ItemStack stack, int heldDuration) {
        this.player = player;
        this.level = player.m_9236_();
        this.stack = stack;
        this.heldDuration = heldDuration;
    }

    public WeaponAttackInstance(Player player, ItemStack stack) {
        this(player, stack, 0);
    }

    public abstract PlayerAnimationContainer getAnimation();

    public boolean sameAnimationForBothHands() {
        return false;
    }

    public abstract int getCooldown();

    public abstract int getAttackStopTime();

    public abstract boolean getCondition();

    public abstract void startUsing();

    public abstract void tickAttack();

    public abstract void stopUsing();

    public void baseStart() {
        this.startUsing();
    }

    public void baseStop() {
        this.stopUsing();
        AnimationManager.playAnimation(this.level, (PlayerAnimationContainer)CSPlayerAnimations.CLEAR.get());
        AnimationManager.playAnimation(this.level, (PlayerAnimationContainer)CSPlayerAnimations.CLEAR.get(), 2);
        this.getTagController().m_128405_("cs.AttackIndex", -1);
        this.getTagController().m_128405_("cs.animationTimer", 0);
        this.getTagController().m_128379_("cs.hasAnimationBegun", false);
        this.player.m_5810_();
    }

    public void baseTickSkill() {
        this.tickAttack();
        if (this.getTimerProgress() >= this.getAttackStopTime()) {
            this.baseStop();
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getHeldDuration() {
        return this.heldDuration;
    }

    public int getTimerProgress() {
        return this.getTagController().m_128451_("cs.animationTimer");
    }

    public CompoundTag getTagController() {
        return this.stack.m_41698_("csController");
    }

    public CompoundTag getTagExtras() {
        return this.stack.m_41698_("csExtras");
    }

    public static void playRandomBladeSound(Entity entity, int length) {
        SoundEvent randomSound = BASE_WEAPON_EFFECTS[entity.m_9236_().m_213780_().m_188503_(length)];
        entity.m_5496_(randomSound, 0.15f, 0.5f + entity.m_9236_().m_213780_().m_188501_());
    }
}

