/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.client;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.client.GatewayParticle;
import dev.shadowsoffire.gateways.client.GatewayRenderer;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.item.GatePearlItem;
import dev.shadowsoffire.placebo.PlaceboClient;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT}, modid="gateways")
public class GatewaysClient {
    static int scrollIdx = 0;
    private static ItemStack currentTooltipItem = ItemStack.f_41583_;
    private static long tooltipTick = 0L;
    static RandomSource rand = RandomSource.m_216327_();
    public static final ResourceLocation BARS = new ResourceLocation("textures/gui/bars.png");

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        e.enqueueWork(() -> ItemProperties.register((Item)((Item)GatewayObjects.GATE_PEARL.get()), (ResourceLocation)new ResourceLocation("gateways", "size"), (stack, level, entity, seed) -> {
            DynamicHolder<Gateway> gate = GatePearlItem.getGate(stack);
            if (gate.isBound()) {
                return ((Gateway)gate.get()).size().ordinal();
            }
            return 2.0f;
        }));
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::bossRenderPre);
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::tooltip);
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::scroll);
        MinecraftForge.EVENT_BUS.addListener(GatewaysClient::scroll2);
    }

    @SubscribeEvent
    public static void colors(RegisterColorHandlersEvent.Item e) {
        e.register((stack, tint) -> {
            DynamicHolder<Gateway> gate = GatePearlItem.getGate(stack);
            if (gate.isBound()) {
                return ((Gateway)gate.get()).color().m_131265_();
            }
            return 0xAAAAFF;
        }, new ItemLike[]{(ItemLike)GatewayObjects.GATE_PEARL.get()});
    }

    @SubscribeEvent
    public static void eRenders(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer((EntityType)GatewayObjects.NORMAL_GATEWAY.get(), GatewayRenderer::new);
        e.registerEntityRenderer((EntityType)GatewayObjects.ENDLESS_GATEWAY.get(), GatewayRenderer::new);
    }

    @SubscribeEvent
    public static void factories(RegisterParticleProvidersEvent e) {
        e.registerSprite((ParticleType)GatewayObjects.GLOW.get(), GatewayParticle::new);
    }

    public static void scroll(ScreenEvent.MouseScrolled.Pre e) {
        if (currentTooltipItem.m_41720_() == GatewayObjects.GATE_PEARL.get() && tooltipTick == PlaceboClient.ticks && Screen.m_96638_()) {
            scrollIdx += e.getScrollDelta() < 0.0 ? 1 : -1;
            e.setCanceled(true);
        }
    }

    public static void scroll2(InputEvent.MouseScrollingEvent e) {
        if (currentTooltipItem.m_41720_() == GatewayObjects.GATE_PEARL.get() && tooltipTick == PlaceboClient.ticks && Screen.m_96638_()) {
            scrollIdx += e.getScrollDelta() < 0.0 ? 1 : -1;
            e.setCanceled(true);
        }
    }

    public static void tooltip(ItemTooltipEvent e) {
        currentTooltipItem = e.getItemStack();
        tooltipTick = PlaceboClient.ticks;
    }

    public static void bossRenderPre(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent boss = event.getBossEvent();
        String name = boss.m_18861_().getString();
        if (name.startsWith("GATEWAY_ID")) {
            GatewayEntity gate;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            event.setCanceled(true);
            Entity entity = level.m_6815_(Integer.valueOf(name.substring(10)).intValue());
            if (entity instanceof GatewayEntity && (gate = (GatewayEntity)entity).isValid()) {
                gate.getGateway().renderBossBar(gate, event.getGuiGraphics(), event.getX(), event.getY(), false);
                event.setIncrement(event.getIncrement() * 2);
            }
        }
    }

    public static void drawReversedDropShadow(GuiGraphics gfx, Font font, Component comp, int x, int y) {
        gfx.m_280614_(font, comp, x, y, 0, false);
        PoseStack pose = gfx.m_280168_();
        pose.m_85836_();
        pose.m_85837_(1.0, 1.0, 0.03);
        int color = comp.m_7383_().m_131135_().m_131265_();
        int r = (color >> 16 & 0xFF) / 4;
        int g = (color >> 8 & 0xFF) / 4;
        int b = (color & 0xFF) / 4;
        color = 0xFF000000 | r << 16 | g << 8 | b;
        gfx.m_280056_(font, comp.getString(), x, y, color, false);
        pose.m_85849_();
    }
}

