/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.compatibility.IFurnaceRecipes;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class FurnaceRecipes
implements IFurnaceRecipes {
    private static FurnaceRecipes instance;
    private Map<ItemStorage, RecipeStorage> recipes = new HashMap<ItemStorage, RecipeStorage>();
    private Map<ItemStorage, RecipeStorage> reverseRecipes = new HashMap<ItemStorage, RecipeStorage>();

    public void loadRecipes(RecipeManager recipeManager, Level level) {
        this.recipes.clear();
        this.reverseRecipes.clear();
        recipeManager.m_44054_(RecipeType.f_44108_).values().forEach(recipe -> {
            NonNullList list = recipe.m_7527_();
            if (list.size() == 1) {
                for (ItemStack smeltable : ((Ingredient)list.get(0)).m_43908_()) {
                    if (smeltable.m_41619_()) continue;
                    RecipeStorage storage = RecipeStorage.builder().withInputs((List<ItemStorage>)ImmutableList.of((Object)new ItemStorage(smeltable))).withPrimaryOutput(recipe.m_8043_(level.m_9598_())).withGridSize(1).withIntermediate(Blocks.f_50094_).withRecipeId(recipe.m_6423_()).build();
                    this.recipes.put(storage.getCleanedInput().get(0), storage);
                    ItemStack output = recipe.m_8043_(level.m_9598_()).m_41777_();
                    output.m_41764_(1);
                    this.reverseRecipes.put(new ItemStorage(output), storage);
                }
            }
        });
    }

    @Override
    public ItemStack getSmeltingResult(ItemStack itemStack) {
        RecipeStorage storage = this.recipes.getOrDefault(new ItemStorage(itemStack), null);
        if (storage != null) {
            return storage.getPrimaryOutput();
        }
        return ItemStack.f_41583_;
    }

    @Override
    @Nullable
    public RecipeStorage getFirstSmeltingRecipeByResult(ItemStorage storage) {
        return this.reverseRecipes.get(storage);
    }

    public static FurnaceRecipes getInstance() {
        if (instance == null) {
            instance = new FurnaceRecipes();
        }
        return instance;
    }
}

