/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.quests.objectives;

import com.google.gson.JsonObject;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IObjectiveInstance;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.event.QuestObjectiveEventHandler;
import com.minecolonies.core.quests.objectives.DialogueObjectiveTemplateTemplate;
import com.minecolonies.core.quests.objectives.IKillEntityObjectiveTemplate;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillEntityObjectiveTemplateTemplate
extends DialogueObjectiveTemplateTemplate
implements IKillEntityObjectiveTemplate {
    private final int entitiesToKill;
    private final EntityType<?> entityToKill;
    private final int nextObjective;

    public KillEntityObjectiveTemplateTemplate(int target, int entitiesToKill, EntityType<?> entityToKill, int nextObjective, List<Integer> rewards) {
        super(target, KillEntityObjectiveTemplateTemplate.buildDialogueTree(entityToKill), rewards);
        this.entitiesToKill = entitiesToKill;
        this.nextObjective = nextObjective;
        this.entityToKill = entityToKill;
    }

    @NotNull
    private static IDialogueObjectiveTemplate.DialogueElement buildDialogueTree(EntityType<?> entityToKill) {
        MutableComponent text = Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.kill", (Object[])new Object[]{entityToKill.m_20676_()});
        IDialogueObjectiveTemplate.AnswerElement answer1 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.later"), new IQuestDialogueAnswer.CloseUIDialogueAnswer());
        IDialogueObjectiveTemplate.AnswerElement answer2 = new IDialogueObjectiveTemplate.AnswerElement((Component)Component.m_237115_((String)"com.minecolonies.coremod.questobjectives.answer.cancel"), new IQuestDialogueAnswer.QuestCancellationDialogueAnswer());
        return new IDialogueObjectiveTemplate.DialogueElement((Component)text, List.of(answer1, answer2));
    }

    public static IQuestObjectiveTemplate createObjective(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        int quantity = details.get("qty").getAsInt();
        EntityType entityType = (EntityType)((Holder)ForgeRegistries.ENTITY_TYPES.getHolder(new ResourceLocation(details.get("entity-type").getAsString())).get()).get();
        int nextObj = details.has("next-objective") ? details.get("next-objective").getAsInt() : -1;
        return new KillEntityObjectiveTemplateTemplate(target, quantity, entityType, nextObj, KillEntityObjectiveTemplateTemplate.parseRewards(jsonObject));
    }

    @Override
    public IObjectiveInstance startObjective(IQuestInstance colonyQuest) {
        super.startObjective(colonyQuest);
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.addKillQuestObjectiveListener(this.entityToKill, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
        return this.createObjectiveInstance();
    }

    @Override
    public Component getProgressText(IQuestInstance quest, Style style) {
        IObjectiveInstance iObjectiveInstance = quest.getCurrentObjectiveInstance();
        if (iObjectiveInstance instanceof EntityKillProgressInstance) {
            EntityKillProgressInstance progress = (EntityKillProgressInstance)iObjectiveInstance;
            return Component.m_237110_((String)"com.minecolonies.coremod.questobjectives.kill.progress", (Object[])new Object[]{progress.currentProgress, this.entitiesToKill, this.entityToKill.m_20676_().m_6879_().m_6270_(style)});
        }
        return Component.m_237119_();
    }

    @Override
    @Nullable
    public IObjectiveInstance createObjectiveInstance() {
        return new EntityKillProgressInstance(this);
    }

    @Override
    public void onCancellation(IQuestInstance colonyQuest) {
        this.cleanupListener(colonyQuest);
    }

    private void cleanupListener(IQuestInstance colonyQuest) {
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.removeKillQuestObjectiveListener(this.entityToKill, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
    }

    @Override
    public void onEntityKill(IObjectiveInstance killProgressData, IQuestInstance colonyQuest, Player player) {
        if (killProgressData.isFulfilled()) {
            return;
        }
        ++((EntityKillProgressInstance)killProgressData).currentProgress;
        if (killProgressData.isFulfilled()) {
            this.cleanupListener(colonyQuest);
            colonyQuest.advanceObjective(player, this.nextObjective);
        }
    }

    @Override
    public void onWorldLoad(IQuestInstance colonyQuest) {
        super.onWorldLoad(colonyQuest);
        if (colonyQuest.getColony() instanceof Colony) {
            QuestObjectiveEventHandler.addKillQuestObjectiveListener(this.entityToKill, colonyQuest.getAssignedPlayer(), colonyQuest);
        }
    }

    private static class EntityKillProgressInstance
    implements IObjectiveInstance {
        private final KillEntityObjectiveTemplateTemplate template;
        private int currentProgress = 0;

        public EntityKillProgressInstance(KillEntityObjectiveTemplateTemplate template) {
            this.template = template;
        }

        @Override
        public boolean isFulfilled() {
            return this.currentProgress >= this.template.entitiesToKill;
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("quantity", this.currentProgress);
            return compoundTag;
        }

        @Override
        public int getMissingQuantity() {
            return this.template.entitiesToKill > this.currentProgress ? this.template.entitiesToKill - this.currentProgress : 0;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.currentProgress = nbt.m_128451_("quantity");
        }
    }
}

