/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.api.util.ItemStackUtils;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HutPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.m_60734_() instanceof AbstractBlockHut;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Blueprint blueprint, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, PlacementSettings settings) {
        if (world.m_8055_(pos).equals(blockState)) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (!WorldUtil.setBlockState((LevelAccessor)world, pos, blockState, 3)) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (tileEntityData != null) {
            try {
                PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (PlacementSettings)settings);
                BlockEntity be = world.m_7702_(pos);
                if (be != null) {
                    if (pos.equals((Object)centerPos)) {
                        String location = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(blueprint.getFilePath().resolve(blueprint.getFileName()));
                        ((IBlueprintDataProviderBE)be).setBlueprintPath(location);
                    } else if (!((IBlueprintDataProviderBE)be).getPositionedTags().getOrDefault(BlockPos.f_121853_, Collections.emptyList()).contains("invisible")) {
                        String partialPath;
                        if (((IBlueprintDataProviderBE)be).getSchematicName().isEmpty()) {
                            String[] elements = Utils.splitPath(((IBlueprintDataProviderBE)be).getBlueprintPath());
                            partialPath = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(blueprint.getFilePath().resolve(elements[elements.length - 1].replace(".blueprint", "")));
                        } else {
                            partialPath = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(Utils.resolvePath(blueprint.getFilePath(), ((IBlueprintDataProviderBE)be).getSchematicName()));
                        }
                        if (!(world.m_7702_(centerPos) instanceof TileEntityColonyBuilding) && be instanceof TileEntityColonyBuilding) {
                            ((IBlueprintDataProviderBE)be).setBlueprintPath(partialPath.substring(0, partialPath.length() - 1) + "1.blueprint");
                            ((TileEntityColonyBuilding)be).setSchematicName("");
                        } else {
                            ((IBlueprintDataProviderBE)be).setBlueprintPath(partialPath + ".blueprint");
                        }
                    }
                    ((IBlueprintDataProviderBE)be).setPackName(blueprint.getPackName());
                    if (!complete) {
                        blockState.m_60734_().m_6402_(world, pos, blockState, null, BlockUtils.getItemStackFromBlockState((BlockState)blockState));
                    }
                }
            }
            catch (Exception ex) {
                Log.getLogger().warn("Unable to place TileEntity");
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (blockState.m_60734_() != ModBlocks.blockHutBarracksTower) {
            itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        }
        if (tileEntityData != null) {
            itemList.addAll(ItemStackUtils.getItemStacksOfTileEntity((CompoundTag)tileEntityData, (BlockState)blockState));
        }
        itemList.removeIf(ItemStackUtils::isEmpty);
        return itemList;
    }
}

