/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.map.WindowColonyMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ColonyListMessage
implements IMessage {
    List<IColony> colonies = new ArrayList<IColony>();
    List<ColonyInfo> colonyInfo = new ArrayList<ColonyInfo>();

    public ColonyListMessage() {
    }

    public ColonyListMessage(List<IColony> colonies) {
        this.colonies = colonies;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyInfo = new ArrayList<ColonyInfo>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            ColonyInfo info = new ColonyInfo(buf.readInt());
            info.center = buf.m_130135_();
            info.name = buf.m_130136_(Short.MAX_VALUE);
            info.citizencount = buf.readInt();
            info.owner = buf.m_130136_(Short.MAX_VALUE);
            this.colonyInfo.add(info);
        }
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.colonies.size());
        for (IColony colony : this.colonies) {
            buf.writeInt(colony.getID());
            buf.m_130064_(colony.getCenter());
            buf.m_130070_(colony.getName());
            buf.writeInt(colony.getCitizenManager().getCurrentCitizenCount());
            buf.m_130070_(colony.getPermissions().getOwnerName());
        }
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!isLogicalServer) {
            WindowColonyMap.setColonies(this.colonyInfo);
        } else if (ctxIn.getSender() != null) {
            Network.getNetwork().sendToPlayer(new ColonyListMessage(IColonyManager.getInstance().getColonies(ctxIn.getSender().f_19853_)), ctxIn.getSender());
        }
    }

    public static class ColonyInfo {
        private final int id;
        private BlockPos center;
        private String name;
        private int citizencount;
        private String owner;

        public ColonyInfo(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public BlockPos getCenter() {
            return this.center;
        }

        public String getName() {
            return this.name;
        }

        public int getCitizencount() {
            return this.citizencount;
        }

        public String getOwner() {
            return this.owner;
        }
    }
}

