/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateClientWithCompatibilityMessage
implements IMessage {
    private FriendlyByteBuf buffer;

    public UpdateClientWithCompatibilityMessage() {
    }

    public UpdateClientWithCompatibilityMessage(boolean dummy) {
        this.buffer = new FriendlyByteBuf(Unpooled.buffer());
        IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().serialize(this.buffer);
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.buffer = new FriendlyByteBuf(buf.retain());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        this.buffer.resetReaderIndex();
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        try {
            IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().deserialize(this.buffer, world);
        }
        catch (Exception e) {
            Log.getLogger().error("Failed to load compatibility manager", (Throwable)e);
        }
        this.buffer.release();
    }
}

