/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.ISearchPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PathJobCanSee
extends AbstractPathJob
implements ISearchPathJob {
    private final LivingEntity lookTarget;
    private final BlockPos searchAroundPos;

    public PathJobCanSee(Mob searchingEntity, LivingEntity lookTarget, Level world, @NotNull BlockPos searchAroundPos, int range) {
        super(world, PathfindingUtils.prepareStart((LivingEntity)searchingEntity), range, new PathResult(), searchingEntity);
        this.searchAroundPos = searchAroundPos;
        this.lookTarget = lookTarget;
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.searchAroundPos.m_123341_(), this.searchAroundPos.m_123342_(), this.searchAroundPos.m_123343_(), x, y, z);
    }

    @Override
    protected boolean isAtDestination(MNode n) {
        if (this.searchAroundPos.m_123342_() - n.y > 2) {
            return false;
        }
        return this.canSeeTargetFromPos((BlockPos)this.tempWorldPos.m_122178_(n.x, n.y, n.z)) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    public double getEndNodeScore(@NotNull MNode n) {
        return BlockPosUtil.distManhattan(this.start, n.x, n.y, n.z);
    }

    private boolean canSeeTargetFromPos(BlockPos pos) {
        Vec3 vec3d1;
        Vec3 vec3d = new Vec3((double)pos.m_123341_(), (double)((float)pos.m_123342_() + this.entity.m_20192_()), (double)pos.m_123343_());
        return this.world.m_45547_(new ClipContext(vec3d, vec3d1 = new Vec3(this.lookTarget.m_20185_(), this.lookTarget.m_20188_(), this.lookTarget.m_20189_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity)).m_6662_() == HitResult.Type.MISS;
    }
}

