/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CitizenExperienceHandler
implements ICitizenExperienceHandler {
    public static final int PRIMARY_DEPENDENCY_SHARE = 10;
    public static final int SECONDARY_DEPENDENCY_SHARE = 5;
    public static final int MAX_XP_PICKUP_ATTEMPTS = 5;
    private final AbstractEntityCitizen citizen;
    private int counterMovedXp = 0;

    public CitizenExperienceHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void updateLevel() {
        if (this.citizen.getCitizenData().getJob() != null) {
            this.citizen.getCitizenData().getJob().onLevelUp();
        }
    }

    @Override
    public void addExperience(double xp) {
        IBuilding home = this.citizen.getCitizenColonyHandler().getHomeBuilding();
        double citizenHutLevel = home == null ? 0.0 : (double)home.getBuildingLevel();
        ICitizenData data = this.citizen.getCitizenData();
        IBuilding workBuilding = data.getWorkBuilding();
        if (workBuilding == null || !workBuilding.hasModule(WorkerBuildingModule.class)) {
            return;
        }
        double workBuildingLevel = workBuilding.getBuildingLevel();
        double buildingXPModifier = 1.0 + (workBuildingLevel + citizenHutLevel) / 10.0;
        double localXp = xp * buildingXPModifier;
        double saturation = this.citizen.getCitizenData().getSaturation();
        int intelligenceLevel = data.getCitizenSkillHandler().getLevel(Skill.Intelligence);
        localXp += localXp * ((double)intelligenceLevel / 100.0);
        if (saturation <= 0.0) {
            return;
        }
        WorkerBuildingModule module = (WorkerBuildingModule)workBuilding.getModuleMatching(WorkerBuildingModule.class, m -> m.getAssignedCitizen().contains(data));
        Skill primary = module.getPrimarySkill();
        Skill secondary = module.getSecondarySkill();
        data.getCitizenSkillHandler().addXpToSkill(primary, localXp *= 1.0 + this.citizen.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.LEVELING), data);
        if (primary.getComplimentary() != null) {
            data.getCitizenSkillHandler().addXpToSkill(primary.getComplimentary(), localXp / 10.0, data);
        }
        if (primary.getAdverse() != null) {
            data.getCitizenSkillHandler().removeXpFromSkill(primary.getAdverse(), localXp / 10.0, data);
        }
        data.getCitizenSkillHandler().addXpToSkill(secondary, localXp / 2.0, data);
        if (secondary.getComplimentary() != null) {
            data.getCitizenSkillHandler().addXpToSkill(secondary.getComplimentary(), localXp / 20.0, data);
        }
        if (secondary.getAdverse() != null) {
            data.getCitizenSkillHandler().removeXpFromSkill(secondary.getAdverse(), localXp / 20.0, data);
        }
    }

    @Override
    public void dropExperience() {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).f_46443_ && this.citizen.getRecentlyHit() > 0 && this.citizen.checkCanDropLoot() && CompatibilityUtils.getWorldFromCitizen(this.citizen).m_46469_().m_46207_(GameRules.f_46135_)) {
            int j;
            for (int experience = (int)this.citizen.getCitizenData().getCitizenSkillHandler().getTotalXP(); experience > 0; experience -= j) {
                j = ExperienceOrb.m_20782_((int)experience);
                CompatibilityUtils.getWorldFromCitizen(this.citizen).m_7967_((Entity)new ExperienceOrb(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.m_20185_(), this.citizen.m_20186_(), this.citizen.m_20189_(), j));
            }
        }
        int i = 0;
        while ((double)i < 20.0) {
            double d2 = this.citizen.m_217043_().m_188583_() * 0.02;
            double d0 = this.citizen.m_217043_().m_188583_() * 0.02;
            double d1 = this.citizen.m_217043_().m_188583_() * 0.02;
            CompatibilityUtils.getWorldFromCitizen(this.citizen).m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.citizen.m_20185_() + this.citizen.m_217043_().m_188500_() * (double)this.citizen.m_20205_() * 2.0 - (double)this.citizen.m_20205_(), this.citizen.m_20186_() + this.citizen.m_217043_().m_188500_() * (double)this.citizen.m_20206_(), this.citizen.m_20189_() + this.citizen.m_217043_().m_188500_() * (double)this.citizen.m_20205_() * 2.0 - (double)this.citizen.m_20205_(), d2, d0, d1);
            ++i;
        }
    }

    @Override
    public void gatherXp() {
        if (this.citizen.f_19853_.f_46443_) {
            return;
        }
        int growSize = this.counterMovedXp > 0 || this.citizen.m_217043_().m_188503_(100) < 20 ? 4 : 2;
        AABB box = this.citizen.m_20191_().m_82400_((double)growSize);
        if (!WorldUtil.isAABBLoaded(this.citizen.f_19853_, box)) {
            return;
        }
        boolean movedXp = false;
        for (ExperienceOrb orb : this.citizen.f_19853_.m_45976_(ExperienceOrb.class, box)) {
            if (orb.f_19797_ < 5) continue;
            Vec3 vec3d = new Vec3(this.citizen.m_20185_() - orb.m_20185_(), this.citizen.m_20186_() + (double)this.citizen.m_20192_() / 2.0 - orb.m_20186_(), this.citizen.m_20189_() - orb.m_20189_());
            double d1 = vec3d.m_82556_();
            if (d1 < 1.0) {
                localXp = orb.m_20801_();
                localXp = CitizenItemUtils.applyMending(this.citizen, localXp);
                this.addExperience(localXp);
                orb.m_142687_(Entity.RemovalReason.DISCARDED);
                this.counterMovedXp = 0;
            } else if (this.counterMovedXp > 5) {
                localXp = orb.m_20801_();
                localXp = CitizenItemUtils.applyMending(this.citizen, localXp);
                this.addExperience(localXp);
                orb.m_142687_(Entity.RemovalReason.DISCARDED);
                this.counterMovedXp = 0;
                return;
            }
            double d2 = 1.0 - Math.sqrt(d1) / 8.0;
            orb.m_20256_(orb.m_20184_().m_82549_(vec3d.m_82541_().m_82490_(d2 * d2 * 0.1)));
            movedXp = true;
            ++this.counterMovedXp;
        }
        if (!movedXp) {
            this.counterMovedXp = 0;
        }
    }
}

