/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.service;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.items.IMinecoloniesFoodItem;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.RestaurantMenuModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobCook;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIUsesFurnace;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCook
extends AbstractEntityAIUsesFurnace<JobCook, BuildingCook> {
    public static final int SATURATION_TO_SERVE = 16;
    private static final int SERVE_DELAY = 30;
    private static final int LEVEL_TO_FEED_PLAYER = 10;
    private final Queue<AbstractEntityCitizen> citizenToServe = new ArrayDeque<AbstractEntityCitizen>();
    private final Queue<Player> playerToServe = new ArrayDeque<Player>();
    private static final VisibleCitizenStatus COOK = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/cook.png"), "com.minecolonies.gui.visiblestatus.cook");

    public EntityAIWorkCook(@NotNull JobCook job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.COOK_SERVE_FOOD_TO_CITIZEN, this::serveFoodToCitizen, 30), new AITarget<Object>(AIWorkerState.COOK_SERVE_FOOD_TO_PLAYER, this::serveFoodToPlayer, 30));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingCook> getExpectedBuildingClass() {
        return BuildingCook.class;
    }

    @Override
    protected void extractFromFurnace(FurnaceBlockEntity furnace) {
        InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((Container)furnace), 2, (IItemHandler)this.worker.getInventoryCitizen());
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.incrementActionsDoneAndDecSaturation();
    }

    @Override
    public IAIState startWorking() {
        return super.startWorking();
    }

    @Override
    protected boolean isSmeltable(ItemStack stack) {
        return ItemStackUtils.ISCOOKABLE.test(stack) && ((BuildingCook)this.building).getModule(BuildingModules.RESTAURANT_MENU).getMenu().contains(new ItemStorage(MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack)));
    }

    @Override
    protected boolean reachedMaxToKeep() {
        if (super.reachedMaxToKeep()) {
            return true;
        }
        int buildingLimit = Math.max(1, ((BuildingCook)this.building).getBuildingLevel() * ((BuildingCook)this.building).getBuildingLevel()) * 9;
        return InventoryUtils.getCountFromBuildingWithLimit(this.building, FoodUtils.EDIBLE.and(stack -> FoodUtils.canEatLevel(stack, ((BuildingCook)this.building).getBuildingLevel() - 1)), stack -> stack.m_41741_() * 6) > buildingLimit;
    }

    @Override
    public void requestSmeltable() {
        RestaurantMenuModule menuModule = ((BuildingCook)this.building).getModule(BuildingModules.RESTAURANT_MENU);
        if (menuModule.getMenu().isEmpty() && this.worker.getCitizenData() != null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.nofood"), ChatPriority.BLOCKING));
        }
    }

    private IAIState serveFoodToCitizen() {
        if (this.citizenToServe.isEmpty()) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(COOK);
        if (!((BuildingCook)this.building).isInBuilding(this.citizenToServe.peek().m_20183_())) {
            this.worker.getNavigation().m_26573_();
            this.citizenToServe.poll();
            return this.getState();
        }
        if (!this.walkToWorkPos(this.citizenToServe.peek().m_20183_())) {
            return this.getState();
        }
        AbstractEntityCitizen citizen = this.citizenToServe.poll();
        InventoryCitizen handler = citizen.getInventoryCitizen();
        RestaurantMenuModule module = (RestaurantMenuModule)this.worker.getCitizenData().getWorkBuilding().getModule(BuildingModules.RESTAURANT_MENU);
        Predicate<ItemStack> canEatPredicate = stack -> module.getMenu().contains(new ItemStorage((ItemStack)stack));
        ICitizenData citizenData = citizen.getCitizenData();
        if (!handler.hasSpace()) {
            int foodSlot;
            for (int feedingAttempts = 0; feedingAttempts < 10 && (foodSlot = FoodUtils.getBestFoodForCitizen(this.worker.getInventoryCitizen(), citizenData, module.getMenu())) != -1; ++feedingAttempts) {
                ItemStack stack2 = this.worker.getInventoryCitizen().extractItem(foodSlot, 1, false);
                citizenData.increaseSaturation(FoodUtils.getFoodValue(stack2, this.worker));
                this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("food_served", this.worker.getCitizenColonyHandler().getColonyOrRegister().getDay());
                StatsUtil.trackStatByStack(this.building, "food_served_detail", stack2, 1);
                if (citizenData.getSaturation() >= 20.0) break;
            }
            return this.getState();
        }
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)handler, canEatPredicate)) {
            return this.getState();
        }
        int foodSlot = FoodUtils.getBestFoodForCitizen(this.worker.getInventoryCitizen(), citizenData, module.getMenu());
        if (foodSlot == -1) {
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), canEatPredicate) <= 0) {
                this.citizenToServe.clear();
                return AIWorkerState.START_WORKING;
            }
            return this.getState();
        }
        if (citizenData.getHomeBuilding() != null && citizenData.getHomeBuilding().getBuildingLevel() > ((BuildingCook)this.building).getBuildingLevel() + 1) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.core.restaurant.poorrestaurant"), ChatPriority.BLOCKING));
        }
        String foodName = this.worker.getInventoryCitizen().getStackInSlot(foodSlot).m_41778_();
        int qty = (int)Math.max(1.0, (20.0 - citizen.getCitizenData().getSaturation()) / FoodUtils.getFoodValue(this.worker.getInventoryCitizen().getStackInSlot(foodSlot), citizen));
        if (InventoryUtils.transferXOfItemStackIntoNextFreeSlotInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), foodSlot, qty, (IItemHandler)citizenData.getInventory())) {
            this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().incrementBy("food_served", qty, this.worker.getCitizenColonyHandler().getColonyOrRegister().getDay());
            StatsUtil.trackStatByName((IBuilding)this.building, "food_served_detail", foodName, qty);
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            this.worker.decreaseSaturationForAction();
        }
        return this.getState();
    }

    private IAIState serveFoodToPlayer() {
        if (this.playerToServe.isEmpty()) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(COOK);
        if (!((BuildingCook)this.building).isInBuilding(this.playerToServe.peek().m_20183_())) {
            this.worker.getNavigation().m_26573_();
            this.playerToServe.poll();
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(this.playerToServe.peek().m_20183_())) {
            return this.getState();
        }
        Player player = this.playerToServe.poll();
        InvWrapper handler = new InvWrapper((Container)player.m_150109_());
        RestaurantMenuModule module = (RestaurantMenuModule)this.worker.getCitizenData().getWorkBuilding().getModule(BuildingModules.RESTAURANT_MENU);
        Predicate<ItemStack> canEatPredicate = stack -> module.getMenu().contains(new ItemStorage((ItemStack)stack));
        if (InventoryUtils.isItemHandlerFull((IItemHandler)handler)) {
            return this.getState();
        }
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)handler, canEatPredicate)) {
            return this.getState();
        }
        Object2IntMap<ItemStack> transferredItemMap = InventoryUtils.transferFoodUpToSaturation((ICapabilityProvider)this.worker, (IItemHandler)handler, ((BuildingCook)this.building).getBuildingLevel() * 16, canEatPredicate);
        int count = 0;
        IntIterator intIterator = transferredItemMap.values().iterator();
        while (intIterator.hasNext()) {
            int v = (Integer)intIterator.next();
            count += v;
        }
        if (count <= 0) {
            this.playerToServe.clear();
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().incrementBy("food_served", count, this.worker.getCitizenColonyHandler().getColonyOrRegister().getDay());
        StatsUtil.trackStatByStackMap(this.building, "food_served_detail", transferredItemMap);
        MessageUtils.format("com.minecolonies.coremod.cook.serve.player", this.worker.m_7755_().getString()).sendTo(player);
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.START_WORKING;
    }

    private boolean canEat(ItemStack stack, AbstractEntityCitizen citizen) {
        IBuilding building;
        RestaurantMenuModule module = (RestaurantMenuModule)this.worker.getCitizenData().getWorkBuilding().getModule(BuildingModules.RESTAURANT_MENU);
        if (!module.getMenu().contains(new ItemStorage(stack))) {
            return false;
        }
        if (citizen != null && (building = citizen.getCitizenData().getHomeBuilding()) != null) {
            return building.canEat(stack);
        }
        return true;
    }

    @Override
    protected IAIState checkForImportantJobs() {
        List<Player> playerList = WorldUtil.getEntitiesWithinBuilding(this.world, Player.class, this.building, player -> player != null && player.m_36324_().m_38702_() < 10 && ((BuildingCook)this.building).getColony().getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS));
        this.playerToServe.addAll(playerList);
        RestaurantMenuModule module = (RestaurantMenuModule)this.worker.getCitizenData().getWorkBuilding().getModule(BuildingModules.RESTAURANT_MENU);
        if (((BuildingCook)this.building).getBuildingLevel() >= 3) {
            boolean hasMinecoloniesFoodInMenu = false;
            for (ItemStorage menuItem : module.getMenu()) {
                if (!(menuItem.getItem() instanceof IMinecoloniesFoodItem)) continue;
                hasMinecoloniesFoodInMenu = true;
                break;
            }
            if (!hasMinecoloniesFoodInMenu) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.core.restaurant.poormenu"), ChatPriority.BLOCKING));
            }
        }
        for (EntityCitizen citizen : WorldUtil.getEntitiesWithinBuilding(this.world, EntityCitizen.class, this.building, null)) {
            if (citizen.getCitizenJobHandler().getColonyJob() instanceof JobCook || !this.shouldBeFed(citizen) || InventoryUtils.hasItemInItemHandler(citizen.getItemHandlerCitizen(), stack -> this.canEat((ItemStack)stack, citizen))) continue;
            if (FoodUtils.hasBestOptionInInv(this.worker.getInventoryCitizen(), citizen.getCitizenData(), module.getMenu(), this.building)) {
                this.citizenToServe.add(citizen);
                continue;
            }
            ItemStorage storage = FoodUtils.checkForFoodInBuilding(citizen.getCitizenData(), module.getMenu(), this.building);
            if (storage == null) continue;
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(stack -> new ItemStorage((ItemStack)stack).equals(storage), 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (!this.citizenToServe.isEmpty()) {
            return AIWorkerState.COOK_SERVE_FOOD_TO_CITIZEN;
        }
        if (!this.playerToServe.isEmpty()) {
            Predicate<ItemStack> foodPredicate = stack -> module.getMenu().contains(new ItemStorage((ItemStack)stack));
            if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), foodPredicate) && InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, foodPredicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(foodPredicate, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            return AIWorkerState.COOK_SERVE_FOOD_TO_PLAYER;
        }
        return AIWorkerState.START_WORKING;
    }

    private boolean shouldBeFed(AbstractEntityCitizen citizen) {
        return citizen.getCitizenData() != null && !citizen.getCitizenData().isWorking() && citizen.getCitizenData().getSaturation() <= 10.0 && !citizen.getCitizenData().justAte();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    @Override
    protected IRequestable getSmeltAbleClass() {
        return new Food(64, ((BuildingCook)this.building).getBuildingLevel());
    }
}

