/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.crafting;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingConcreteMixer;
import com.minecolonies.core.colony.jobs.JobConcreteMixer;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIConcreteMixer
extends AbstractEntityAICrafting<JobConcreteMixer, BuildingConcreteMixer> {
    private static final Predicate<ItemStack> CONCRETE = stack -> !stack.m_41619_() && stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_() instanceof ConcretePowderBlock;

    public EntityAIConcreteMixer(@NotNull JobConcreteMixer job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.CONCRETE_MIXER_PLACING, this::placePowder, 20), new AITarget<Object>(AIWorkerState.CONCRETE_MIXER_HARVESTING, this::harvestConcrete, 20));
    }

    @Override
    public Class<BuildingConcreteMixer> getExpectedBuildingClass() {
        return BuildingConcreteMixer.class;
    }

    private IAIState placePowder() {
        BlockPos posToPlace = ((BuildingConcreteMixer)this.building).getBlockToPlace();
        if (posToPlace == null) {
            return AIWorkerState.START_WORKING;
        }
        int slot = this.getSlotWithPowder();
        if (slot == -1) {
            if (InventoryUtils.getCountFromBuilding((IBuilding)this.building, CONCRETE) > 0) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(CONCRETE, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(posToPlace)) {
            return this.getState();
        }
        ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
        Block block = ((BlockItem)stack.m_41720_()).m_40614_();
        if (InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack, 1)) {
            this.world.m_7731_(posToPlace, block.m_49966_().m_60728_(Direction.DOWN, block.m_49966_(), (LevelAccessor)this.world, posToPlace, posToPlace), 3);
        }
        return this.getState();
    }

    private IAIState harvestConcrete() {
        BlockPos posToMine = ((BuildingConcreteMixer)this.building).getBlockToMine();
        if (posToMine == null) {
            this.resetActionsDone();
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkToWorkPos(posToMine)) {
            return this.getState();
        }
        BlockState blockToMine = this.world.m_8055_(posToMine);
        if (this.mineBlock(posToMine)) {
            StatsUtil.trackStatByName((IBuilding)this.building, "items_crafted_detail", blockToMine.m_60734_().m_7705_(), 1);
            if (this.currentRequest != null && this.currentRecipeStorage != null && blockToMine.m_60734_().m_5456_().equals(this.currentRecipeStorage.getPrimaryOutput().m_41720_())) {
                this.currentRequest.addDelivery(new ItemStack((ItemLike)blockToMine.m_60734_(), 1));
                ((JobConcreteMixer)this.job).setCraftCounter(((JobConcreteMixer)this.job).getCraftCounter() + 1);
                if (((JobConcreteMixer)this.job).getCraftCounter() >= ((JobConcreteMixer)this.job).getMaxCraftingCount()) {
                    this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
                    this.worker.decreaseSaturationForAction();
                    ((JobConcreteMixer)this.job).finishRequest(true);
                    this.worker.getCitizenExperienceHandler().addExperience((double)((PublicCrafting)this.currentRequest.getRequest()).getCount() / 2.0);
                    this.currentRequest = null;
                    this.currentRecipeStorage = null;
                    this.resetValues();
                    if (this.inventoryNeedsDump() && ((JobConcreteMixer)this.job).getMaxCraftingCount() == 0 && ((JobConcreteMixer)this.job).getProgress() == 0 && ((JobConcreteMixer)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
                        this.worker.getCitizenExperienceHandler().addExperience((double)((PublicCrafting)this.currentRequest.getRequest()).getCount() / 2.0);
                    }
                    return AIWorkerState.START_WORKING;
                }
            }
        }
        return this.getState();
    }

    private int getSlotWithPowder() {
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            ItemStack inputStack = this.currentRecipeStorage.getCleanedInput().get(0).getItemStack();
            if (CONCRETE.test(inputStack)) {
                return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, inputStack));
            }
            return -1;
        }
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), CONCRETE);
    }

    @Override
    protected IAIState decide() {
        if (this.walkTo == null && !this.walkToBuilding() || ((JobConcreteMixer)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobConcreteMixer)this.job).getActionsDone() > 0) {
            return this.getState();
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    @Override
    protected int getExtendedCount(ItemStack primaryOutput) {
        return ((BuildingConcreteMixer)this.building).outputBlockCountInWorld(primaryOutput);
    }

    @Override
    protected IAIState craft() {
        if (this.currentRecipeStorage == null || ((JobConcreteMixer)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRequest == null && ((JobConcreteMixer)this.job).getCurrentTask() != null) {
            return AIWorkerState.GET_RECIPE;
        }
        if (this.walkTo == null && !this.walkToBuilding()) {
            return this.getState();
        }
        this.currentRequest = ((JobConcreteMixer)this.job).getCurrentTask();
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRequest = null;
            this.currentRecipeStorage = null;
            return AIWorkerState.START_WORKING;
        }
        ItemStack concrete = this.currentRecipeStorage.getPrimaryOutput();
        if (concrete.m_41720_() instanceof BlockItem && ((BlockItem)concrete.m_41720_()).m_40614_() instanceof ConcretePowderBlock) {
            return super.craft();
        }
        return this.performMixingWork();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return this.getState().equals(AIWorkerState.CONCRETE_MIXER_HARVESTING) ? ((BuildingConcreteMixer)this.building).getMaxConcretePlaced() : super.getActionsDoneUntilDumping();
    }

    private IAIState performMixingWork() {
        BlockPos blockToMine = ((BuildingConcreteMixer)this.building).getBlockToMine();
        if (blockToMine != null) {
            return AIWorkerState.CONCRETE_MIXER_HARVESTING;
        }
        return AIWorkerState.CONCRETE_MIXER_PLACING;
    }
}

