/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ColonyConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecruitmentItemsListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String KEY_ITEM = "item";
    private static final String KEY_RARITY = "rarity";
    private static Map<RecruitmentTiers, List<RecruitCost>> RECRUIT_COSTS = new HashMap<RecruitmentTiers, List<RecruitCost>>();

    public RecruitmentItemsListener() {
        super(GSON, "colony/recruitment_items");
    }

    @Nullable
    public static RecruitCostResult getRandomRecruitCost(int buildingLevel) {
        int recruitTier = ColonyConstants.rand.nextInt(1, 10 * buildingLevel + 1);
        Map.Entry tierAndCosts = RECRUIT_COSTS.entrySet().stream().filter(f -> !((List)f.getValue()).isEmpty()).filter(f -> recruitTier <= ((RecruitmentTiers)((Object)((Object)f.getKey()))).maxLevel).min(Comparator.comparingInt(f -> ((RecruitmentTiers)((Object)((Object)f.getKey()))).maxLevel)).orElse(null);
        if (tierAndCosts == null) {
            return null;
        }
        int recruitLevel = recruitTier + 15;
        RecruitCost recruitCost = (RecruitCost)((List)tierAndCosts.getValue()).get(ColonyConstants.rand.nextInt(((List)tierAndCosts.getValue()).size()));
        return new RecruitCostResult(new ItemStack((ItemLike)recruitCost.item, (int)Math.round((double)recruitLevel * 3.0 / (double)recruitCost.rarity)), recruitLevel, ((RecruitmentTiers)((Object)tierAndCosts.getKey())).boots);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> jsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap recruitCosts = new HashMap();
        if (jsonElementMap.isEmpty()) {
            Log.getLogger().error("No recruitment items found, please ensure to add at least one recruitment item, otherwise visitors will be unable to spawn.");
            return;
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonElementMap.entrySet()) {
            if (!entry.getValue().isJsonObject()) {
                return;
            }
            JsonObject object = entry.getValue().getAsJsonObject();
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)KEY_ITEM)));
            int rarity = GsonHelper.m_13927_((JsonObject)object, (String)KEY_RARITY);
            if (item == Items.f_41852_) {
                throw new IllegalArgumentException("Recruit cost '" + String.valueOf(entry.getKey()) + "' item not allowed to be air");
            }
            for (RecruitmentTiers tier : RecruitmentTiers.values()) {
                if (rarity < tier.minRarity) continue;
                recruitCosts.putIfAbsent(tier, new ArrayList());
                ((List)recruitCosts.get((Object)tier)).add(new RecruitCost(item, rarity));
            }
        }
        for (Map.Entry<Object, Object> entry : recruitCosts.entrySet()) {
            if (!((List)entry.getValue()).isEmpty()) continue;
            Log.getLogger().error("No recruitment items found for tier {}. This tier requires items with a rarity of at least {}.", entry.getKey(), (Object)((RecruitmentTiers)((Object)entry.getKey())).minRarity);
        }
        RECRUIT_COSTS = Collections.unmodifiableMap(recruitCosts);
    }

    private record RecruitCost(Item item, int rarity) {
    }

    public record RecruitCostResult(ItemStack itemStack, int recruitLevel, Item boots) {
    }

    private static enum RecruitmentTiers {
        LEATHER(5, 0, Items.f_42463_),
        GOLD(10, 2, Items.f_42479_),
        IRON(20, 4, Items.f_42471_),
        DIAMOND(30, 6, Items.f_42475_);

        private final int maxLevel;
        private final int minRarity;
        private final Item boots;

        private RecruitmentTiers(int maxLevel, int minRarity, Item boots) {
            this.maxLevel = maxLevel;
            this.minRarity = minRarity;
            this.boots = boots;
        }
    }
}

