/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.util.BackUpHelper;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandDeleteColony
implements IMCColonyOfficerCommand {
    private static final String COMMAND_NAME = "delete";
    private static final String DELETE_BUILDINGS_ARG = "keep / delete buildings";
    private static final String CONFIRM_ARG = "confirm";

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).executes(this::executeGuidedBuildingAsk)).then(((RequiredArgumentBuilder)IMCCommand.newArgument(DELETE_BUILDINGS_ARG, DeleteBuildingsArgumentType.argument()).executes(this::executeGuidedConfirm)).then(IMCCommand.newArgument(CONFIRM_ARG, BoolArgumentType.bool()).executes(this::checkPreConditionAndExecute))));
    }

    private ClickEvent createClickEvent(CommandContext<CommandSourceStack> context, boolean confirm) {
        return new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + context.getInput() + " " + confirm);
    }

    private Component braceButtonComponent(Component button) {
        return Component.m_237113_((String)"[").m_7220_(button).m_130946_("]");
    }

    private int executeGuidedBuildingAsk(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        Style keepButtonStyle = Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.DARK_GREEN).m_131142_(this.createClickEvent(context, false));
        Style deleteButtonStyle = Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.DARK_RED).m_131142_(this.createClickEvent(context, true));
        Component keepButton = this.braceButtonComponent((Component)Component.m_237115_((String)"com.minecolonies.command.delete.confirm.building.keep").m_6270_(keepButtonStyle));
        Component deleteButton = this.braceButtonComponent((Component)Component.m_237115_((String)"com.minecolonies.command.delete.confirm.building.delete").m_6270_(deleteButtonStyle));
        TranslatableContents contents = new TranslatableContents("com.minecolonies.command.delete.confirm.building", null, (Object[])new Component[]{keepButton, deleteButton});
        ((CommandSourceStack)context.getSource()).m_288197_(() -> MutableComponent.m_237204_((ComponentContents)contents).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)), true);
        return 1;
    }

    private int executeGuidedConfirm(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        Style buttonStyle = Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.DARK_RED).m_131142_(this.createClickEvent(context, true));
        Component confirmButton = this.braceButtonComponent((Component)Component.m_237115_((String)"com.minecolonies.command.delete.confirm.final.here").m_6270_(buttonStyle));
        MutableComponent deleteBuildingsComponent = Component.m_237119_();
        if (BoolArgumentType.getBool(context, (String)DELETE_BUILDINGS_ARG)) {
            deleteBuildingsComponent = Component.m_237115_((String)"com.minecolonies.command.delete.confirm.final.building").m_130946_(" ").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        }
        TranslatableContents contents = new TranslatableContents("com.minecolonies.command.delete.confirm.final", null, (Object[])new Component[]{deleteBuildingsComponent, confirmButton});
        ((CommandSourceStack)context.getSource()).m_288197_(() -> MutableComponent.m_237204_((ComponentContents)contents).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)), true);
        return 1;
    }

    @Override
    public boolean checkPreCondition(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).m_6761_(4) && !((Boolean)MineColonies.getConfig().getServer().canPlayerUseDeleteColonyCommand.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.notenabledinconfig"), true);
            return false;
        }
        return IMCColonyOfficerCommand.super.checkPreCondition(context);
    }

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        boolean deleteBuildings = BoolArgumentType.getBool(context, (String)DELETE_BUILDINGS_ARG);
        boolean confirmation = BoolArgumentType.getBool(context, (String)CONFIRM_ARG);
        if (!confirmation) {
            return 1;
        }
        BackUpHelper.backupColonyData();
        IColonyManager.getInstance().deleteColonyByDimension(colonyID, deleteBuildings, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.delete.success", (Object[])new Object[]{colony.getName()}), true);
        return 1;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public static class DeleteBuildingsArgumentType
    implements ArgumentType<Boolean> {
        public static DeleteBuildingsArgumentType argument() {
            return new DeleteBuildingsArgumentType();
        }

        public Boolean parse(StringReader reader) throws CommandSyntaxException {
            return BoolArgumentType.bool().parse(reader);
        }

        public CompletableFuture<Suggestions> listSuggestions(CommandContext context, SuggestionsBuilder builder) {
            if ("true".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("true", (Message)Component.m_237115_((String)"com.minecolonies.command.delete.confirm.suggest.delete"));
            }
            if ("false".startsWith(builder.getRemainingLowerCase())) {
                builder.suggest("false", (Message)Component.m_237115_((String)"com.minecolonies.command.delete.confirm.suggest.keep"));
            }
            return builder.buildFuture();
        }

        static {
            ArgumentTypeInfos.registerByClass(DeleteBuildingsArgumentType.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(DeleteBuildingsArgumentType::argument));
        }
    }
}

