/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.Network;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.network.messages.client.SyncPathMessage;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandCitizenTrack
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!(sender instanceof Player)) {
            return 1;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)(sender == null ? Level.f_46428_ : ((CommandSourceStack)context.getSource()).m_81372_().m_46472_()));
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.notfound"), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.notloaded"), true);
            return 0;
        }
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        if (PathfindingUtils.trackingMap.getOrDefault(sender.m_20148_(), UUID.randomUUID()).equals(entityCitizen.m_20148_())) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizentrack.success.disable"), true);
            PathfindingUtils.trackingMap.remove(sender.m_20148_());
            Network.getNetwork().sendToPlayer(new SyncPathMessage(new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>()), (ServerPlayer)sender);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizentrack.success.enable"), true);
            PathfindingUtils.trackingMap.put(sender.m_20148_(), entityCitizen.m_20148_());
        }
        return 1;
    }

    @Override
    public String getName() {
        return "trackPath";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)));
    }
}

