/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.blocks.BlockMinecoloniesGrave;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.tileentities.TileEntityGrave;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class GraveManager
implements IGraveManager {
    @NotNull
    private final Map<BlockPos, Boolean> graves = new HashMap<BlockPos, Boolean>();
    private final Colony colony;

    public GraveManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.graves.clear();
        ListTag gravesTagList = compound.m_128437_("graves", 10);
        for (int i = 0; i < gravesTagList.size(); ++i) {
            CompoundTag graveCompound = gravesTagList.m_128728_(i);
            if (!graveCompound.m_128441_("pos") || !graveCompound.m_128441_("reserved")) continue;
            this.graves.put(BlockPosUtil.read(graveCompound, "pos"), graveCompound.m_128471_("reserved"));
        }
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag gravesTagList = new ListTag();
        for (BlockPos blockPos : this.graves.keySet()) {
            @NotNull CompoundTag graveCompound = new CompoundTag();
            BlockPosUtil.write(graveCompound, "pos", blockPos);
            graveCompound.m_128379_("reserved", this.graves.get(blockPos).booleanValue());
            gravesTagList.add((Object)graveCompound);
        }
        compound.m_128365_("graves", (Tag)gravesTagList);
    }

    @Override
    public void onColonyTick(IColony colony) {
        Iterator<BlockPos> iterator = this.graves.keySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), pos)) continue;
            BlockEntity graveEntity = colony.getWorld().m_7702_(pos);
            if (!(graveEntity instanceof TileEntityGrave)) {
                iterator.remove();
                colony.markDirty();
                continue;
            }
            if (((TileEntityGrave)graveEntity).onColonyTick(500.0)) continue;
            iterator.remove();
            colony.markDirty();
        }
    }

    @Override
    @NotNull
    public Map<BlockPos, Boolean> getGraves() {
        return this.graves;
    }

    @Override
    public boolean addNewGrave(@NotNull BlockPos pos) {
        TileEntityGrave graveEntity = (TileEntityGrave)this.colony.getWorld().m_7702_(pos);
        if (graveEntity == null) {
            return false;
        }
        if (this.graves.containsKey(pos)) {
            return true;
        }
        this.graves.put(pos, false);
        this.colony.markDirty();
        return true;
    }

    @Override
    public void removeGrave(@NotNull BlockPos pos) {
        this.graves.remove(pos);
        this.colony.markDirty();
    }

    @Override
    public boolean reserveGrave(@NotNull BlockPos pos) {
        if (!this.graves.containsKey(pos) || this.graves.get(pos).booleanValue()) {
            return false;
        }
        this.graves.put(pos, true);
        this.colony.markDirty();
        return true;
    }

    @Override
    public void unReserveGrave(@NotNull BlockPos pos) {
        if (this.graves.containsKey(pos) && this.graves.get(pos).booleanValue()) {
            this.graves.put(pos, false);
            this.colony.markDirty();
        }
    }

    @Override
    public BlockPos reserveNextFreeGrave() {
        for (BlockPos pos : new ArrayList<BlockPos>(this.graves.keySet())) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.colony.getWorld(), pos)) continue;
            BlockEntity graveEntity = this.colony.getWorld().m_7702_(pos);
            if (!(graveEntity instanceof TileEntityGrave)) {
                this.graves.remove(pos);
                continue;
            }
            if (!this.reserveGrave(pos)) continue;
            return pos;
        }
        return null;
    }

    @Override
    public boolean createCitizenGrave(Level world, BlockPos pos, ICitizenData citizenData) {
        BlockState here = world.m_8055_(pos);
        if (here.m_60734_() == Blocks.f_49991_) {
            MessageUtils.format("com.minecolonies.coremod.grave.lava", new Object[0]).sendTo(this.colony).forManagers();
            return false;
        }
        BlockPos firstValidPosition = null;
        if (here.m_60734_() == Blocks.f_49990_) {
            for (int i = 1; i <= 10; ++i) {
                if (!(world.m_8055_(pos.m_6630_(i)).m_60734_() instanceof AirBlock)) continue;
                firstValidPosition = BlockPosUtil.findAround(world, pos, 1, 16, (blockAccess, current) -> blockAccess.m_8055_(current).m_60795_() && BlockUtils.isAnySolid((BlockState)blockAccess.m_8055_(current.m_7495_())));
                break;
            }
            if (firstValidPosition == null) {
                MessageUtils.format("com.minecolonies.coremod.grave.water", new Object[0]).sendTo(this.colony).forManagers();
            }
        } else {
            firstValidPosition = BlockPosUtil.findAround(world, pos, 10, 10, (blockAccess, current) -> blockAccess.m_8055_(current).m_60795_() && BlockUtils.isAnySolid((BlockState)blockAccess.m_8055_(current.m_7495_())));
        }
        if (firstValidPosition != null) {
            world.m_46597_(firstValidPosition, BlockMinecoloniesGrave.getPlacementState(ModBlocks.blockGrave.m_49966_(), firstValidPosition));
            TileEntityGrave graveEntity = (TileEntityGrave)world.m_7702_(firstValidPosition);
            if (!InventoryUtils.transferAllItemHandler((IItemHandler)citizenData.getInventory(), (IItemHandler)graveEntity.getInventory())) {
                InventoryUtils.dropItemHandler((IItemHandler)citizenData.getInventory(), world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            }
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack stack = citizenData.getInventory().getArmorInSlot(equipmentSlot);
                if (InventoryUtils.addItemStackToItemHandler((IItemHandler)graveEntity.getInventory(), stack)) continue;
                InventoryUtils.spawnItemStack(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stack);
            }
            graveEntity.delayDecayTimer(this.colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.GRAVE_DECAY_BONUS));
            GraveData graveData = new GraveData();
            graveData.setCitizenName(citizenData.getName());
            if (citizenData.getJob() != null) {
                MutableComponent jobName = Component.m_237115_((String)citizenData.getJob().getJobRegistryEntry().getTranslationKey().toLowerCase());
                graveData.setCitizenJobName(jobName.getString());
            }
            graveData.setCitizenDataNBT((CompoundTag)citizenData.serializeNBT());
            graveEntity.setGraveData(graveData);
            this.colony.getGraveManager().addNewGrave(firstValidPosition);
            return true;
        }
        InventoryUtils.dropItemHandler((IItemHandler)citizenData.getInventory(), world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        return false;
    }
}

