/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.interactionhandling;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.quests.IDialogueObjectiveTemplate;
import com.minecolonies.api.quests.IFinalQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestDialogueAnswer;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIBasic;
import com.minecolonies.core.network.messages.server.colony.InteractionResponse;
import com.minecolonies.core.quests.objectives.DialogueObjectiveTemplateTemplate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class QuestDialogueInteraction
extends StandardInteraction {
    private static final ResourceLocation QUEST_START_ICON = new ResourceLocation("minecolonies", "textures/icons/queststart.png");
    private static final ResourceLocation QUEST_NEXT_TASK_ICON = new ResourceLocation("minecolonies", "textures/icons/nexttask.png");
    private static final ResourceLocation QUEST_WAITING_TASK_ICON = new ResourceLocation("minecolonies", "textures/icons/opentask.png");
    protected IQuestInstance colonyQuest;
    protected final ICitizen citizen;
    protected ResourceLocation questId;
    protected int index;
    protected IDialogueObjectiveTemplate.DialogueElement startElement = null;
    protected IDialogueObjectiveTemplate.DialogueElement currentElement = null;
    protected boolean finished = false;

    public QuestDialogueInteraction(Component inquiry, IChatPriority priority, ResourceLocation location, int index, ICitizenData citizenData) {
        super(inquiry, null, priority);
        this.questId = location;
        this.index = index;
        this.startElement = this.currentElement = ((DialogueObjectiveTemplateTemplate)IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questId).getObjective(index)).getDialogueTree();
        this.colonyQuest = citizenData.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId);
        this.citizen = citizenData;
    }

    public QuestDialogueInteraction(ICitizen data) {
        super(data);
        this.colonyQuest = data.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId);
        this.citizen = data;
    }

    @Override
    public void onServerResponseTriggered(int responseId, Player player, ICitizenData data) {
        if (this.colonyQuest == null) {
            this.colonyQuest = data.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId);
        }
        if (this.currentElement != null && this.colonyQuest != null) {
            IQuestDialogueAnswer result = this.currentElement.getOptionResult(responseId);
            if (result instanceof IFinalQuestDialogueAnswer) {
                ((IFinalQuestDialogueAnswer)result).applyToQuest(player, data.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId));
                if (!(result instanceof IQuestDialogueAnswer.CloseUIDialogueAnswer)) {
                    this.finished = true;
                    this.currentElement = null;
                    data.getColony().markDirty();
                    return;
                }
                this.currentElement = this.startElement;
            } else if (result instanceof IDialogueObjectiveTemplate.DialogueElement) {
                this.currentElement = (IDialogueObjectiveTemplate.DialogueElement)result;
                if (data != null && data.getJob() != null) {
                    ((AbstractEntityAIBasic)data.getJob().getWorkerAI()).setDelay(60);
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(int responseId, Player player, ICitizenDataView data, BOWindow window) {
        if (this.colonyQuest == null) {
            this.colonyQuest = data.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId);
        }
        if (this.currentElement != null && this.colonyQuest != null) {
            IQuestDialogueAnswer result = this.currentElement.getOptionResult(responseId);
            if (result instanceof IFinalQuestDialogueAnswer) {
                Network.getNetwork().sendToServer(new InteractionResponse(data.getColonyId(), data.getId(), (ResourceKey<Level>)player.f_19853_.m_46472_(), (Component)Component.m_237113_((String)this.questId.toString()), responseId));
                this.currentElement = this.startElement;
                this.finished = true;
                return true;
            }
            if (result instanceof IDialogueObjectiveTemplate.DialogueElement) {
                Network.getNetwork().sendToServer(new InteractionResponse(data.getColonyId(), data.getId(), (ResourceKey<Level>)player.f_19853_.m_46472_(), (Component)Component.m_237113_((String)this.questId.toString()), responseId));
                this.currentElement = (IDialogueObjectiveTemplate.DialogueElement)result;
                return false;
            }
        }
        return true;
    }

    @Override
    public void onOpened(Player player) {
        super.onOpened(player);
        if (this.colonyQuest == null && this.citizen != null) {
            this.colonyQuest = this.citizen.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId);
        }
    }

    @Override
    public Component getId() {
        return Component.m_237113_((String)this.questId.toString());
    }

    @Override
    public void onClosed() {
        this.currentElement = this.startElement;
    }

    @Override
    public Component getInquiry() {
        return this.processText(this.currentElement.getText());
    }

    private Component processText(Component text) {
        String localText = text.getString();
        if (localText.contains("$") && this.colonyQuest != null) {
            localText = localText.replace("$0", this.citizen.getColony().getCitizen(this.colonyQuest.getQuestGiverId()).getName());
            int index = 1;
            for (int participant : this.colonyQuest.getParticipants()) {
                localText = localText.replace("$" + index, this.citizen.getColony().getCitizen(participant).getName());
            }
        }
        if (localText.contains("$d") && this.colonyQuest != null && this.colonyQuest.getCurrentObjectiveInstance() != null) {
            localText = localText.replace("$d", String.valueOf(this.colonyQuest.getCurrentObjectiveInstance().getMissingQuantity()));
        }
        return Component.m_237113_((String)localText);
    }

    @Override
    public boolean isVisible(Level world) {
        return !this.finished;
    }

    @Override
    public List<Component> getPossibleResponses() {
        return this.currentElement == null ? Collections.emptyList() : this.currentElement.getOptions().stream().map(this::processText).collect(Collectors.toList());
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128359_("questid", this.questId.toString());
        tag.m_128405_("questindex", this.index);
        tag.m_128379_("finishedquests", this.finished);
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag compoundNBT) {
        super.deserializeNBT(compoundNBT);
        this.questId = new ResourceLocation(compoundNBT.m_128461_("questid"));
        this.index = compoundNBT.m_128451_("questindex");
        this.startElement = this.currentElement = ((DialogueObjectiveTemplateTemplate)IQuestManager.GLOBAL_SERVER_QUESTS.get(this.questId).getObjective(this.index)).getDialogueTree();
        this.finished = compoundNBT.m_128471_("finishedquests");
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.QUEST.m_135815_();
    }

    @Override
    public ResourceLocation getInteractionIcon() {
        if (this.colonyQuest == null) {
            this.colonyQuest = this.citizen.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId);
        }
        if (this.colonyQuest != null && this.colonyQuest.getCurrentObjectiveInstance() != null && !this.colonyQuest.getCurrentObjectiveInstance().isFulfilled()) {
            return QUEST_WAITING_TASK_ICON;
        }
        return this.index == 0 ? QUEST_START_ICON : QUEST_NEXT_TASK_ICON;
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.currentElement != null && citizen.isParticipantOfQuest(this.questId) && citizen.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId) != null && citizen.getColony().getQuestManager().getAvailableOrInProgressQuest(this.questId).getObjectiveIndex() == this.index;
    }
}

