/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.modules.MinimumStockModule;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingCook
extends AbstractBuilding {
    private static final String COOK_DESC = "cook";
    public static final String FOOD_EXCLUSION_LIST = "food";
    private static final int MAX_BUILDING_LEVEL = 5;
    private boolean initTags = false;
    private List<BlockPos> sitPositions;
    private int lastSitting = 0;

    public BuildingCook(IColony c, BlockPos l) {
        super(c, l);
    }

    public void initTagPositions() {
        if (this.initTags) {
            return;
        }
        this.sitPositions = this.getLocationsFromTag("sit");
        this.initTags = !this.sitPositions.isEmpty();
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        this.initTags = false;
    }

    @Override
    protected boolean keepFood() {
        return false;
    }

    public BlockPos getNextSittingPosition() {
        this.initTagPositions();
        if (this.sitPositions.isEmpty()) {
            return null;
        }
        ++this.lastSitting;
        if (this.lastSitting >= this.sitPositions.size()) {
            this.lastSitting = 0;
        }
        return this.sitPositions.get(this.lastSitting);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory, JobEntry jobEntry) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (inventory && ((MinimumStockModule)this.getFirstModuleOccurance(MinimumStockModule.class)).isStocked(stack)) {
            return stack.m_41613_();
        }
        Predicate<ItemStack> allowedFuel = theStack -> ((ItemListModule)this.getModuleMatching(ItemListModule.class, (T m) -> m.getId().equals("fuel"))).isItemInList(new ItemStorage((ItemStack)theStack));
        if (allowedFuel.test(stack) && (localAlreadyKept.stream().filter(storage -> allowedFuel.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory)) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory, jobEntry);
    }
}

