/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.modules.settings.IntSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BuildingComposter
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> PRODUCE_DIRT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "producedirt"));
    public static final ISettingKey<IntSetting> MIN = new SettingKey<IntSetting>(IntSetting.class, new ResourceLocation("minecolonies", "warehousemin"));
    private static final String COMPOSTER = "composter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_POS = "pos";
    private static final String TAG_BARRELS = "barrels";
    private final List<BlockPos> barrels = new ArrayList<BlockPos>();

    public BuildingComposter(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> ((ItemListModule)this.getModuleMatching(ItemListModule.class, (T m) -> m.getId().equals("compostables"))).isItemInList(new ItemStorage((ItemStack)stack)), new Tuple((Object)Integer.MAX_VALUE, (Object)true));
    }

    public List<BlockPos> getBarrels() {
        return ImmutableList.copyOf(this.barrels);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COMPOSTER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block == ModBlocks.blockBarrel && !this.barrels.contains(pos)) {
            this.barrels.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag compostBinTagList = compound.m_128437_(TAG_BARRELS, 10);
        for (int i = 0; i < compostBinTagList.size(); ++i) {
            this.barrels.add(NbtUtils.m_129239_((CompoundTag)compostBinTagList.m_128728_(i).m_128469_(TAG_POS)));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag compostBinTagList = new ListTag();
        for (BlockPos entry : this.barrels) {
            @NotNull CompoundTag compostBinCompound = new CompoundTag();
            compostBinCompound.m_128365_(TAG_POS, (Tag)NbtUtils.m_129224_((BlockPos)entry));
            compostBinTagList.add((Object)compostBinCompound);
        }
        compound.m_128365_(TAG_BARRELS, (Tag)compostBinTagList);
        return compound;
    }
}

