/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.huts;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.client.gui.AbstractWindowModuleBuilding;
import com.minecolonies.core.client.gui.WindowsBarracksSpies;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBarracks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class WindowBarracksBuilding
extends AbstractWindowModuleBuilding<BuildingBarracks.View> {
    private static final String LIST_POSITIONS = "positions";
    private static final String LABEL_POS = "pos";
    private static final String LABEL_CURRENNT = "current";
    private static final String HOME_BUILDING_RESOURCE_SUFFIX = ":gui/windowhutbarracks.xml";
    private static final String SPIES_BUTTON = "hireSpies";
    private static final String SPIES_BUTTON_ICON = "hireSpiesIcon";
    private static final int BUILDING_LEVEL_FOR_LIST = 3;
    private static final long QUITE_CLOSE = 50L;
    private static final long QUITE_FAR = 100L;
    private final ScrollingList positionsList;
    private final IColonyView view;

    public WindowBarracksBuilding(BuildingBarracks.View building) {
        super(building, "minecolonies:gui/windowhutbarracks.xml");
        this.view = building.getColony();
        this.positionsList = (ScrollingList)this.findPaneOfTypeByID(LIST_POSITIONS, ScrollingList.class);
        ((ItemIcon)this.findPaneOfTypeByID(SPIES_BUTTON_ICON, ItemIcon.class)).setItem(Items.f_42417_.m_7968_());
        this.registerButton(SPIES_BUTTON, this::hireSpiesClicked);
        if (building.getBuildingLevel() < 3) {
            ((ButtonImage)this.findPaneOfTypeByID(SPIES_BUTTON, ButtonImage.class)).setVisible(false);
            ((ItemIcon)this.findPaneOfTypeByID(SPIES_BUTTON_ICON, ItemIcon.class)).setVisible(false);
        }
    }

    private void hireSpiesClicked(Button button) {
        new WindowsBarracksSpies(this.building, ((BuildingBarracks.View)this.building).getID()).open();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (((BuildingBarracks.View)this.building).getBuildingLevel() >= 3) {
            final List<BlockPos> spawnPoints = this.view.getLastSpawnPoints();
            if (spawnPoints.size() == 0) {
                return;
            }
            if (this.view.isRaiding()) {
                ((Text)this.findPaneOfTypeByID(LABEL_CURRENNT, Text.class)).setText(this.mountDistanceString(spawnPoints.get(spawnPoints.size() - 1)));
            }
            this.positionsList.setDataProvider(new ScrollingList.DataProvider(){

                public int getElementCount() {
                    return spawnPoints.size() - (WindowBarracksBuilding.this.view.isRaiding() ? 1 : 0);
                }

                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = (BlockPos)spawnPoints.get(index);
                    if (!WindowBarracksBuilding.this.view.isRaiding() || index != spawnPoints.size() - 1) {
                        ((Text)rowPane.findPaneOfTypeByID(WindowBarracksBuilding.LABEL_POS, Text.class)).setText(Component.m_237113_((String)(index + 1 + ": " + String.valueOf(WindowBarracksBuilding.this.mountDistanceString(pos)))));
                    }
                }
            });
        }
    }

    private Component mountDistanceString(BlockPos pos) {
        long distance = BlockPosUtil.getDistance2D(pos, ((BuildingBarracks.View)this.building).getPosition());
        String distanceDesc = distance < 50L ? "com.minecolonies.coremod.max.schematic.quiteclose" : (distance < 100L ? "com.minecolonies.coremod.max.schematic.quitefar" : "com.minecolonies.coremod.max.schematic.reallyfar");
        Component directionDest = BlockPosUtil.calcDirection(((BuildingBarracks.View)this.building).getPosition(), pos).getLongText();
        return Component.m_237115_((String)distanceDesc).m_130946_(" ").m_7220_(directionDest);
    }
}

