/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorPalette {
    public static final DyeColor[] DYES = DyeColor.values();
    public static int BUTTON_SIZE = 20;
    protected List<PaletteButton> buttons = new ArrayList<PaletteButton>();
    protected DyeColor selected = DyeColor.WHITE;
    public ChangeEvent onchange;

    public ColorPalette(int x, int y, int col, IWidgetAdder adder) {
        int topLeftX = x - col * BUTTON_SIZE / 2;
        int topLeftY = y - DYES.length / col * BUTTON_SIZE / 2;
        for (DyeColor color : DYES) {
            int posX = topLeftX + color.m_41060_() % col * BUTTON_SIZE;
            int posY = topLeftY + BUTTON_SIZE * Math.floorDiv(color.m_41060_(), col);
            PaletteButton button = new PaletteButton(posX, posY, BUTTON_SIZE, color);
            this.buttons.add(button);
            adder.onBuild(button);
        }
    }

    public ColorPalette(Screen gui, IWidgetAdder adder) {
        this(gui.f_96543_ / 2, gui.f_96544_ / 2, (int)Math.floor(Math.sqrt(DYES.length)), adder);
    }

    public DyeColor getSelected() {
        return this.selected;
    }

    public void setSelected(DyeColor selected) {
        this.selected = selected;
    }

    public class PaletteButton
    extends Button {
        private final DyeColor color;

        public PaletteButton(int posX, int posY, int sideLength, DyeColor color) {
            super(posX, posY, sideLength, sideLength, (Component)Component.m_237113_((String)""), pressed -> {}, f_252438_);
            this.color = color;
        }

        public void m_88315_(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
            this.f_93623_ = ColorPalette.this.selected != this.color;
            super.m_88315_(stack, mouseX, mouseY, partialTicks);
        }

        public void m_87963_(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
            boolean pressed;
            int color = this.color.m_41071_();
            boolean bl = pressed = ColorPalette.this.selected == this.color;
            this.fillButton(stack, 0, 0, 0, 0, this.f_93622_ ? 0xFFFFFF : (pressed ? this.brighten(color, 0.5f) : 0));
            this.fillButton(stack, 1, 1, 1, 1, this.brighten(color, 0.8f));
            if (pressed) {
                this.fillButton(stack, 2, 2, 1, 1, this.brighten(color, 1.2f));
                this.fillButton(stack, 2, 2, 2, 2, color);
                this.fillButton(stack, 7, 7, 7, 7, 0x33000001);
            } else {
                this.fillButton(stack, 1, 1, 3, 2, this.brighten(color, 1.2f));
                this.fillButton(stack, 2, 2, 3, 2, color);
            }
        }

        public void m_5691_() {
            ColorPalette.this.selected = this.color;
            ColorPalette.this.onchange.onChange(ColorPalette.this.selected);
        }

        private void fillButton(GuiGraphics stack, int t, int l, int b, int r, int color) {
            stack.m_280509_(this.m_252754_() + l, this.m_252907_() + t, this.m_252754_() + this.f_93618_ - r, this.m_252907_() + this.f_93619_ - b, color -= 0x1000000);
        }

        private int brighten(int color, float factor) {
            int r = color >> 16;
            int g = color - (r << 16) >> 8;
            int b = color - (r << 16) - (g << 8);
            r = (int)Math.min(255.0f, (float)r * factor) << 16;
            g = (int)Math.min(255.0f, (float)g * factor) << 8;
            b = (int)Math.min(255.0f, (float)b * factor);
            return r + g + b;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IWidgetAdder {
        public void onBuild(Button var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface ChangeEvent {
        public void onChange(DyeColor var1);
    }
}

