/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.WindowBuildBuilding;
import com.minecolonies.core.client.gui.WindowHutAllInventory;
import com.minecolonies.core.client.gui.WindowHutNameEntry;
import com.minecolonies.core.client.gui.WindowInfo;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.network.messages.server.colony.building.BuildRequestMessage;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractWindowModuleBuilding<B extends IBuildingView>
extends AbstractModuleWindow {
    protected final B building;
    private final Text title;
    private final Button buttonBuild;

    public AbstractWindowModuleBuilding(B building, String resource) {
        super((IBuildingView)building, resource);
        this.building = building;
        this.registerButton("build", this::buildClicked);
        this.registerButton("info", this::infoClicked);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("editName", this::editName);
        this.registerButton("allinventory", this::allInventoryClicked);
        this.title = (Text)this.findPaneOfTypeByID("name", Text.class);
        this.buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        Button buttonInfo = (Button)this.findPaneOfTypeByID("info", Button.class);
        if (buttonInfo != null) {
            buttonInfo.setVisible(I18n.m_118936_((String)("com.minecolonies.coremod.info." + building.getBuildingType().getTranslationKey().replace("com.minecolonies.building.", "") + ".0")));
        }
    }

    @Override
    public void setPage(boolean relative, int page) {
        super.setPage(relative, page);
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
    }

    private void editName() {
        new WindowHutNameEntry((IBuildingView)this.building).open();
    }

    private void infoClicked() {
        new WindowInfo((IBuildingView)this.building).open();
    }

    private void allInventoryClicked() {
        new WindowHutAllInventory((IBuildingView)this.building, (BOWindow)this).open();
    }

    private void buildClicked() {
        String buttonLabel;
        String string = buttonLabel = this.buttonBuild.getText().m_214077_() instanceof TranslatableContents ? ((TranslatableContents)this.buttonBuild.getText().m_214077_()).m_237508_() : this.buttonBuild.getTextAsString();
        if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelbuild") || buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelupgrade")) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.BUILD, BlockPos.f_121853_));
        } else if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.cancelrepair")) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.REPAIR, BlockPos.f_121853_));
        } else if (buttonLabel.equalsIgnoreCase("com.minecolonies.coremod.gui.workerhuts.canceldeconstruction")) {
            Network.getNetwork().sendToServer(new BuildRequestMessage((IBuildingView)this.building, BuildRequestMessage.Mode.REMOVE, BlockPos.f_121853_));
        } else {
            new WindowBuildBuilding(this.building.getColony(), (IBuildingView)this.building).open();
        }
    }

    private void inventoryClicked() {
        Network.getNetwork().sendToServer(new OpenInventoryMessage((IBuildingView)this.building));
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateButtonBuild((IBuildingView)this.building);
    }

    public String getBuildingName() {
        return this.buildingView.getBuildingDisplayName();
    }

    private void updateButtonBuild(IBuildingView buildingView) {
        if (this.buttonBuild == null) {
            return;
        }
        if (buildingView.isBuilding()) {
            if (buildingView.getBuildingLevel() == 0) {
                this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelbuild"));
            } else {
                this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelupgrade"));
            }
        } else if (buildingView.isRepairing()) {
            this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelrepair"));
        } else if (buildingView.isDeconstructing()) {
            this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.canceldeconstruction"));
        } else {
            this.buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.buildrepair"));
        }
    }

    public void onOpened() {
        super.onOpened();
        this.setPage(false, 0);
        if (this.title != null) {
            MutableComponent component = Component.m_237115_((String)this.building.getBuildingDisplayName());
            MutableComponent componentWithLevel = component.m_130946_(" ").m_130946_(String.valueOf(this.buildingView.getBuildingLevel()));
            this.title.setText(componentWithLevel);
        }
    }
}

