/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.requirements;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.core.util.GsonHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BuildingResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private static final String RESEARCH_REQUIREMENT_BUILDING_PROP = "building";
    private static final String RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP = "level";
    private final int buildingLevel;
    private final String building;

    public BuildingResearchRequirement(CompoundTag nbt) {
        this.building = nbt.m_128461_(TAG_BUILDING_NAME);
        this.buildingLevel = nbt.m_128451_(TAG_BUILDING_LVL);
    }

    public BuildingResearchRequirement(JsonObject json) {
        this.building = GsonHelper.m_13906_((JsonObject)json, (String)RESEARCH_REQUIREMENT_BUILDING_PROP);
        this.buildingLevel = GsonHelper.m_13927_((JsonObject)json, (String)RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP);
    }

    public String getBuilding() {
        return this.building;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public ModResearchRequirements.ResearchRequirementEntry getRegistryEntry() {
        return (ModResearchRequirements.ResearchRequirementEntry)ModResearchRequirements.buildingResearchRequirement.get();
    }

    @Override
    public MutableComponent getDesc() {
        return Component.m_237110_((String)"com.minecolonies.coremod.research.requirement.building.level", (Object[])new Object[]{Component.m_237115_((String)("com.minecolonies.building." + this.building)), this.buildingLevel});
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.hasBuilding(this.building, this.buildingLevel, false);
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_BUILDING_NAME, this.building);
        nbt.m_128405_(TAG_BUILDING_LVL, this.buildingLevel);
        return nbt;
    }
}

