/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.requirements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.core.util.GsonHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BuildingAlternatesResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDINGS_LIST = "building-list";
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private static final String RESEARCH_REQUIREMENT_ALTERNATE_BUILDINGS_PROP = "alternate-buildings";
    private static final String RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP = "level";
    private final Map<String, Integer> buildings = new HashMap<String, Integer>();

    public BuildingAlternatesResearchRequirement(CompoundTag nbt) {
        ListTag buildingsNBT = nbt.m_128437_(TAG_BUILDINGS_LIST, 10);
        for (int i = 0; i < buildingsNBT.size(); ++i) {
            CompoundTag indNBT = buildingsNBT.m_128728_(i);
            this.buildings.put(indNBT.m_128461_(TAG_BUILDING_NAME), indNBT.m_128451_(TAG_BUILDING_LVL));
        }
    }

    public BuildingAlternatesResearchRequirement(JsonObject json) {
        for (JsonElement element : GsonHelper.m_13933_((JsonObject)json, (String)RESEARCH_REQUIREMENT_ALTERNATE_BUILDINGS_PROP)) {
            String arrBuilding = element.getAsString();
            int arrLevel = GsonHelper.m_13927_((JsonObject)json, (String)RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP);
            this.buildings.merge(arrBuilding, arrLevel, Integer::sum);
        }
    }

    public Map<String, Integer> getBuildings() {
        return this.buildings;
    }

    @Override
    public ModResearchRequirements.ResearchRequirementEntry getRegistryEntry() {
        return (ModResearchRequirements.ResearchRequirementEntry)ModResearchRequirements.buildingAlternatesResearchRequirement.get();
    }

    @Override
    public MutableComponent getDesc() {
        MutableComponent requirementList = Component.m_237115_((String)"");
        Iterator<Map.Entry<String, Integer>> iterator = this.buildings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> kvp = iterator.next();
            requirementList.m_7220_((Component)Component.m_237110_((String)"com.minecolonies.coremod.research.requirement.building.level", (Object[])new Object[]{Component.m_237115_((String)("block.minecolonies.blockhut" + kvp.getKey())), kvp.getValue()}));
            if (!iterator.hasNext()) continue;
            requirementList.m_7220_((Component)Component.m_237115_((String)"com.minecolonies.coremod.research.requirement.building.or"));
        }
        return requirementList;
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        for (Map.Entry<String, Integer> requirement : this.buildings.entrySet()) {
            if (!colony.hasBuilding(requirement.getKey(), requirement.getValue(), false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag buildingsNBT = new ListTag();
        for (Map.Entry<String, Integer> build : this.buildings.entrySet()) {
            CompoundTag indNBT = new CompoundTag();
            indNBT.m_128359_(TAG_BUILDING_NAME, build.getKey());
            indNBT.m_128405_(TAG_BUILDING_LVL, build.getValue().intValue());
            buildingsNBT.add((Object)indNBT);
        }
        nbt.m_128365_(TAG_BUILDINGS_LIST, (Tag)buildingsNBT);
        return nbt;
    }
}

