/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerCraftingFurnace
extends AbstractContainerMenu {
    private final IItemHandler furnaceInventory;
    private final Inventory playerInventory;
    public final BlockPos buildingPos;
    private int moduleId;

    public static ContainerCraftingFurnace fromFriendlyByteBuf(int windowId, Inventory inv, FriendlyByteBuf packetBuffer) {
        BlockPos tePos = packetBuffer.m_130135_();
        int moduleId = packetBuffer.readInt();
        return new ContainerCraftingFurnace(windowId, inv, tePos, moduleId);
    }

    public ContainerCraftingFurnace(int windowId, Inventory inv, BlockPos pos, int moduleId) {
        super((MenuType)ModContainers.craftingFurnace.get(), windowId);
        int i;
        this.moduleId = moduleId;
        this.furnaceInventory = new IItemHandlerModifiable(){
            ItemStack input = ItemStack.f_41583_;
            ItemStack output = ItemStack.f_41583_;

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                if (slot == 0) {
                    this.input = copy;
                } else {
                    this.output = copy;
                }
            }

            public int getSlots() {
                return 3;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                if (slot == 0) {
                    return this.input;
                }
                return this.output;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                if (slot == 0) {
                    this.input = copy;
                } else {
                    this.output = copy;
                }
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return !IMinecoloniesAPI.getInstance().getFurnaceRecipes().getSmeltingResult(stack).m_41619_();
                }
                return false;
            }
        };
        this.playerInventory = inv;
        this.buildingPos = pos;
        this.m_38897_((Slot)new SlotItemHandler(this.furnaceInventory, 0, 56, 17){

            public int m_6641_() {
                return 1;
            }

            @NotNull
            public ItemStack m_6201_(int par1) {
                return ItemStack.f_41583_;
            }

            public boolean m_5857_(ItemStack par1ItemStack) {
                return true;
            }

            public boolean m_8010_(Player par1PlayerEntity) {
                return false;
            }
        });
        this.m_38897_((Slot)new SlotItemHandler(this.furnaceInventory, 1, 116, 35));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.playerInventory, i, 8 + i * 18, 142));
        }
    }

    public void m_150399_(int slotId, int clickedButton, ClickType mode, Player playerIn) {
        if (slotId >= 0 && slotId < 2) {
            if (mode == ClickType.PICKUP || mode == ClickType.PICKUP_ALL || mode == ClickType.SWAP) {
                Slot slot = (Slot)this.f_38839_.get(slotId);
                this.handleSlotClick(slot, this.m_142621_());
            }
        } else {
            super.m_150399_(slotId, clickedButton, mode, this.playerInventory.f_35978_);
        }
        this.updateFurnaceOutput();
    }

    public void setFurnaceInput(ItemStack stack) {
        this.handleSlotClick(this.m_38853_(0), stack);
        this.updateFurnaceOutput();
    }

    private ItemStack handleSlotClick(Slot slot, ItemStack stack) {
        if (stack.m_41613_() > 0) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            slot.m_5852_(copy);
        } else if (slot.m_7993_().m_41613_() > 0) {
            slot.m_5852_(ItemStack.f_41583_);
        }
        return slot.m_7993_().m_41777_();
    }

    private void updateFurnaceOutput() {
        if (!this.playerInventory.f_35978_.m_9236_().f_46443_) {
            ServerPlayer player = (ServerPlayer)this.playerInventory.f_35978_;
            ItemStack result = IMinecoloniesAPI.getInstance().getFurnaceRecipes().getSmeltingResult(this.furnaceInventory.getStackInSlot(0));
            this.furnaceInventory.insertItem(1, result, false);
            player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, 0, 1, result));
        }
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return true;
    }

    @NotNull
    public ItemStack m_7648_(Player playerIn, int index) {
        if (index <= 2) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = ItemStackUtils.EMPTY;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 2, 38, true)) {
                    return ItemStackUtils.EMPTY;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index < 32) {
                if (!this.m_38903_(itemstack1, 32, 38, false)) {
                    return ItemStackUtils.EMPTY;
                }
            } else if (index < 38 && !this.m_38903_(itemstack1, 2, 32, false) || !this.m_38903_(itemstack1, 2, 38, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStackUtils.EMPTY);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStackUtils.EMPTY;
            }
        }
        return itemstack;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return !(slotIn instanceof FurnaceResultSlot) && super.m_5882_(stack, slotIn);
    }

    public Player getPlayer() {
        return this.playerInventory.f_35978_;
    }

    public Level getWorldObj() {
        return this.playerInventory.f_35978_.m_9236_();
    }

    public BlockPos getPos() {
        return this.buildingPos;
    }

    public int getModuleId() {
        return this.moduleId;
    }
}

