/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.other;

import com.minecolonies.api.entity.pathfinding.IStuckHandlerEntity;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.LookHandler;
import com.minecolonies.api.util.constant.ColonyConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFastMinecoloniesEntity
extends PathfinderMob
implements IStuckHandlerEntity {
    private boolean canBeStuck = true;
    public final int randomVariance = ColonyConstants.rand.nextInt(20);
    private boolean isInFluid = false;
    private boolean onFire = false;
    private List<LivingEntity> entityPushCache = new ArrayList<LivingEntity>();
    private long lastHorizontalCollision = 0L;
    protected long lastKnockBack = 0L;
    final Byte ENABLE = 2;
    final Byte DISABLE = 0;

    protected AbstractFastMinecoloniesEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21365_ = new LookHandler((Mob)this);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    @Override
    public boolean canBeStuck() {
        return this.canBeStuck;
    }

    public void setCanBeStuck(boolean canBeStuck) {
        this.canBeStuck = canBeStuck;
    }

    protected boolean m_196406_(Vec3 vec3) {
        this.lastHorizontalCollision = this.f_19853_.m_46467_();
        return super.m_196406_(vec3);
    }

    public boolean hadHorizontalCollission() {
        return this.f_19853_.m_46467_() - this.lastHorizontalCollision < 10L;
    }

    public boolean m_21334_() {
        return false;
    }

    protected void m_147225_() {
    }

    protected void m_147226_() {
    }

    public void m_20321_(boolean down) {
    }

    protected int m_7302_(int supply) {
        return supply - 1;
    }

    protected int m_7305_(int supply) {
        return supply + 1;
    }

    protected void m_5806_(BlockPos pos) {
    }

    public void m_6138_() {
        if (this.m_9236_().m_5776_()) {
            this.f_19853_.m_142425_(EntityTypeTest.m_156916_(Player.class), this.m_20191_(), EntityUtils.pushableBy()).forEach(x$0 -> this.m_7324_((Entity)x$0));
        } else {
            if (this.f_19797_ % 10 == this.randomVariance % 10) {
                this.entityPushCache = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_());
            }
            if (!this.entityPushCache.isEmpty()) {
                int entityPushCacheSize = this.entityPushCache.size();
                for (int i = 0; i < entityPushCacheSize; ++i) {
                    Entity entity = (Entity)this.entityPushCache.get(i);
                    if (!this.m_20191_().m_82390_(entity.m_20182_())) continue;
                    this.m_7324_(entity);
                }
            }
        }
    }

    @Nullable
    public Entity changeDimension(@NotNull ServerLevel serverWorld, @NotNull ITeleporter teleporter) {
        return null;
    }

    public boolean m_5843_() {
        return false;
    }

    public void m_20323_() {
        if (this.f_19797_ % 20 == this.randomVariance) {
            super.m_20323_();
        }
    }

    protected boolean m_20073_() {
        if (this.f_19797_ % 10 == this.randomVariance % 10) {
            this.isInFluid = super.m_20073_();
        }
        return this.isInFluid;
    }

    public void m_146868_(boolean newState) {
        if (newState != this.onFire) {
            super.m_146868_(newState);
            this.onFire = newState;
        }
    }

    protected void m_20157_() {
    }

    public void m_5844_() {
    }

    public boolean m_5830_() {
        if (this.f_19797_ % 10 == this.randomVariance % 10) {
            return super.m_5830_();
        }
        return false;
    }

    public boolean m_20071_() {
        if (this.m_20094_() > 0 || this.f_19853_.f_46443_) {
            return super.m_20071_();
        }
        return false;
    }

    protected void m_21186_() {
    }

    protected void m_21185_() {
    }

    public boolean m_6039_() {
        return false;
    }

    public void m_21323_() {
        boolean flag;
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 5 == this.randomVariance % 5 && (!(flag = this.m_20291_(7)) || this.m_20096_() || this.m_20159_() || this.m_21023_(MobEffects.f_19620_))) {
            flag = false;
            this.m_20115_(7, flag);
        }
    }

    protected void m_8025_() {
    }

    public void m_146917_(int p_146918_) {
    }

    public void m_21333_() {
    }

    public void m_20260_(boolean enable) {
        if (enable) {
            this.f_19804_.m_135381_(f_19805_, (Object)this.ENABLE);
        } else {
            this.f_19804_.m_135381_(f_19805_, (Object)this.DISABLE);
        }
    }

    public boolean m_6144_() {
        return ((Byte)this.f_19804_.m_135370_(f_19805_)).byteValue() == this.ENABLE.byteValue();
    }

    public void m_147240_(double power, double xRatio, double zRatio) {
        if (this.f_19853_.m_46467_() - this.lastKnockBack > 60L) {
            this.lastKnockBack = this.f_19853_.m_46467_();
            super.m_147240_(power, xRatio, zRatio);
        }
    }

    public boolean m_6469_(DamageSource dmgSource, float dmg) {
        AbstractFastMinecoloniesEntity otherFastMinecolEntity;
        Entity entity = dmgSource.m_7639_();
        if (entity instanceof AbstractFastMinecoloniesEntity && (otherFastMinecolEntity = (AbstractFastMinecoloniesEntity)entity).getTeamId() == this.getTeamId()) {
            return false;
        }
        return super.m_6469_(dmgSource, dmg);
    }

    public abstract int getTeamId();

    public boolean m_6072_() {
        return false;
    }
}

