/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearExplosionEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.DrinkableBottledItem;
import com.github.alexmodguy.alexscaves.server.item.tooltip.SackOfSatingTooltip;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class SackOfSatingItem
extends Item {
    public SackOfSatingItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(ACItemRegistry.RARITY_SWEET));
    }

    public static int getHunger(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null ? compoundtag.m_128451_("HungerValue") : 0;
    }

    public static boolean isChewing(ItemStack itemStack, long gameTimeIn) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && compoundtag.m_128441_("ChewTimestamp") && gameTimeIn - compoundtag.m_128454_("ChewTimestamp") < 30L;
    }

    public static boolean isExploding(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && compoundtag.m_128471_("Exploding");
    }

    public static long getFeedTimestamp(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && compoundtag.m_128441_("FeedTimestamp") ? compoundtag.m_128454_("FeedTimestamp") : -1L;
    }

    public static void setHunger(ItemStack stack, int hunger) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("HungerValue", hunger);
    }

    public static void setChewTimestamp(ItemStack stack, long timestamp) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_("ChewTimestamp", timestamp);
    }

    public static void setFeedTimestamp(ItemStack stack, long timestamp) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128356_("FeedTimestamp", timestamp);
    }

    public static void setExploding(ItemStack stack, boolean exploding) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("Exploding", exploding);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new SackOfSatingTooltip(stack));
    }

    public boolean m_142305_(ItemStack sackStack, ItemStack foodStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction != ClickAction.SECONDARY || sackStack.m_41783_() == null || foodStack.m_204117_(ACTagRegistry.RESTRICTED_FROM_SACK_OF_SATING)) {
            return false;
        }
        if (!foodStack.m_41619_() && foodStack.m_41720_().m_41472_()) {
            ItemStack bowlStack;
            if (foodStack.m_204117_(ACTagRegistry.EXPLODES_SACK_OF_SATING)) {
                SackOfSatingItem.setExploding(sackStack, true);
            }
            int wholeHunger = SackOfSatingItem.calculateWholeStackHungerValue(foodStack, (LivingEntity)player);
            SackOfSatingItem.setHunger(sackStack, SackOfSatingItem.getHunger(sackStack) + wholeHunger);
            if (foodStack.m_41720_() instanceof BowlFoodItem && !player.m_36356_(bowlStack = new ItemStack((ItemLike)Items.f_42399_, foodStack.m_41613_()))) {
                player.m_36176_(bowlStack, false);
            }
            if ((foodStack.m_41720_() instanceof HoneyBottleItem || foodStack.m_41720_() instanceof DrinkableBottledItem) && !player.m_36356_(bowlStack = new ItemStack((ItemLike)Items.f_42590_, foodStack.m_41613_()))) {
                player.m_36176_(bowlStack, false);
            }
            foodStack.m_41764_(0);
            SackOfSatingItem.setChewTimestamp(sackStack, player.m_9236_().m_46467_());
            return true;
        }
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        super.m_6883_(stack, level, entity, i, held);
        if (stack.m_41783_() == null) {
            stack.m_41751_(new CompoundTag());
        }
        int hungerValue = SackOfSatingItem.getHunger(stack);
        long timestamp = SackOfSatingItem.getFeedTimestamp(stack);
        if (!level.f_46443_ && hungerValue > 0 && entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35934_ && player.f_19797_ % 100 == 0 && player.m_36391_(false) && (timestamp == -1L || player.m_9236_().m_46467_() - timestamp > 40L)) {
                player.m_36324_().m_38707_(1, 0.05f);
                SackOfSatingItem.setHunger(stack, hungerValue - 1);
                SackOfSatingItem.setFeedTimestamp(stack, player.m_9236_().m_46467_());
                level.m_142346_((Entity)player, GameEvent.f_157806_, player.m_20183_());
                level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
        if (SackOfSatingItem.isChewing(stack, level.m_46467_()) && entity.f_19797_ % 6 == 0) {
            level.m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.5f, level.f_46441_.m_188501_() * 0.3f + 1.3f);
        }
        if (SackOfSatingItem.isExploding(stack) && !level.f_46443_) {
            NuclearExplosionEntity explosion = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(level);
            explosion.m_146884_(entity.m_20182_().m_82520_(0.0, 4.0, 0.0));
            explosion.setSize(0.5f);
            explosion.setIntentionalGameDesign(true);
            level.m_7967_((Entity)explosion);
            SackOfSatingItem.setExploding(stack, false);
            stack.m_41774_(1);
        }
    }

    public static int calculateWholeStackHungerValue(ItemStack foodStack, LivingEntity eater) {
        FoodProperties foodProperties = foodStack.getFoodProperties(eater);
        if (foodProperties != null && !foodStack.m_204117_(ACTagRegistry.RESTRICTED_FROM_SACK_OF_SATING)) {
            return foodProperties.m_38744_() * foodStack.m_41613_();
        }
        return 0;
    }
}

