/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearSirenBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityDataRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.AdvancedPathNavigateNoTeleport;
import com.github.alexmodguy.alexscaves.server.entity.ai.AllFluidsPathNavigator;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalBreedEggsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.AnimalLayEggGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.DirectAquaticMoveControl;
import com.github.alexmodguy.alexscaves.server.entity.ai.LookAtLargeMobsGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.TremorzillaAttackGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.TremorzillaFollowOwnerGoal;
import com.github.alexmodguy.alexscaves.server.entity.ai.TremorzillaWanderGoal;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearBombEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaPartEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.ActivatesSirens;
import com.github.alexmodguy.alexscaves.server.entity.util.KaijuMob;
import com.github.alexmodguy.alexscaves.server.entity.util.KeybindUsingMount;
import com.github.alexmodguy.alexscaves.server.entity.util.ShakesScreen;
import com.github.alexmodguy.alexscaves.server.entity.util.TremorzillaLegSolver;
import com.github.alexmodguy.alexscaves.server.message.MountedEntityKeyMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.ITallWalker;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class TremorzillaEntity
extends DinosaurEntity
implements KeybindUsingMount,
IAnimatedEntity,
ShakesScreen,
KaijuMob,
ActivatesSirens,
ITallWalker {
    private static EntityDataAccessor<Optional<Vec3>> BEAM_END_POSITION = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)((EntityDataSerializer)ACEntityDataRegistry.OPTIONAL_VEC_3.get()));
    private static final EntityDataAccessor<Boolean> SWIMMING = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CHARGE = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> MAX_BEAM_BREAK_LENGTH = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SPIKES_DOWN_PROGRESS = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> FIRING = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TAME_ATTEMPTS = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)20);
    public static final Animation ANIMATION_ROAR_1 = Animation.create((int)60);
    public static final Animation ANIMATION_ROAR_2 = Animation.create((int)60);
    public static final Animation ANIMATION_RIGHT_SCRATCH = Animation.create((int)35);
    public static final Animation ANIMATION_LEFT_SCRATCH = Animation.create((int)35);
    public static final Animation ANIMATION_RIGHT_TAIL = Animation.create((int)40);
    public static final Animation ANIMATION_LEFT_TAIL = Animation.create((int)40);
    public static final Animation ANIMATION_RIGHT_STOMP = Animation.create((int)35);
    public static final Animation ANIMATION_LEFT_STOMP = Animation.create((int)35);
    public static final Animation ANIMATION_BITE = Animation.create((int)25);
    public static final Animation ANIMATION_PREPARE_BREATH = Animation.create((int)20);
    public static final Animation ANIMATION_CHEW = Animation.create((int)35);
    private static final int MAX_CHARGE = 1000;
    private final TremorzillaPartEntity[] allParts;
    public final TremorzillaPartEntity tailPart1;
    public final TremorzillaPartEntity tailPart2;
    public final TremorzillaPartEntity tailPart3;
    public final TremorzillaPartEntity tailPart4;
    public final TremorzillaPartEntity tailPart5;
    private float[] yawBuffer = new float[128];
    private int yawPointer = -1;
    protected float tailXRot;
    protected float tailYRot;
    public TremorzillaLegSolver legSolver = new TremorzillaLegSolver(1.0f, 2.15f, 3.0f);
    private static final EntityDimensions SWIMMING_SIZE = new EntityDimensions(4.0f, 5.0f, true);
    private Animation currentAnimation;
    private int animationTick;
    private float lastYawBeforeWhip;
    protected boolean isLandNavigator;
    private double lastStompX = 0.0;
    private double lastStompZ = 0.0;
    private float prevScreenShakeAmount;
    private float screenShakeAmount;
    private float beamProgress;
    private float prevBeamProgress;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private int lastScareTimestamp;
    private int blockBreakCounter = 0;
    private int steamFromMouthFor = 0;
    private int roarCooldown = 0;
    public Vec3 beamServerTarget;
    public Vec3 prevClientBeamEndPosition;
    public Vec3 clientBeamEndPosition;
    public boolean wantsToUseBeamFromServer = false;
    private float prevClientSpikesDownAmount = 0.0f;
    private float clientSpikesDownAmount = 0.0f;
    private int beamTime = 0;
    private int maxBeamTime = 200;
    private int timeWithoutTarget = 0;
    public int timeSwimming;
    private boolean wasPreviouslyChild;
    private final Explosion dummyExplosion;
    private int chargeSoundCooldown = 0;
    private boolean makingBeamSoundOnClient = false;
    private Player lastFedPlayer = null;
    private int killCountFromBeam = 0;

    public TremorzillaEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.switchNavigator(true);
        this.tailPart1 = new TremorzillaPartEntity(this, (Entity)this, 3.0f, 3.0f);
        this.tailPart2 = new TremorzillaPartEntity(this, (Entity)this.tailPart1, 2.5f, 2.0f);
        this.tailPart3 = new TremorzillaPartEntity(this, (Entity)this.tailPart2, 2.5f, 1.5f);
        this.tailPart4 = new TremorzillaPartEntity(this, (Entity)this.tailPart3, 2.5f, 1.5f);
        this.tailPart5 = new TremorzillaPartEntity(this, (Entity)this.tailPart4, 2.0f, 1.0f);
        this.allParts = new TremorzillaPartEntity[]{this.tailPart1, this.tailPart2, this.tailPart3, this.tailPart4, this.tailPart5};
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.dummyExplosion = new Explosion(this.m_9236_(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f, List.of());
    }

    protected PathNavigation m_6037_(Level level) {
        return new AdvancedPathNavigateNoTeleport((Mob)this, level);
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21365_ = new LookControl((Mob)this);
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = this.m_6037_(this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
            this.f_21342_ = new DirectAquaticMoveControl((PathfinderMob)this, 0.8f, 40.0f);
            this.f_21344_ = new AllFluidsPathNavigator((Mob)this, this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    public int m_6056_() {
        return super.m_6056_() + 10;
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BEAM_END_POSITION, Optional.empty());
        this.f_19804_.m_135372_(SWIMMING, (Object)false);
        this.f_19804_.m_135372_(CHARGE, (Object)1000);
        this.f_19804_.m_135372_(SPIKES_DOWN_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MAX_BEAM_BREAK_LENGTH, (Object)Float.valueOf(100.0f));
        this.f_19804_.m_135372_(TAME_ATTEMPTS, (Object)0);
        this.f_19804_.m_135372_(FIRING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22281_, 30.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new TremorzillaAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new TremorzillaFollowOwnerGoal(this, 1.0, 14.0f, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new AnimalBreedEggsGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new AnimalLayEggGoal((Animal)this, 100, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACBlockRegistry.WASTE_DRUM.get(), (ItemLike)ACBlockRegistry.NUCLEAR_BOMB.get()}), false));
        this.f_21345_.m_25352_(6, (Goal)new TremorzillaWanderGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtLargeMobsGoal((Mob)this, 3.0f, 30.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
    }

    public boolean isFakeEntity() {
        return this.f_19803_;
    }

    @Override
    public void m_8119_() {
        Vec3 beamEnd;
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        this.legSolver.update((LivingEntity)this, this.f_20883_, this.m_6134_());
        this.prevScreenShakeAmount = this.screenShakeAmount;
        this.prevBeamProgress = this.beamProgress;
        this.prevClientBeamEndPosition = this.clientBeamEndPosition;
        this.prevClientSpikesDownAmount = this.clientSpikesDownAmount;
        boolean water = this.isInFluidType();
        if (water && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!water && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isTremorzillaSwimming()) {
            ++this.timeSwimming;
            this.m_20301_(this.m_6062_());
        } else {
            this.timeSwimming = 0;
        }
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.34f);
        }
        if (this.isFiring() && this.beamProgress < 5.0f) {
            this.beamProgress += 1.0f;
        }
        if (!this.isFiring() && this.beamProgress > 0.0f) {
            this.beamProgress -= 1.0f;
        }
        this.clientSpikesDownAmount = Mth.m_14121_((float)this.clientSpikesDownAmount, (float)this.getSpikesDownAmount(), (float)0.1f);
        this.clientBeamEndPosition = beamEnd = this.getBeamEndPosition();
        if (this.isFiring()) {
            boolean flag = false;
            if (this.isFiring() && beamEnd != null) {
                Vec3 vec3 = beamEnd.m_82546_(this.getBeamShootFrom(1.0f));
                float beamYaw = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f;
                if (Mth.m_14145_((float)beamYaw, (float)Mth.m_14177_((float)this.f_20883_)) > 80.0f) {
                    flag = true;
                    this.m_146922_(Mth.m_14148_((float)this.m_146908_(), (float)beamYaw, (float)10.0f));
                    this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)beamYaw, (float)10.0f);
                    this.lastYawBeforeWhip = beamYaw;
                }
            }
            if (!flag) {
                this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.lastYawBeforeWhip, (float)15.0f);
            }
        } else if (this.getAnimation() != ANIMATION_RIGHT_TAIL && this.getAnimation() != ANIMATION_LEFT_TAIL) {
            this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.m_146908_(), (float)4.0f);
            this.f_20885_ = Mth.m_14148_((float)this.f_20886_, (float)this.f_20885_, (float)2.0f);
            this.lastYawBeforeWhip = this.f_20883_;
        } else {
            float negative = this.getAnimation() == ANIMATION_RIGHT_TAIL ? -1.0f : 1.0f;
            float target = 0.0f;
            if (this.getAnimationTick() < 5) {
                f = (float)this.getAnimationTick() / 5.0f;
                target = f * -10.0f;
            } else {
                f = (float)(this.getAnimationTick() - 10) / 15.0f;
                target = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f) * 170.0f;
            }
            if ((float)this.getAnimationTick() > 25.0f) {
                this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.lastYawBeforeWhip, (float)15.0f);
            } else {
                this.f_267362_.m_267771_(1.0f + AlexsCaves.PROXY.getPartialTicks());
                this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)(this.lastYawBeforeWhip + negative * target), (float)70.0f);
            }
        }
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.15f);
        }
        if (this.m_20096_() && !this.isInFluidType() && this.f_267362_.m_267731_() > 0.1f && !this.m_6162_() && !this.m_21525_() && this.m_6084_()) {
            float f = (float)Math.cos(this.f_267362_.m_267756_() * 0.25f - 1.5f);
            float f1 = (float)Math.cos(this.f_267362_.m_267756_() * 0.25f - 1.0f);
            float f2 = (float)Math.sin(this.f_267362_.m_267756_() * 0.25f - 1.0f);
            if (Math.abs(f) < 0.2f) {
                if ((double)this.screenShakeAmount <= 0.3) {
                    this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_STOMP.get(), 6.0f, 0.7f);
                }
                this.screenShakeAmount = 2.0f;
            }
            if (this.f_267362_.m_267731_() > 0.5f && Math.abs(f1) < 0.1f) {
                this.stompEffect(f2 > 0.0f, 1.0f, 1.3f, 0.4f + this.f_267362_.m_267731_(), 2.0f);
            }
        }
        this.tickMultipart();
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
            Player player = AlexsCaves.PROXY.getClientSidePlayer();
            if (player != null && player.m_20365_((Entity)this)) {
                if (AlexsCaves.PROXY.isKeyDown(2) && this.getMeterAmount() >= 1.0f) {
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 2));
                }
                if (AlexsCaves.PROXY.isKeyDown(3) && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == null)) {
                    AlexsCaves.sendMSGToServer(new MountedEntityKeyMessage(this.m_19879_(), player.m_19879_(), 3));
                }
            }
            if (this.isFiring() && this.beamProgress > 0.0f && !this.makingBeamSoundOnClient) {
                AlexsCaves.PROXY.playWorldSound(this, (byte)16);
                this.makingBeamSoundOnClient = true;
            }
            if (!this.isFiring() && this.makingBeamSoundOnClient) {
                AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
                this.makingBeamSoundOnClient = false;
            }
        } else {
            double waterHeight = this.getMaxFluidHeight();
            if (waterHeight > 0.0 && waterHeight < (double)(this.m_20206_() - 1.0f) && !this.f_19863_) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.02, 0.0));
            }
            this.setTremorzillaSwimming(waterHeight > 2.0);
        }
        if (this.m_6084_()) {
            if (this.isFiring()) {
                this.tickBreath();
            } else if (this.steamFromMouthFor > 0 && this.m_9236_().f_46443_) {
                this.m_9236_().m_6485_((ParticleOptions)ACParticleRegistry.TREMORZILLA_STEAM.get(), true, this.m_20185_(), this.m_20188_(), this.m_20189_(), (double)this.m_19879_(), 0.0, 0.0);
            }
            if (!this.isFiring() && this.killCountFromBeam > 0) {
                if (this.killCountFromBeam > 20 && !this.m_9236_().f_46443_ && this.m_20160_()) {
                    for (Entity passenger : this.m_20197_()) {
                        ACAdvancementTriggerRegistry.TREMORZILLA_KILL_BEAM.triggerForEntity(passenger);
                    }
                }
                this.killCountFromBeam = 0;
            }
            if ((this.getAnimation() == ANIMATION_RIGHT_SCRATCH || this.getAnimation() == ANIMATION_LEFT_SCRATCH) && this.getAnimationTick() == 18) {
                Vec3 center = new Vec3(0.0, (double)(5.0f * this.m_6134_()), (double)(6.0f * this.m_6134_())).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)).m_82549_(this.m_20182_());
                this.hurtEntitiesAround(center, 6.0f, 10.0f, 2.0f, false, true, true);
                if (!this.m_9236_().f_46443_) {
                    this.breakBlocksAround(center, 3.0f, false, false, 0.6f);
                }
            }
            if ((this.getAnimation() == ANIMATION_RIGHT_TAIL || this.getAnimation() == ANIMATION_LEFT_TAIL) && this.getAnimationTick() >= 10 && this.getAnimationTick() < 25) {
                this.hurtEntitiesAround(this.tailPart1.centeredPosition(), 4.0f, 10.0f, 2.0f, false, true, true);
                this.hurtEntitiesAround(this.tailPart2.centeredPosition(), 4.0f, 10.0f, 2.0f, false, true, true);
                this.hurtEntitiesAround(this.tailPart3.centeredPosition(), 4.0f, 10.0f, 2.0f, false, true, true);
                this.hurtEntitiesAround(this.tailPart4.centeredPosition(), 3.0f, 10.0f, 2.0f, false, true, true);
                this.hurtEntitiesAround(this.tailPart5.centeredPosition(), 3.0f, 10.0f, 2.0f, false, true, true);
                if (!this.m_9236_().f_46443_) {
                    this.breakBlocksAround(this.tailPart1.centeredPosition(), 2.0f, false, false, 0.6f);
                    this.breakBlocksAround(this.tailPart2.centeredPosition(), 2.0f, false, false, 0.6f);
                    this.breakBlocksAround(this.tailPart3.centeredPosition(), 2.0f, false, false, 0.6f);
                    this.breakBlocksAround(this.tailPart4.centeredPosition(), 1.0f, false, false, 0.6f);
                    this.breakBlocksAround(this.tailPart5.centeredPosition(), 1.0f, false, false, 0.6f);
                }
            }
            if ((this.getAnimation() == ANIMATION_LEFT_STOMP || this.getAnimation() == ANIMATION_RIGHT_STOMP) && this.getAnimationTick() == 18) {
                this.stompEffect(this.getAnimation() == ANIMATION_LEFT_STOMP, 2.0f, 5.0f, 1.2f, 10.0f);
                this.screenShakeAmount = 4.0f;
            }
            if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 10) {
                Vec3 center = new Vec3(0.0, (double)(7.0f * this.m_6134_()), (double)(5.0f * this.m_6134_())).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)).m_82549_(this.m_20182_());
                this.hurtEntitiesAround(center, 7.5f, 10.0f, 2.0f, false, true, true);
                if (!this.m_9236_().f_46443_) {
                    this.breakBlocksAround(center, 4.0f, false, false, 0.6f);
                }
            }
            if (this.getAnimation() == ANIMATION_ROAR_1 && this.getAnimationTick() > 10 && this.getAnimationTick() < 50 || this.getAnimation() == ANIMATION_ROAR_2 && this.getAnimationTick() > 15 && this.getAnimationTick() < 50) {
                this.screenShakeAmount = 8.0f;
                if (!this.m_9236_().f_46443_) {
                    this.scareMobs();
                }
            }
            if (this.getAnimation() == ANIMATION_SPEAK && this.getAnimationTick() == 5 && !this.isFiring()) {
                this.actuallyPlayAmbientSound();
            }
        }
        if (!this.m_9236_().f_46443_) {
            float healthAmount;
            LivingEntity target = this.m_5448_();
            this.timeWithoutTarget = target == null || !target.m_6084_() ? ++this.timeWithoutTarget : 0;
            if (this.wantsToUseBeamFromServer && (this.timeWithoutTarget > 100 && !this.m_20160_() || this.m_21825_())) {
                this.wantsToUseBeamFromServer = false;
            }
            if (this.isFiring()) {
                this.wantsToUseBeamFromServer = false;
                int iterateBy = 1;
                if (!this.m_20160_()) {
                    if (target == null || !target.m_6084_()) {
                        iterateBy = 3;
                    } else if (target.m_20270_((Entity)this) > 100.0f) {
                        iterateBy = 8;
                    }
                }
                this.beamTime += iterateBy;
                if (this.beamTime > this.maxBeamTime) {
                    this.beamTime = 0;
                    this.setFiring(false);
                    this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_BEAM_END.get(), 8.0f, 1.0f);
                    this.beamServerTarget = null;
                    this.setBeamEndPosition(null);
                    this.setCharge(0);
                } else {
                    if (!this.isStunned()) {
                        this.tickBeamTargeting();
                    }
                    this.setCharge(1000);
                }
            } else if (this.wantsToUseBeamFromServer && this.isPowered()) {
                float f;
                Level level;
                float spikesThreshold = 0.95f;
                if (this.getAnimation() == ANIMATION_PREPARE_BREATH && this.getSpikesDownAmount() >= spikesThreshold && this.getAnimationTick() > 15 && !this.isFiring()) {
                    this.maxBeamTime = 100 + this.f_19796_.m_188503_(150);
                    this.beamServerTarget = this.createInitialBeamVec();
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.beamServerTarget);
                    this.setFiring(true);
                    this.setMaxBeamBreakLength(100.0f);
                }
                if (this.getSpikesDownAmount() >= spikesThreshold && this.getAnimation() == NO_ANIMATION && !this.isStunned()) {
                    this.setAnimation(ANIMATION_PREPARE_BREATH);
                    this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_BEAM_START.get(), 8.0f, 1.0f);
                }
                this.setSpikesDownAmount(Math.min(this.getSpikesDownAmount() + 0.005f, 1.0f));
                if ((this.f_19797_ + this.m_19879_()) % 10 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.getNearbySirens(serverLevel, 256).forEach(this::activateSiren);
                }
                if (Math.floor((f = TremorzillaEntity.calculateSpikesDownAmount(this.getSpikesDownAmount(), 6.0f)) - 0.005f) != Math.floor(f) && this.chargeSoundCooldown <= 0 && f <= 5.0f) {
                    float pitch = 0.7f + this.getSpikesDownAmount() * 0.7f;
                    this.m_5496_(f > 4.0f ? (SoundEvent)ACSoundRegistry.TREMORZILLA_CHARGE_COMPLETE.get() : (SoundEvent)ACSoundRegistry.TREMORZILLA_CHARGE_NORMAL.get(), 8.0f, pitch);
                    this.chargeSoundCooldown = 19;
                }
                if (this.chargeSoundCooldown > 0) {
                    --this.chargeSoundCooldown;
                }
            } else {
                this.setSpikesDownAmount(Math.max(this.getSpikesDownAmount() - 0.05f, 0.0f));
                if (!(!(this.m_20184_().m_165924_() < 0.05) || this.getAnimation() != NO_ANIMATION || this.isDancing() || this.m_21825_() || this.m_21525_() || this.f_19796_.m_188503_(800) != 0 || this.m_20160_())) {
                    this.tryRoar();
                }
            }
            if (!this.isPowered()) {
                this.setCharge(this.getCharge() + 1);
            }
            if ((healthAmount = this.m_21223_() / this.m_21233_()) <= 0.2f) {
                this.healEveryTick(10, 5.0f);
            } else if (healthAmount <= 0.5f) {
                this.healEveryTick(20, 3.0f);
            } else {
                this.healEveryTick(100, 2.0f);
            }
        }
        if (!this.isPowered()) {
            this.setSpikesDownAmount(0.0f);
        }
        if (this.steamFromMouthFor > 0) {
            --this.steamFromMouthFor;
        }
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
        }
        if (this.wasPreviouslyChild != this.m_6162_()) {
            this.wasPreviouslyChild = this.m_6162_();
            this.m_6210_();
            for (TremorzillaPartEntity tremorzillaPartEntity : this.allParts) {
                tremorzillaPartEntity.m_6210_();
            }
        }
        if (this.m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get())) {
            MobEffectInstance instance = this.m_21124_((MobEffect)ACEffectRegistry.IRRADIATED.get());
            int level = instance == null ? 1 : 1 + instance.m_19564_();
            this.m_5634_(level * 12);
            this.m_21195_((MobEffect)ACEffectRegistry.IRRADIATED.get());
        }
        if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() == 2) {
            this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_BITE.get(), 4.0f, this.m_6100_());
        }
        if ((this.getAnimation() == ANIMATION_RIGHT_SCRATCH || this.getAnimation() == ANIMATION_LEFT_SCRATCH) && this.getAnimationTick() == 2) {
            this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_SCRATCH_ATTACK.get(), 4.0f, this.m_6100_());
        }
        if ((this.getAnimation() == ANIMATION_RIGHT_STOMP || this.getAnimation() == ANIMATION_LEFT_STOMP) && this.getAnimationTick() == 2) {
            this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_STOMP_ATTACK.get(), 4.0f, this.m_6100_());
        }
        if ((this.getAnimation() == ANIMATION_RIGHT_TAIL || this.getAnimation() == ANIMATION_LEFT_TAIL) && this.getAnimationTick() == 2) {
            this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_TAIL_ATTACK.get(), 4.0f, this.m_6100_());
        }
        if (this.getAnimation() == ANIMATION_CHEW && this.getAnimationTick() % 6 == 0 && this.getAnimationTick() <= 30) {
            this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_EAT.get(), 4.0f, this.m_6100_());
            if (this.m_9236_().f_46443_) {
                BlockParticleOption particleOption1 = new BlockParticleOption(ParticleTypes.f_123794_, ((Block)ACBlockRegistry.BLOCK_OF_URANIUM.get()).m_49966_());
                BlockParticleOption particleOption2 = new BlockParticleOption(ParticleTypes.f_123794_, ((Block)ACBlockRegistry.WASTE_DRUM.get()).m_49966_());
                for (int i = 0; i < 8; ++i) {
                    Vec3 particlesPos = this.getBeamShootFrom(1.0f).m_82549_(new Vec3(this.f_19796_.m_188499_() ? (double)-0.8f : (double)0.8f, 2.0, (double)(2.5f + this.f_19796_.m_188501_())).m_82490_((double)this.m_6134_()).m_82496_((float)Math.toRadians(-this.m_146909_())).m_82524_((float)Math.toRadians(-this.m_6080_())));
                    this.m_9236_().m_6485_((ParticleOptions)(this.f_19796_.m_188503_(3) == 0 ? particleOption2 : particleOption1), true, particlesPos.f_82479_, particlesPos.f_82480_, particlesPos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.m_9236_().f_46443_ && this.getAnimation() == ANIMATION_CHEW && this.getAnimationTick() == 34 && this.lastFedPlayer != null) {
            if (!this.m_21824_()) {
                this.setTameAttempts(this.getTameAttempts() + 1);
                if (this.getTameAttempts() >= 4 && this.m_217043_().m_188503_(3) == 0) {
                    this.m_21828_(this.lastFedPlayer);
                    this.m_147271_();
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            this.lastFedPlayer = null;
        }
        this.lastStompX = this.f_19854_;
        this.lastStompZ = this.f_19856_;
    }

    private double getMaxFluidHeight() {
        return this.getFluidTypeHeight(this.getMaxHeightFluidType());
    }

    private void healEveryTick(int i, float health) {
        if (this.f_19797_ % i == 0) {
            this.m_5634_(health);
        }
    }

    private void tickBeamTargeting() {
        LivingEntity livingEntity;
        LivingEntity target = this.m_5448_();
        Vec3 vec3 = this.beamServerTarget == null ? this.m_20182_() : this.beamServerTarget;
        Vec3 shootFrom = this.getBeamShootFrom(1.0f);
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            Vec3 approach;
            Player player = (Player)livingEntity;
            Vec3 riderPointing = player.m_20252_(1.0f).m_82490_(100.0);
            this.beamServerTarget = approach = shootFrom.m_82549_(riderPointing).m_82546_(vec3).m_82490_((double)0.2f).m_82549_(vec3);
        } else if (target != null && target.m_6084_()) {
            Vec3 approach;
            float time = (float)this.beamTime / (float)this.maxBeamTime;
            float accuracy = 1.0f - Math.min(0.75f, time) / 0.75f;
            Vec3 position = target.m_20182_();
            Vec3 swingVec = new Vec3(Math.sin((float)this.f_19797_ * 0.2f) * 6.0, 0.0, Math.cos((float)this.f_19797_ * 0.2f) * -6.0).m_82524_((float)Math.toRadians(-this.f_20883_)).m_82490_((double)accuracy);
            this.beamServerTarget = approach = position.m_82549_(swingVec).m_82546_(vec3).m_82490_((double)0.1f).m_82549_(vec3);
        } else {
            Vec3 approach;
            Vec3 newTarget = new Vec3(Math.sin((float)this.f_19797_ * 0.1f) * 10.0, this.beamServerTarget.f_82480_ - shootFrom.f_82480_, 6.0).m_82524_((float)Math.toRadians(-this.f_20883_));
            this.beamServerTarget = approach = shootFrom.m_82549_(newTarget).m_82546_(vec3).m_82490_((double)0.1f).m_82549_(vec3);
        }
    }

    private Vec3 createInitialBeamVec() {
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_6084_()) {
            Vec3 randomRot = new Vec3((double)(-100.0f + this.f_19796_.m_188501_() * 200.0f), 0.0, (double)(15.0f + 15.0f * this.f_19796_.m_188501_())).m_82524_((float)Math.toRadians(-this.f_20883_ + 50.0f - this.f_19796_.m_188501_() * 100.0f));
            Vec3 position = target instanceof KaijuMob ? target.m_146892_() : target.m_20182_();
            return position.m_82549_(randomRot);
        }
        if (this.m_20160_()) {
            Vec3 vec3 = new Vec3(0.0, 0.0, 10.0).m_82524_((float)Math.toRadians(-this.f_20883_));
            return this.getBeamShootFrom(1.0f).m_82549_(vec3);
        }
        Vec3 vec3 = new Vec3(0.0, this.f_19796_.m_188499_() ? 100.0 : 20.0, 6.0).m_82524_((float)Math.toRadians(-this.f_20883_));
        return this.getBeamShootFrom(1.0f).m_82549_(vec3);
    }

    @Override
    public void m_7023_(Vec3 vec3d) {
        if (this.getAnimation() == ANIMATION_LEFT_STOMP || this.getAnimation() == ANIMATION_RIGHT_STOMP || this.getAnimation() == ANIMATION_LEFT_TAIL || this.getAnimation() == ANIMATION_RIGHT_TAIL || this.isFiring() && !this.m_20160_()) {
            vec3d = Vec3.f_82478_;
            super.m_7023_(vec3d);
        } else if (this.isInFluidType() && (this.m_21515_() || this.m_20160_())) {
            this.m_19920_(this.m_6113_(), vec3d);
            Vec3 delta = this.m_20184_();
            this.m_6478_(MoverType.SELF, delta);
            if (this.f_19862_) {
                delta = delta.m_82520_(0.0, 0.05, 0.0);
            }
            this.m_20256_(delta.m_82490_(0.8));
            this.m_267651_(false);
        } else {
            super.m_7023_(vec3d);
        }
    }

    public int m_21529_() {
        return 3;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.lastStompX), (double)0.0, (double)(this.m_20189_() - this.lastStompZ));
        float walkSpeed = 4.0f;
        if (this.m_20160_()) {
            walkSpeed = 1.5f;
        }
        float f2 = Math.min(f1 * walkSpeed, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) && this.blockBreakCounter <= 0) {
                this.breakBlocksInBoundingBox(0.1f);
                this.blockBreakCounter = 10;
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
            }
        }
    }

    public void m_8032_() {
        if (this.getAnimation() == NO_ANIMATION && !this.m_9236_().f_46443_ && !this.isFiring()) {
            this.setAnimation(ANIMATION_SPEAK);
        }
    }

    public void actuallyPlayAmbientSound() {
        SoundEvent soundevent = this.m_7515_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        AlexsCaves.PROXY.clearSoundCacheFor((Entity)this);
        super.m_142687_(removalReason);
    }

    private void tickMultipart() {
        boolean tail;
        if (this.yawPointer == -1) {
            for (int i = 0; i < this.yawBuffer.length; ++i) {
                this.yawBuffer[i] = this.f_20883_;
            }
        }
        if (++this.yawPointer == this.yawBuffer.length) {
            this.yawPointer = 0;
        }
        this.yawBuffer[this.yawPointer] = this.f_20883_;
        Vec3[] avector3d = new Vec3[this.allParts.length];
        for (int j = 0; j < this.allParts.length; ++j) {
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
        }
        boolean bl = tail = this.getAnimation() == ANIMATION_LEFT_TAIL || this.getAnimation() == ANIMATION_RIGHT_TAIL;
        float tailRotateSpeed = tail ? 25.0f : (this.isTremorzillaSwimming() ? 20.0f : 5.0f);
        this.tailXRot = this.wrapTailDegrees(Mth.m_14148_((float)this.tailXRot, (float)this.getTargetTailXRot(), (float)tailRotateSpeed));
        this.tailYRot = this.wrapTailDegrees(Mth.m_14148_((float)this.tailYRot, (float)this.getTargetTailYRot(), (float)tailRotateSpeed));
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() * 0.5f - this.getLegSolverBodyOffset()), 0.0);
        float tailXStep = this.tailXRot / 5.0f;
        float tailYStep = this.tailYRot / 5.0f;
        this.tailPart1.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, this.isTremorzillaSwimming() ? 0.0 : -4.0, -3.5).m_82490_((double)this.m_6134_()), tailXStep, this.f_20883_ + tailYStep).m_82549_(center));
        this.tailPart2.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, -0.25, -3.25).m_82490_((double)this.m_6134_()), tailXStep, this.f_20883_ + tailYStep * 2.0f).m_82549_(this.tailPart1.centeredPosition()));
        this.tailPart3.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, -2.5).m_82490_((double)this.m_6134_()), tailXStep, this.f_20883_ + tailYStep * 3.0f).m_82549_(this.tailPart2.centeredPosition()));
        this.tailPart4.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, -2.5).m_82490_((double)this.m_6134_()), tailXStep, this.f_20883_ + tailYStep * 4.0f).m_82549_(this.tailPart3.centeredPosition()));
        this.tailPart5.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, -2.0).m_82490_((double)this.m_6134_()), tailXStep, this.f_20883_ + tailYStep * 5.0f).m_82549_(this.tailPart4.centeredPosition()));
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
    }

    private float getTargetTailXRot() {
        if (this.getAnimation() == ANIMATION_LEFT_TAIL || this.getAnimation() == ANIMATION_RIGHT_TAIL) {
            return this.getAnimationTick() > 10 ? 45.0f : 0.0f;
        }
        return 0.0f;
    }

    private float getTargetTailYRot() {
        float target = this.getYawFromBuffer(this.isTremorzillaSwimming() ? 2 : 20, 1.0f) - this.f_20883_;
        float swimAmount = this.m_20998_(1.0f);
        float swimAddition = (float)((double)swimAmount * Math.sin((float)this.f_19797_ * 0.4f) * 25.0);
        float swingAddition = (float)(Math.sin((float)this.f_19797_ * 0.03f) * 10.0);
        if (this.m_21825_() && !this.isDancing()) {
            return target + 90.0f;
        }
        if (this.getAnimation() == ANIMATION_LEFT_TAIL || this.getAnimation() == ANIMATION_RIGHT_TAIL) {
            return this.lastYawBeforeWhip - this.f_20883_ + (float)this.getAnimationTick() > 15.0f ? -70.0f : 70.0f;
        }
        return target + swimAddition + swingAddition;
    }

    public float getLegSolverBodyOffset() {
        float swimAmount = this.m_20998_(1.0f);
        float heightBackLeft = this.legSolver.backLeft.getHeight(1.0f);
        float heightBackRight = this.legSolver.backRight.getHeight(1.0f);
        return Math.max(heightBackLeft, heightBackRight) * 0.8f * (1.0f - swimAmount);
    }

    protected Vec3 rotateOffsetVec(Vec3 offset, float xRot, float yRot) {
        return offset.m_82496_(-xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180));
    }

    public boolean isStunned() {
        return this.m_21023_((MobEffect)ACEffectRegistry.STUNNED.get());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCharge(compound.m_128451_("Charge"));
        this.setSpikesDownAmount(compound.m_128457_("SpikesDownAmount"));
        this.wantsToUseBeamFromServer = compound.m_128471_("ServerBeamTrigger");
        this.setTameAttempts(compound.m_128451_("TameAttempts"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Charge", this.getCharge());
        compound.m_128350_("SpikesDownAmount", this.getSpikesDownAmount());
        compound.m_128379_("ServerBeamTrigger", this.wantsToUseBeamFromServer);
        compound.m_128405_("TameAttempts", this.getTameAttempts());
    }

    private void tickBreath() {
        if (this.m_9236_().f_46443_) {
            Vec3 endBeamPos = this.getClientBeamEndPosition(1.0f);
            if (endBeamPos != null) {
                Vec3 particleVec = endBeamPos.m_82520_((double)((this.f_19796_.m_188501_() - 0.5f) * 3.0f), (double)((this.f_19796_.m_188501_() - 0.5f) * 3.0f), (double)((this.f_19796_.m_188501_() - 0.5f) * 3.0f));
                this.m_9236_().m_6485_(this.getAltSkin() == 2 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_TECTONIC_EXPLOSION.get() : (this.getAltSkin() == 1 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_RETRO_EXPLOSION.get() : (ParticleOptions)ACParticleRegistry.TREMORZILLA_EXPLOSION.get()), true, particleVec.f_82479_, particleVec.f_82480_, particleVec.f_82481_, 0.0, 0.0, 0.0);
                this.m_9236_().m_6485_(this.getAltSkin() == 2 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_TECTONIC_LIGHTNING.get() : (this.getAltSkin() == 1 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_RETRO_LIGHTNING.get() : (ParticleOptions)ACParticleRegistry.TREMORZILLA_LIGHTNING.get()), true, this.m_20185_(), this.m_20188_(), this.m_20189_(), (double)this.m_19879_(), 0.0, 0.0);
                if (this.m_217043_().m_188501_() < 0.3f) {
                    this.m_9236_().m_6485_(this.getAltSkin() == 2 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_TECTONIC_PROTON.get() : (this.getAltSkin() == 1 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_RETRO_PROTON.get() : (ParticleOptions)ACParticleRegistry.TREMORZILLA_PROTON.get()), true, this.m_20185_(), this.m_20188_(), this.m_20189_(), (double)this.m_19879_(), 0.0, 0.0);
                }
            }
        } else {
            if (this.beamServerTarget != null) {
                Vec3 from = this.getBeamShootFrom(1.0f);
                Vec3 normalized = from.m_82549_(this.beamServerTarget.m_82546_(from).m_82541_().m_82490_(100.0));
                this.setBeamEndPosition(this.m_9236_().m_45547_(new ClipContext(from, normalized, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_82450_());
            }
            Vec3 endBeamPos = this.getBeamEndPosition();
            boolean brokenClosestBlocks = false;
            float furthestBlockDist = 10.0f;
            if (endBeamPos != null && this.beamTime % 3 == 0) {
                Vec3 start;
                Vec3 startClip = start = this.getBeamShootFrom(1.0f);
                Vec3 viewVec = endBeamPos.m_82546_(startClip).m_82541_();
                float destructionScale = 5.0f;
                float walkThroughBeam = 1.0f;
                while ((double)walkThroughBeam < this.getMaxBeamBreakLength()) {
                    startClip = startClip.m_82549_(viewVec.m_82490_((double)(destructionScale * 1.5f)));
                    if (!brokenClosestBlocks) {
                        brokenClosestBlocks = this.breakBlocksAround(startClip, (Boolean)AlexsCaves.COMMON_CONFIG.devastatingTremorzillaBeam.get() != false ? destructionScale : destructionScale * 0.75f, false, true, 0.08f);
                        furthestBlockDist = (float)startClip.m_82554_(start);
                    }
                    this.hurtEntitiesAround(startClip, destructionScale + 1.0f, 20.0f, 1.0f, true, true, false);
                    walkThroughBeam += destructionScale;
                }
                this.hurtEntitiesAround(endBeamPos, 6.0f, 20.0f, 1.0f, true, true, false);
                if (((Boolean)AlexsCaves.COMMON_CONFIG.devastatingTremorzillaBeam.get()).booleanValue() && this.beamTime % 6 == 0) {
                    this.breakBlocksAround(endBeamPos, 4.0f, false, true, 0.08f);
                }
            }
            if (brokenClosestBlocks) {
                this.setMaxBeamBreakLength((float)Math.max((double)furthestBlockDist, this.getMaxBeamBreakLength() - 5.0));
            }
        }
        this.steamFromMouthFor = 200;
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (SWIMMING.equals(dataAccessor)) {
            this.m_6210_();
        }
    }

    private void stompEffect(boolean left, float size, float hurtSize, float forwards, float damage) {
        float particleRadius = 0.3f + size * this.m_6134_();
        Vec3 center = this.m_20182_().m_82549_(new Vec3(left ? (double)2.2f : (double)-2.2f, 0.0, (double)forwards).m_82524_(-this.f_20883_ * ((float)Math.PI / 180)));
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 4; ++i) {
                for (int i1 = 0; i1 < 10 + this.f_19796_.m_188503_(10); ++i1) {
                    double motionX = this.m_217043_().m_188583_() * 0.07;
                    double motionY = 0.07 + this.m_217043_().m_188583_() * 0.07;
                    double motionZ = this.m_217043_().m_188583_() * 0.07;
                    float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                    double extraX = particleRadius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                    double extraY = 1.0;
                    double extraZ = particleRadius * Mth.m_14089_((float)angle);
                    Vec3 groundedVec = ACMath.getGroundBelowPosition((BlockGetter)this.m_9236_(), new Vec3((double)Mth.m_14107_((double)(center.f_82479_ + extraX)), (double)(Mth.m_14107_((double)(center.f_82480_ + extraY)) - 1), (double)Mth.m_14107_((double)(center.f_82481_ + extraZ))));
                    BlockPos ground = BlockPos.m_274446_((Position)groundedVec.m_82492_(0.0, 0.5, 0.0));
                    BlockState state = this.m_9236_().m_8055_(ground);
                    if (!state.m_280296_()) continue;
                    this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), true, center.f_82479_ + extraX, (double)ground.m_123342_() + extraY, center.f_82481_ + extraZ, motionX, motionY, motionZ);
                }
            }
        }
        this.hurtEntitiesAround(center, particleRadius + hurtSize, damage, 0.5f, false, false, false);
    }

    public boolean hurtEntitiesAround(Vec3 center, float radius, float damageAmount, float knockbackAmount, boolean radioactive, boolean hurtsOtherKaiju, boolean stretchY) {
        AABB aabb = new AABB(center.m_82492_((double)radius, (double)radius, (double)radius), center.m_82520_((double)radius, (double)radius, (double)radius));
        if (stretchY) {
            aabb.m_165887_(this.m_20186_() - 1.0);
            aabb.m_165893_(this.m_20188_() + 3.0);
        }
        boolean flag = false;
        DamageSource damageSource = radioactive ? ACDamageTypes.causeTremorzillaBeamDamage(this.m_9236_().m_9598_(), (Entity)this) : this.m_269291_().m_269333_((LivingEntity)this);
        for (LivingEntity living : this.m_9236_().m_6443_(LivingEntity.class, aabb, EntitySelector.f_20406_)) {
            if (living.m_7306_((Entity)this) || this.m_7307_((Entity)living) || living.m_6095_() == this.m_6095_()) continue;
            double d = center.f_82479_;
            double d2 = stretchY ? living.m_20186_() : center.f_82480_;
            if (!(living.m_20275_(d, d2, center.f_82481_) <= (double)(radius * radius)) || radioactive && !this.canEntityBeHurtByBeam(living, center) || !hurtsOtherKaiju && living instanceof KaijuMob || !living.m_6469_(damageSource, damageAmount)) continue;
            flag = true;
            this.knockbackTarget((Entity)living, knockbackAmount, this.m_20185_() - living.m_20185_(), this.m_20189_() - living.m_20189_(), !(living instanceof KaijuMob));
            if (!radioactive) continue;
            if (living.m_21223_() <= 0.0f && living instanceof Enemy) {
                ++this.killCountFromBeam;
            }
            living.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 6000, 2));
        }
        return flag;
    }

    private boolean canEntityBeHurtByBeam(LivingEntity living, Vec3 center) {
        return this.m_9236_().m_45547_(new ClipContext(center, living.m_20182_().m_82520_(0.0, (double)living.m_20206_() * 0.5, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public void knockbackTarget(Entity target, double strength, double x, double z, boolean ignoreResistance) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)this, (float)((float)strength), (double)x, (double)z);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        x = event.getRatioX();
        z = event.getRatioZ();
        if (!ignoreResistance) {
            strength *= 1.0 - this.m_21133_(Attributes.f_22278_);
        }
        if (!(strength <= 0.0)) {
            this.f_19812_ = true;
            Vec3 vec3 = this.m_20184_();
            Vec3 vec31 = new Vec3(x, 0.0, z).m_82541_().m_82490_(strength);
            target.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, this.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0 + strength) : vec3.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
        }
    }

    public boolean breakBlocksAround(Vec3 center, float radius, boolean square, boolean triggerExplosions, float dropChance) {
        if (this.m_6162_() || !ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) || this.m_9236_().f_46443_) {
            return false;
        }
        boolean flag = false;
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)(center.f_82479_ - (double)radius)), (int)Mth.m_14107_((double)(center.f_82480_ - (double)radius)), (int)Mth.m_14107_((double)(center.f_82481_ - (double)radius)), (int)Mth.m_14107_((double)(center.f_82479_ + (double)radius)), (int)Mth.m_14107_((double)(center.f_82480_ + (double)radius)), (int)Mth.m_14107_((double)(center.f_82481_ + (double)radius)))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            boolean nuke = blockstate.m_60713_((Block)ACBlockRegistry.NUCLEAR_BOMB.get());
            if (blockstate.m_204336_(ACTagRegistry.NUKE_PROOF) || !blockstate.m_280555_() || !(blockstate.m_60734_().m_7325_() <= 15.0f) && !nuke || !square && !(blockpos.m_203198_(center.f_82479_, center.f_82480_, center.f_82481_) < (double)(radius * radius))) continue;
            if (this.f_19796_.m_188501_() <= dropChance && !nuke) {
                this.m_9236_().m_46961_(blockpos, true);
            } else {
                blockstate.onBlockExploded(this.m_9236_(), blockpos, this.dummyExplosion);
            }
            if (triggerExplosions && nuke) {
                NuclearBombEntity bomb = (NuclearBombEntity)((EntityType)ACEntityRegistry.NUCLEAR_BOMB.get()).m_20615_(this.m_9236_());
                bomb.m_6034_((double)blockpos.m_123341_() + 0.5, blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5);
                bomb.setTime(300);
                this.m_9236_().m_7967_((Entity)bomb);
            }
            flag = true;
        }
        return flag;
    }

    public boolean breakBlocksInBoundingBox(float dropChance) {
        if (this.m_6162_() || !ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) || this.m_9236_().f_46443_) {
            return false;
        }
        boolean flag = false;
        AABB boundingBox = this.m_20191_().m_82400_(2.0);
        int swimUp = this.isTremorzillaSwimming() ? 3 : 1 - (int)this.getLegSolverBodyOffset();
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)boundingBox.f_82288_), (int)Mth.m_14107_((double)(boundingBox.f_82289_ + (double)swimUp)), (int)Mth.m_14107_((double)boundingBox.f_82290_), (int)Mth.m_14107_((double)boundingBox.f_82291_), (int)Mth.m_14107_((double)boundingBox.f_82292_), (int)Mth.m_14107_((double)boundingBox.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60795_() || blockstate.m_204336_(ACTagRegistry.NUKE_PROOF) || blockstate.m_60795_() || !blockstate.m_204336_(BlockTags.f_13035_) && blockpos.m_123342_() <= this.m_146904_() || !(blockstate.m_60734_().m_7325_() <= 15.0f) || !blockstate.m_60713_(Blocks.f_50033_) && blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos).m_83281_()) continue;
            if (this.f_19796_.m_188501_() <= dropChance) {
                this.m_9236_().m_46961_(blockpos, true);
            } else {
                this.m_9236_().m_46597_(blockpos, Blocks.f_50016_.m_49966_());
            }
            flag = true;
        }
        return flag;
    }

    public void tryRoar() {
        if (!(this.roarCooldown != 0 || this.getAnimation() != NO_ANIMATION || this.isFiring() || this.isStunned() || this.m_6162_())) {
            this.setAnimation(this.f_19796_.m_188499_() ? ANIMATION_ROAR_2 : ANIMATION_ROAR_1);
            this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_ROAR.get(), 8.0f, 1.0f);
            this.roarCooldown = 300 + this.f_19796_.m_188503_(400);
        }
    }

    public int m_8085_() {
        return 60;
    }

    private float wrapTailDegrees(float f) {
        return f % 360.0f;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    private void scareMobs() {
        if (this.f_19797_ - this.lastScareTimestamp > 5) {
            this.lastScareTimestamp = this.f_19797_;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(64.0, 20.0, 64.0));
        for (LivingEntity e : list) {
            PathfinderMob mob;
            if (e.m_6095_().m_204039_(ACTagRegistry.RESISTS_TREMORSAURUS_ROAR) || this.m_7307_((Entity)e)) continue;
            if (!(!(e instanceof PathfinderMob) || (mob = (PathfinderMob)e) instanceof TamableAnimal && ((TamableAnimal)mob).m_21825_())) {
                Vec3 vec;
                mob.m_6710_(null);
                mob.m_6703_(null);
                if (mob.m_20096_()) {
                    Vec3 randomShake = new Vec3((double)(this.f_19796_.m_188501_() - 0.5f), 0.0, (double)(this.f_19796_.m_188501_() - 0.5f)).m_82490_((double)0.1f);
                    mob.m_20256_(mob.m_20184_().m_82542_((double)0.7f, 1.0, (double)0.7f).m_82549_(randomShake));
                }
                if (this.lastScareTimestamp == this.f_19797_) {
                    mob.m_21573_().m_26573_();
                }
                if (mob.m_21573_().m_26571_() && (vec = LandRandomPos.m_148521_((PathfinderMob)mob, (int)30, (int)7, (Vec3)this.m_20182_())) != null) {
                    mob.m_21573_().m_26519_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 2.0);
                }
            }
            if (!this.m_21824_()) continue;
            e.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 0, true, true));
        }
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        if (this.m_6162_()) {
            return 0.0f;
        }
        return this.prevScreenShakeAmount + (this.screenShakeAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 64.0;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7334_(Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.m_20365_(entity) && !entity.f_19794_ && !this.f_19794_ && (d2 = Mth.m_14005_((double)(d0 = entity.m_20185_() - this.m_20185_()), (double)(d1 = entity.m_20189_() - this.m_20189_()))) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!entity.m_20160_() && (entity.m_6094_() || entity instanceof KaijuMob)) {
                entity.m_5997_(d0, 0.0, d1);
            }
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public float getYawFromBuffer(int pointer, float partialTick) {
        int i = this.yawPointer - pointer & 0x7F;
        int j = this.yawPointer - pointer - 1 & 0x7F;
        float d0 = this.yawBuffer[j];
        float d1 = this.yawBuffer[i] - d0;
        return d0 + d1 * partialTick;
    }

    @Override
    public BlockState createEggBlockState() {
        return ((Block)ACBlockRegistry.TREMORZILLA_EGG.get()).m_49966_();
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)ACEntityRegistry.TREMORZILLA.get()).m_20615_((Level)serverLevel);
    }

    public static float calculateSpikesDownAmount(float progress, float spikeCount) {
        float scaledTo = progress * spikeCount;
        float remains = scaledTo % 1.0f;
        return (float)Mth.m_14143_((float)scaledTo) + (float)Math.pow(remains, 5.0);
    }

    public static float calculateSpikesDownAmountAtIndex(float progress, float spikeCount, float spikeIndex) {
        return Mth.m_14036_((float)(TremorzillaEntity.calculateSpikesDownAmount(progress, spikeCount) - spikeIndex), (float)0.0f, (float)1.0f);
    }

    @Override
    public void onKeyPacket(Entity keyPresser, int type) {
        if (keyPresser.m_20365_((Entity)this)) {
            if (type == 2 && this.getMeterAmount() >= 1.0f && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == null) && !this.wantsToUseBeamFromServer) {
                this.f_20883_ = keyPresser.m_6080_();
                this.m_146922_(keyPresser.m_6080_());
                this.wantsToUseBeamFromServer = true;
                this.maxBeamTime = 200;
            }
            if (type == 3 && (this.getAnimation() == NO_ANIMATION || this.getAnimation() == null)) {
                this.m_5616_(keyPresser.m_6080_());
                this.m_146926_(keyPresser.m_146909_());
                float decision = this.m_217043_().m_188501_();
                if (decision < 0.33f) {
                    this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_LEFT_SCRATCH : ANIMATION_RIGHT_SCRATCH);
                } else if (decision < 0.66f && !this.m_6069_()) {
                    this.setAnimation(this.m_217043_().m_188499_() ? ANIMATION_LEFT_STOMP : ANIMATION_RIGHT_STOMP);
                } else {
                    this.setAnimation(ANIMATION_BITE);
                }
            }
        }
    }

    @Override
    public float maxSitTicks() {
        return 20.0f;
    }

    private Stream<BlockPos> getNearbySirens(ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.NUCLEAR_SIREN.getKey()), (Predicate)Predicates.alwaysTrue(), this.m_20183_(), range, PoiManager.Occupancy.ANY);
    }

    private void activateSiren(BlockPos pos) {
        BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
        if (blockEntity instanceof NuclearSirenBlockEntity) {
            NuclearSirenBlockEntity nuclearSirenBlock = (NuclearSirenBlockEntity)blockEntity;
            nuclearSirenBlock.setNearestNuclearBomb((Entity)this);
        }
    }

    @Override
    public boolean shouldStopBlaringSirens() {
        return !this.isPowered() || this.getSpikesDownAmount() <= 0.0f || this.m_213877_();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult prev = super.m_6071_(player, hand);
        if (prev != InteractionResult.SUCCESS) {
            ItemStack itemStack = player.m_21120_(hand);
            if (!this.m_21824_() && itemStack.m_150930_(((Block)ACBlockRegistry.WASTE_DRUM.get()).m_5456_()) && this.getAnimation() == NO_ANIMATION) {
                this.m_142075_(player, hand, itemStack);
                this.setAnimation(ANIMATION_CHEW);
                this.lastFedPlayer = player;
                return InteractionResult.SUCCESS;
            }
        }
        return prev;
    }

    @Override
    public boolean canOwnerMount(Player player) {
        return !this.m_6162_();
    }

    @Override
    public boolean canOwnerCommand(Player ownerPlayer) {
        return ownerPlayer.m_6144_();
    }

    public Vec3 m_7688_(LivingEntity living) {
        return new Vec3(this.m_20185_(), this.m_20191_().f_82289_, this.m_20189_());
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        this.m_6710_(null);
        if ((player.f_20902_ != 0.0f || player.f_20900_ != 0.0f) && this.getAnimation() != ANIMATION_LEFT_TAIL && this.getAnimation() != ANIMATION_RIGHT_TAIL) {
            this.m_19915_(player.m_146908_(), player.m_146909_() * 0.25f);
            this.m_5616_(player.m_6080_());
        }
    }

    protected float m_245547_(Player rider) {
        return (float)this.m_21133_(Attributes.f_22279_);
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public void setTameAttempts(int i) {
        this.f_19804_.m_135381_(TAME_ATTEMPTS, (Object)i);
    }

    public int getTameAttempts() {
        return (Integer)this.f_19804_.m_135370_(TAME_ATTEMPTS);
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    protected float m_6041_() {
        return this.isTremorzillaSwimming() || this.m_6046_() ? 1.0f : super.m_6041_();
    }

    protected float m_6108_() {
        return 0.98f;
    }

    protected Vec3 m_274312_(Player player, Vec3 deltaIn) {
        float f;
        float f2 = f = player.f_20902_ < 0.0f ? 0.5f : 1.0f;
        if (this.isInFluidType()) {
            Vec3 lookVec = player.m_20154_();
            float y = (float)lookVec.f_82480_;
            return new Vec3((double)(player.f_20900_ * 0.25f), (double)y, (double)(player.f_20902_ * 0.8f * f));
        }
        return new Vec3((double)(player.f_20900_ * 0.35f), 0.0, (double)(player.f_20902_ * 0.8f * f));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20365_(passenger) && passenger instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)passenger;
            if (!this.m_146899_()) {
                float swimAmount = this.m_20998_(1.0f);
                float walkSwing = (float)(Math.cos(this.f_267362_.m_267756_() * 0.25f + 1.0f) * 0.75 * (double)this.f_267362_.m_267731_() - (double)(1.5f * this.f_267362_.m_267731_())) * (1.0f - swimAmount);
                float animationExtraBack = 0.0f;
                if (this.getAnimation() == ANIMATION_ROAR_2) {
                    animationExtraBack = 4.0f * ACMath.cullAnimationTick(this.getAnimationTick(), 1.0f, this.getAnimation(), 1.0f, 10, 60);
                }
                if (this.getAnimation() == ANIMATION_PREPARE_BREATH) {
                    animationExtraBack = 4.0f * ACMath.cullAnimationTick(this.getAnimationTick(), 1.0f, this.getAnimation(), 1.0f, 0, 20);
                }
                Vec3 seatOffset = new Vec3(0.0, 2.0 - 6.5 * (double)swimAmount, (double)(1.0f + 6.0f * swimAmount - walkSwing - animationExtraBack)).m_82524_((float)Math.toRadians(-this.f_20883_));
                passenger.m_5618_(this.f_20883_);
                passenger.f_19789_ = 0.0f;
                if (!this.isFiring()) {
                    this.clampRotation(living, 105.0f);
                }
                float heightBackLeft = this.legSolver.legs[0].getHeight(1.0f);
                float heightBackRight = this.legSolver.legs[1].getHeight(1.0f);
                float maxLegSolverHeight = (1.0f - ACMath.smin(1.0f - heightBackLeft, 1.0f - heightBackRight, 0.1f)) * 0.8f * (1.0f - swimAmount);
                moveFunction.m_20372_(passenger, this.m_20185_() + seatOffset.f_82479_, this.m_20186_() + seatOffset.f_82480_ + this.m_6048_() - (double)maxLegSolverHeight, this.m_20189_() + seatOffset.f_82481_);
                return;
            }
        }
        super.m_19956_(passenger, moveFunction);
    }

    public double m_6048_() {
        return 8.25 * (double)this.m_6134_();
    }

    public boolean m_6783_(double distance) {
        return Math.sqrt(distance) < 1024.0;
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(6.0);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ACSoundRegistry.TREMORZILLA_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.TREMORZILLA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.TREMORZILLA_DEATH.get();
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPEAK, ANIMATION_ROAR_1, ANIMATION_ROAR_2, ANIMATION_RIGHT_SCRATCH, ANIMATION_LEFT_SCRATCH, ANIMATION_RIGHT_TAIL, ANIMATION_LEFT_TAIL, ANIMATION_RIGHT_STOMP, ANIMATION_LEFT_STOMP, ANIMATION_BITE, ANIMATION_PREPARE_BREATH, ANIMATION_CHEW};
    }

    public boolean m_6067_() {
        return this.isTremorzillaSwimming();
    }

    public boolean m_6063_() {
        return false;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.isTremorzillaSwimming() ? SWIMMING_SIZE.m_20388_(this.m_6134_()) : super.m_6972_(poseIn);
    }

    public boolean isTremorzillaSwimming() {
        return (Boolean)this.f_19804_.m_135370_(SWIMMING);
    }

    public void setTremorzillaSwimming(boolean bool) {
        this.f_19804_.m_135381_(SWIMMING, (Object)bool);
    }

    public float getSpikesDownAmount() {
        return ((Float)this.f_19804_.m_135370_(SPIKES_DOWN_PROGRESS)).floatValue();
    }

    public void setSpikesDownAmount(float spikesDownProgress) {
        this.f_19804_.m_135381_(SPIKES_DOWN_PROGRESS, (Object)Float.valueOf(spikesDownProgress));
    }

    public float getClientSpikeDownAmount(float partialTicks) {
        return this.prevClientSpikesDownAmount + (this.clientSpikesDownAmount - this.prevClientSpikesDownAmount) * partialTicks;
    }

    public boolean isFiring() {
        return (Boolean)this.f_19804_.m_135370_(FIRING);
    }

    public void setFiring(boolean firing) {
        this.f_19804_.m_135381_(FIRING, (Object)firing);
    }

    public float getBeamProgress(float partialTicks) {
        return (this.prevBeamProgress + (this.beamProgress - this.prevBeamProgress) * partialTicks) * 0.2f;
    }

    public int getCharge() {
        return (Integer)this.f_19804_.m_135370_(CHARGE);
    }

    public void setCharge(int charge) {
        this.f_19804_.m_135381_(CHARGE, (Object)charge);
    }

    public boolean isPowered() {
        return this.getCharge() >= 1000;
    }

    @Nullable
    public Vec3 getBeamEndPosition() {
        return ((Optional)this.f_19804_.m_135370_(BEAM_END_POSITION)).orElse(null);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            amount *= 0.35f;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean hasRidingMeter() {
        return true;
    }

    @Override
    public float getMeterAmount() {
        return (float)this.getCharge() / 1000.0f;
    }

    public void setBeamEndPosition(@Nullable Vec3 vec3) {
        this.f_19804_.m_135381_(BEAM_END_POSITION, Optional.ofNullable(vec3));
    }

    @Nullable
    public Vec3 getClientBeamEndPosition(float partialTicks) {
        if (this.clientBeamEndPosition != null && this.prevClientBeamEndPosition != null) {
            return this.prevClientBeamEndPosition.m_82549_(this.clientBeamEndPosition.m_82546_(this.prevClientBeamEndPosition).m_82490_((double)partialTicks));
        }
        return null;
    }

    public int m_213860_() {
        return 70;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(((Block)ACBlockRegistry.NUCLEAR_BOMB.get()).m_5456_());
    }

    public Vec3 getBodyRotViewVector(float partialTicks) {
        return this.m_20171_(this.m_5686_(partialTicks), this.f_20884_ + (this.f_20883_ - this.f_20884_) * partialTicks);
    }

    public void setMaxBeamBreakLength(float f) {
        this.f_19804_.m_135381_(MAX_BEAM_BREAK_LENGTH, (Object)Float.valueOf(f));
    }

    public double getMaxBeamBreakLength() {
        return ((Float)this.f_19804_.m_135370_(MAX_BEAM_BREAK_LENGTH)).floatValue();
    }

    public float getStepHeight() {
        return 1.6f;
    }

    public Vec3 getBeamShootFrom(float partialTicks) {
        return this.m_20318_(partialTicks).m_82520_(0.0, (double)(7.5f * this.m_6134_()), 0.0);
    }

    public int getMaxNavigableDistanceToGround() {
        return 4;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.15f : 1.0f;
    }

    @Override
    public BlockState createEggBeddingBlockState() {
        return ((Block)ACBlockRegistry.UNREFINED_WASTE.get()).m_49966_();
    }
}

