/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.PackAnimal;
import com.github.alexmodguy.alexscaves.server.entity.util.UnderzealotSacrifice;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class UnderzealotSacrificeGoal
extends Goal {
    private UnderzealotEntity entity;
    private int executionCooldown = 10;
    private int attemptToFollowTicks = 0;
    private BlockPos center;

    public UnderzealotSacrificeGoal(UnderzealotEntity entity) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = entity;
    }

    public boolean m_8036_() {
        if (this.entity.sacrificeCooldown > 0) {
            return false;
        }
        if (this.entity.isPackFollower()) {
            UnderzealotEntity leader = (UnderzealotEntity)this.entity.getPackLeader();
            if (leader.isCarrying() && leader.getLastSacrificePos() != null && leader.m_20238_(Vec3.m_82512_((Vec3i)leader.getLastSacrificePos())) < 2.5) {
                this.center = leader.getLastSacrificePos();
                return true;
            }
        } else if (this.entity.isCarrying()) {
            if (this.executionCooldown-- > 0) {
                return false;
            }
            this.executionCooldown = 20 + this.entity.m_217043_().m_188503_(100);
            BlockPos pos = null;
            if (this.entity.getLastSacrificePos() != null) {
                if (this.isValidSacrificePos(this.entity.getLastSacrificePos())) {
                    this.executionCooldown = 10;
                    pos = this.entity.getLastSacrificePos();
                } else {
                    this.entity.setLastSacrificePos(null);
                }
            }
            if (pos == null) {
                pos = this.findNearestSacrificePos();
            }
            if (pos != null) {
                this.center = pos;
                this.entity.setLastSacrificePos(this.center);
                return true;
            }
        }
        return false;
    }

    private BlockPos findNearestSacrificePos() {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        check.m_122193_((Vec3i)this.entity.m_20183_());
        check.m_122184_(0, -1, 0);
        if (this.isValidSacrificePos((BlockPos)check)) {
            return check.m_7949_();
        }
        for (int i = 0; i < 20; ++i) {
            check.m_122193_((Vec3i)this.entity.m_20183_());
            check.m_122184_(this.entity.m_217043_().m_188503_(20) - 10, 5, this.entity.m_217043_().m_188503_(20) - 10);
            if (!this.entity.m_9236_().m_46749_((BlockPos)check)) continue;
            while (this.entity.m_9236_().m_46859_((BlockPos)check) && check.m_123342_() > this.entity.m_9236_().m_141937_()) {
                check.m_122184_(0, -1, 0);
            }
            if (!this.isValidSacrificePos((BlockPos)check) || !this.canReach((BlockPos)check)) continue;
            return check.m_7949_();
        }
        return null;
    }

    public boolean canReach(BlockPos target) {
        int k;
        int j;
        Path path = this.entity.m_21573_().m_7864_(target, 0);
        if (path == null) {
            return false;
        }
        Node node = path.m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - target.m_123341_();
        return (double)(i * i + (j = node.f_77272_ - target.m_123342_()) * j + (k = node.f_77273_ - target.m_123343_()) * k) <= 3.0;
    }

    private boolean isValidSacrificePos(BlockPos pos) {
        if (this.entity.m_9236_().m_46859_(pos)) {
            return false;
        }
        BlockPos.MutableBlockPos aboveGround = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos below = new BlockPos.MutableBlockPos();
        int badSpots = 0;
        for (int i = -2; i <= -2; ++i) {
            for (int j = -2; j <= -2; ++j) {
                aboveGround.m_122178_(pos.m_123341_() + i, pos.m_123342_() + 1, pos.m_123343_() + j);
                below.m_122178_(pos.m_123341_() + i, pos.m_123342_(), pos.m_123343_() + j);
                if (this.entity.m_9236_().m_46859_((BlockPos)below)) {
                    ++badSpots;
                }
                if (badSpots <= 5) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_8045_() {
        if (this.center == null) {
            return false;
        }
        if (this.entity.sacrificeCooldown > 0) {
            return false;
        }
        if (this.entity.isPackFollower()) {
            UnderzealotEntity leader = (UnderzealotEntity)this.entity.getPackLeader();
            return leader != null && leader.isCarrying() && leader.m_20238_(Vec3.m_82512_((Vec3i)this.center)) < 5.0;
        }
        return this.entity.isCarrying();
    }

    public void m_8037_() {
        if (this.entity.isDiggingInProgress() || this.entity.isBuried()) {
            this.entity.setPraying(false);
            return;
        }
        if (this.center != null) {
            int worshippingTicks = this.entity.getWorshipTime();
            if (this.entity.isPackFollower()) {
                UnderzealotEntity leader = (UnderzealotEntity)this.entity.getPackLeader();
                float f = (float)this.getPackPosition() / ((float)this.entity.getPackSize() - 1.0f);
                Vec3 offset = new Vec3(2.0, 0.0, 0.0).m_82524_(f * ((float)Math.PI * 2));
                Vec3 at = this.groundOf(Vec3.m_82512_((Vec3i)this.center).m_82549_(offset));
                this.entity.m_21573_().m_26519_(at.f_82479_, at.f_82480_, at.f_82481_, 1.0);
                if (this.entity.isPraying()) {
                    this.attemptToFollowTicks = 0;
                } else if ((this.entity.m_21573_().m_26577_() || this.attemptToFollowTicks > 60) && this.entity.m_20238_(at) > 8.0) {
                    this.entity.setBuried(true);
                    this.entity.reemergeAt(BlockPos.m_274446_((Position)at).m_7494_(), 20 + this.entity.m_217043_().m_188503_(20));
                }
                if (leader != null && leader.sacrificeCooldown > 0) {
                    this.entity.sacrificeCooldown = leader.sacrificeCooldown;
                }
                if (leader != null && this.entity.m_20238_(at) < 4.0) {
                    this.entity.setPraying(true);
                    Vec3 slightOffset = at.m_82546_(this.entity.m_20182_());
                    if (slightOffset.m_82553_() > 1.0) {
                        slightOffset = slightOffset.m_82541_();
                    }
                    this.entity.m_20256_(this.entity.m_20184_().m_82549_(slightOffset.m_82490_((double)0.04f)));
                    this.entity.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)this.center));
                    this.entity.setParticlePos(leader.getLastSacrificePos().m_6630_(5));
                    this.entity.m_9236_().m_7605_((Entity)this.entity, (byte)77);
                    if (worshippingTicks % 10 == 0) {
                        this.entity.m_9236_().m_7605_((Entity)this.entity, (byte)61);
                    }
                    this.entity.setWorshipTime(worshippingTicks + 1);
                } else {
                    this.entity.setWorshipTime(0);
                    ++this.attemptToFollowTicks;
                }
            } else {
                this.entity.setParticlePos(this.center.m_6630_(5));
                Vec3 at = Vec3.m_82512_((Vec3i)this.center);
                if (this.entity.m_20238_(at) < 4.0) {
                    Entity entity;
                    Vec3 slightOffset = at.m_82546_(this.entity.m_20182_());
                    if (slightOffset.m_82553_() > 1.0) {
                        slightOffset = slightOffset.m_82541_();
                    }
                    this.entity.setWorshipTime(worshippingTicks + 1);
                    this.entity.m_20256_(this.entity.m_20184_().m_82549_(slightOffset.m_82490_((double)0.04f)));
                    if (worshippingTicks > 200 && this.entity.cloudCooldown <= 0 && this.entity.isSurroundedByPrayers() && (entity = this.entity.m_146895_()) instanceof UnderzealotSacrifice) {
                        UnderzealotSacrifice underzealotSacrifice = (UnderzealotSacrifice)entity;
                        underzealotSacrifice.triggerSacrificeIn(300);
                        this.entity.cloudCooldown = 400;
                        this.entity.m_9236_().m_7605_((Entity)this.entity, (byte)62);
                    }
                } else {
                    this.entity.setWorshipTime(0);
                }
                this.entity.m_21573_().m_26519_((double)this.center.m_123341_(), (double)this.center.m_123342_(), (double)this.center.m_123343_(), 1.0);
            }
        }
    }

    private Vec3 groundOf(Vec3 in) {
        BlockPos origin = BlockPos.m_274446_((Position)in);
        BlockPos.MutableBlockPos blockPos = origin.m_122032_();
        while (!this.entity.m_9236_().m_46859_((BlockPos)blockPos) && blockPos.m_123342_() < this.entity.m_9236_().m_151558_()) {
            blockPos.m_122184_(0, 1, 0);
        }
        while (this.entity.m_9236_().m_46859_(blockPos.m_7495_()) && blockPos.m_123342_() > this.entity.m_9236_().m_141937_()) {
            blockPos.m_122184_(0, -1, 0);
        }
        return new Vec3(in.f_82479_, (double)blockPos.m_123342_(), in.f_82481_);
    }

    private int getPackPosition() {
        PackAnimal leader = this.entity.getPackLeader();
        int i = 1;
        while (leader.getAfterPackMember() != null) {
            if (leader.getAfterPackMember() == this.entity) {
                return i;
            }
            leader = leader.getAfterPackMember();
            ++i;
        }
        return i;
    }

    public void m_8041_() {
        this.attemptToFollowTicks = 0;
        this.entity.setWorshipTime(0);
        if (this.entity.sacrificeCooldown == 0) {
            this.entity.sacrificeCooldown = 100;
        }
        this.entity.m_21573_().m_26573_();
        this.entity.m_20153_();
        this.entity.setPraying(false);
        this.entity.setParticlePos(null);
    }
}

