/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.CakeCaveStructurePiece;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.GingerbreadRoadPiece;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public class MobWanderThroughStructureGoal
extends RandomStrollGoal {
    private final TagKey<Structure> structureTagKey;
    private final double maximumDistance;
    private final double maximumYDistance;
    private int errorCooldown = 0;

    public MobWanderThroughStructureGoal(PathfinderMob mob, double speed, int chance, TagKey<Structure> structureTagKey, double maximumDistance, double maximumYDistance) {
        super(mob, speed, chance, false);
        this.structureTagKey = structureTagKey;
        this.maximumDistance = maximumDistance;
        this.maximumYDistance = maximumYDistance;
    }

    public boolean m_8036_() {
        if (this.errorCooldown > 0) {
            --this.errorCooldown;
        }
        return super.m_8036_();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.errorCooldown > 0) {
            --this.errorCooldown;
        }
    }

    @Nullable
    protected Vec3 m_7037_() {
        StructureStart start = this.getNearestStructure(this.f_25725_.m_20183_());
        if (start != null && start.m_73603_() || this.errorCooldown > 0) {
            ArrayList<BlockPos> validPieceCenters = new ArrayList<BlockPos>();
            for (StructurePiece piece : start.m_73602_()) {
                BoundingBox boundingbox = piece.m_73547_();
                BlockPos blockpos = boundingbox.m_162394_().m_175288_(boundingbox.m_162396_() + 1);
                if (piece instanceof GingerbreadRoadPiece) {
                    GingerbreadRoadPiece gingerbreadRoadPiece = (GingerbreadRoadPiece)piece;
                    BlockPos roadEnd = gingerbreadRoadPiece.getRoadEndPos();
                    blockpos = blockpos.m_175288_((int)CakeCaveStructurePiece.calculatePlateauHeight(roadEnd.m_123341_(), roadEnd.m_123343_(), 7, true));
                }
                double yDist = Math.abs(blockpos.m_123342_() - this.f_25725_.m_20183_().m_123342_());
                if (!(this.f_25725_.m_20238_(Vec3.m_82512_((Vec3i)blockpos)) <= this.maximumDistance * this.maximumDistance) || !(yDist < this.maximumYDistance)) continue;
                validPieceCenters.add(blockpos);
            }
            if (!validPieceCenters.isEmpty()) {
                BlockPos randomCenter;
                BlockPos blockPos = randomCenter = validPieceCenters.size() > 1 ? (BlockPos)validPieceCenters.get(this.f_25725_.m_217043_().m_188503_(validPieceCenters.size() - 1)) : (BlockPos)validPieceCenters.get(0);
                while (this.f_25725_.m_9236_().m_8055_(randomCenter).m_60795_() && randomCenter.m_123342_() > this.f_25725_.m_9236_().m_141937_()) {
                    randomCenter = randomCenter.m_7495_();
                }
                while (!this.f_25725_.m_9236_().m_8055_(randomCenter).m_60795_() && randomCenter.m_123342_() < this.f_25725_.m_9236_().m_151558_()) {
                    randomCenter = randomCenter.m_7494_();
                }
                return Vec3.m_82512_((Vec3i)randomCenter.m_7918_(this.f_25725_.m_217043_().m_188503_(2) - 1, 0, this.f_25725_.m_217043_().m_188503_(2) - 1));
            }
        }
        return null;
    }

    @Nullable
    private StructureStart getNearestStructure(BlockPos pos) {
        ServerLevel serverlevel = (ServerLevel)this.f_25725_.m_9236_();
        try {
            StructureStart start = serverlevel.m_215010_().m_220491_(pos, this.structureTagKey);
            if (start.m_73603_()) {
                return start;
            }
            BlockPos nearestOf = serverlevel.m_215011_(this.structureTagKey, pos, (int)(this.maximumDistance / 16.0), false);
            if (nearestOf == null || nearestOf.m_203198_(this.f_25725_.m_20185_(), this.f_25725_.m_20186_(), this.f_25725_.m_20189_()) > 256.0 || !serverlevel.m_46749_(nearestOf)) {
                return null;
            }
            return serverlevel.m_215010_().m_220491_(nearestOf, this.structureTagKey);
        }
        catch (Exception e) {
            AlexsCaves.LOGGER.warn(this.f_25725_ + " encountered an issue searching for a nearby structure.");
            this.errorCooldown = 2000 + this.f_25725_.m_217043_().m_188503_(2000);
            return null;
        }
    }
}

