/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.RegistryObject;

public class DinosaurEggBlock
extends Block {
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;
    public static final BooleanProperty NEEDS_PLAYER = BooleanProperty.m_61465_((String)"needs_player");
    private final VoxelShape voxelShape;
    private final RegistryObject<EntityType> births;

    public DinosaurEggBlock(BlockBehaviour.Properties properties, RegistryObject births, VoxelShape voxelShape) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)NEEDS_PLAYER, (Comparable)Boolean.valueOf(false)));
        this.births = births;
        this.voxelShape = voxelShape;
    }

    public DinosaurEggBlock(BlockBehaviour.Properties properties, RegistryObject births, int widthPx, int heightPx) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0))).m_61124_((Property)NEEDS_PLAYER, (Comparable)Boolean.valueOf(false)));
        this.births = births;
        int px = (16 - widthPx) / 2;
        this.voxelShape = Block.m_49796_((double)px, (double)0.0, (double)px, (double)(16 - px), (double)heightPx, (double)(16 - px));
    }

    public boolean isProperHabitat(BlockGetter reader, BlockPos pos) {
        BlockState state = reader.m_8055_(pos.m_7495_());
        return state.m_280296_() && !state.m_204336_(ACTagRegistry.STOPS_DINOSAUR_EGGS);
    }

    public boolean canHatchAt(BlockGetter reader, BlockPos pos) {
        return this.isProperHabitat(reader, pos);
    }

    public void m_141947_(Level worldIn, BlockPos pos, BlockState state, Entity entityIn) {
        this.tryTrample(worldIn, pos, entityIn, 100);
        super.m_141947_(worldIn, pos, state, entityIn);
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        if (!(entityIn instanceof Zombie)) {
            this.tryTrample(worldIn, pos, entityIn, 3);
        }
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.voxelShape;
    }

    private void tryTrample(Level worldIn, BlockPos pos, Entity trampler, int chances) {
        if (this.canTrample(worldIn, trampler) && !worldIn.f_46443_ && worldIn.f_46441_.m_188503_(chances) == 0) {
            Player player;
            AABB bb = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_82377_(25.0, 25.0, 25.0);
            if (!(!(trampler instanceof LivingEntity) || trampler instanceof Player && (player = (Player)trampler).m_7500_())) {
                List list = worldIn.m_6443_(Mob.class, bb, living -> living.m_6084_() && living.m_6095_() == this.births.get());
                for (Mob living2 : list) {
                    if (living2 instanceof TamableAnimal && ((TamableAnimal)living2).m_21824_() && ((TamableAnimal)living2).m_21830_((LivingEntity)trampler)) continue;
                    living2.m_6710_((LivingEntity)trampler);
                }
            }
            BlockState blockstate = worldIn.m_8055_(pos);
            this.removeOneEgg(worldIn, pos, blockstate);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        return context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).m_193113_() instanceof DinosaurEntity ? Shapes.m_83040_() : super.m_5939_(state, level, blockPos, context);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (this.canGrow((Level)worldIn, worldIn.m_8055_(pos.m_7495_())) && this.canHatchAt((BlockGetter)worldIn, pos) && (!((Boolean)state.m_61143_((Property)NEEDS_PLAYER)).booleanValue() || worldIn.m_5788_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 15.0, EntitySelector.f_20408_) != null)) {
            int i = (Integer)state.m_61143_((Property)HATCH);
            if (i < 2) {
                worldIn.m_5594_(null, pos, SoundEvents.f_12534_, SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                worldIn.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                this.spawnDinosaurs((Level)worldIn, pos, state);
            }
        }
    }

    public void spawnDinosaurs(Level level, BlockPos pos, BlockState state) {
        level.m_5594_(null, pos, SoundEvents.f_12535_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
        level.m_7471_(pos, false);
        for (int j = 0; j < this.getDinosaursBornFrom(state); ++j) {
            DinosaurEntity dinosaur;
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            Entity fromType = ((EntityType)this.births.get()).m_20615_(level);
            if (fromType instanceof Animal) {
                Animal animal = (Animal)fromType;
                animal.m_146762_(-24000);
            }
            fromType.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
            if (level.f_46443_) continue;
            Player closest = level.m_5788_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), 10.0, EntitySelector.f_20408_);
            if (closest != null && fromType instanceof DinosaurEntity && (dinosaur = (DinosaurEntity)fromType).tamesFromHatching()) {
                dinosaur.m_7105_(true);
                dinosaur.m_21839_(true);
                dinosaur.m_21828_(closest);
            }
            level.m_7967_(fromType);
        }
    }

    protected boolean canGrow(Level worldIn, BlockState stateBelow) {
        return worldIn.f_46441_.m_188503_(stateBelow.m_60713_((Block)ACBlockRegistry.FERN_THATCH.get()) ? 10 : 20) == 0;
    }

    protected int getDinosaursBornFrom(BlockState state) {
        return 1;
    }

    protected void removeOneEgg(Level worldIn, BlockPos pos, BlockState state) {
        worldIn.m_5594_(null, pos, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + worldIn.f_46441_.m_188501_() * 0.2f);
        worldIn.m_46961_(pos, false);
    }

    private boolean canTrample(Level worldIn, Entity trampler) {
        if (!trampler.m_6095_().m_204039_(ACTagRegistry.DINOSAURS)) {
            if (!(trampler instanceof LivingEntity)) {
                return false;
            }
            return trampler instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)trampler);
        }
        return false;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.canHatchAt((BlockGetter)worldIn, pos) && !worldIn.f_46443_) {
            worldIn.m_46796_(2005, pos, 0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HATCH, NEEDS_PLAYER});
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, state, te, stack);
        this.removeOneEgg(worldIn, pos, state);
    }
}

