/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.item.DinosaurSpiritEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GrottoceratopsEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.animation.LegSolverQuadruped;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.util.Mth;

public class GrottoceratopsModel
extends AdvancedEntityModel<GrottoceratopsEntity> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox bodySpikes;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox rleg2;
    private final AdvancedModelBox rfoot;
    private final AdvancedModelBox lleg;
    private final AdvancedModelBox lleg2;
    private final AdvancedModelBox lfoot;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox tailSpike;
    private final AdvancedModelBox tail2;
    private final AdvancedModelBox tail2Spike;
    private final AdvancedModelBox neck;
    private final AdvancedModelBox head;
    private final AdvancedModelBox jaw;
    private final AdvancedModelBox grassBunch;
    private final AdvancedModelBox grass;
    private final AdvancedModelBox grass2;
    private final AdvancedModelBox grassBunch2;
    private final AdvancedModelBox grass3;
    private final AdvancedModelBox grass4;
    private final AdvancedModelBox grass5;
    private final AdvancedModelBox grass6;
    private final ModelAnimator animator;

    public GrottoceratopsModel() {
        this.texWidth = 256;
        this.texHeight = 256;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, -3.0f, 0.0f);
        this.body.setTextureOffset(0, 0).addBox(-11.0f, -14.0f, -17.5f, 22.0f, 30.0f, 35.0f, 0.0f, false);
        this.bodySpikes = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bodySpikes.setRotationPoint(0.0f, -2.5f, 0.0f);
        this.body.addChild((BasicModelPart)this.bodySpikes);
        this.bodySpikes.setTextureOffset(0, 22).addBox(0.0f, -15.5f, -21.5f, 0.0f, 31.0f, 43.0f, 0.0f, false);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(-11.0f, 5.0f, 9.5f);
        this.body.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(117, 17).addBox(-5.0f, -2.0f, -8.0f, 9.0f, 15.0f, 12.0f, 0.0f, true);
        this.rleg2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg2.setRotationPoint(-0.5f, 8.5f, 2.0f);
        this.rleg.addChild((BasicModelPart)this.rleg2);
        this.rleg2.setTextureOffset(126, 44).addBox(-3.0f, -1.5f, -4.0f, 6.0f, 13.0f, 8.0f, 0.0f, true);
        this.rfoot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rfoot.setRotationPoint(0.0f, 11.5f, -0.5f);
        this.rleg2.addChild((BasicModelPart)this.rfoot);
        this.rfoot.setTextureOffset(114, 0).addBox(-4.0f, 0.0f, -6.5f, 8.0f, 2.0f, 11.0f, 0.0f, true);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(11.0f, 5.0f, 9.5f);
        this.body.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(117, 17).addBox(-4.0f, -2.0f, -8.0f, 9.0f, 15.0f, 12.0f, 0.0f, false);
        this.lleg2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg2.setRotationPoint(0.5f, 8.5f, 2.0f);
        this.lleg.addChild((BasicModelPart)this.lleg2);
        this.lleg2.setTextureOffset(126, 44).addBox(-3.0f, -1.5f, -4.0f, 6.0f, 13.0f, 8.0f, 0.0f, false);
        this.lfoot = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lfoot.setRotationPoint(0.5f, 20.0f, 1.5f);
        this.lleg.addChild((BasicModelPart)this.lfoot);
        this.lfoot.setTextureOffset(114, 0).addBox(-4.0f, 0.0f, -6.5f, 8.0f, 2.0f, 11.0f, 0.0f, false);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarm.setRotationPoint(-10.0f, 4.0f, -12.0f);
        this.body.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(0, 0).addBox(-4.0f, -2.0f, -4.5f, 6.0f, 25.0f, 9.0f, 0.0f, true);
        this.rarm.setTextureOffset(79, 7).addBox(-1.0f, 17.0f, -7.5f, 3.0f, 3.0f, 3.0f, 0.0f, true);
        this.rarm.setTextureOffset(105, 31).addBox(-1.0f, 20.0f, -7.5f, 3.0f, 2.0f, 2.0f, 0.0f, true);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larm.setRotationPoint(10.0f, 4.0f, -12.0f);
        this.body.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(0, 0).addBox(-2.0f, -2.0f, -4.5f, 6.0f, 25.0f, 9.0f, 0.0f, false);
        this.larm.setTextureOffset(79, 7).addBox(-2.0f, 17.0f, -7.5f, 3.0f, 3.0f, 3.0f, 0.0f, false);
        this.larm.setTextureOffset(105, 31).addBox(-2.0f, 20.0f, -7.5f, 3.0f, 2.0f, 2.0f, 0.0f, false);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, -1.0f, 16.5f);
        this.body.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(65, 75).addBox(-6.0f, -5.0f, -1.0f, 12.0f, 12.0f, 21.0f, 0.0f, false);
        this.tailSpike = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tailSpike.setRotationPoint(0.0f, -5.0f, 10.5f);
        this.tail.addChild((BasicModelPart)this.tailSpike);
        this.tailSpike.setTextureOffset(0, 98).addBox(0.0f, -4.0f, -9.5f, 0.0f, 12.0f, 19.0f, 0.0f, false);
        this.tail2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail2.setRotationPoint(0.0f, 0.0f, 19.0f);
        this.tail.addChild((BasicModelPart)this.tail2);
        this.tail2.setTextureOffset(26, 129).addBox(-10.0f, -3.0f, 14.0f, 7.0f, 3.0f, 3.0f, 0.0f, true);
        this.tail2.setTextureOffset(95, 46).addBox(-3.0f, -3.0f, -1.0f, 6.0f, 7.0f, 19.0f, 0.0f, false);
        this.tail2.setTextureOffset(26, 129).addBox(3.0f, -3.0f, 8.0f, 7.0f, 3.0f, 3.0f, 0.0f, false);
        this.tail2.setTextureOffset(26, 129).addBox(3.0f, -3.0f, 14.0f, 7.0f, 3.0f, 3.0f, 0.0f, false);
        this.tail2.setTextureOffset(26, 129).addBox(-10.0f, -3.0f, 8.0f, 7.0f, 3.0f, 3.0f, 0.0f, true);
        this.tail2Spike = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail2Spike.setRotationPoint(0.0f, -3.0f, 9.5f);
        this.tail2.addChild((BasicModelPart)this.tail2Spike);
        this.tail2Spike.setTextureOffset(131, 83).addBox(0.0f, -4.0f, -8.5f, 0.0f, 8.0f, 17.0f, 0.0f, false);
        this.neck = new AdvancedModelBox((AdvancedEntityModel)this);
        this.neck.setRotationPoint(0.0f, 5.0f, -16.5f);
        this.body.addChild((BasicModelPart)this.neck);
        this.neck.setTextureOffset(100, 129).addBox(-5.0f, -7.0f, -16.0f, 10.0f, 14.0f, 20.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -6.0f, -14.0f);
        this.neck.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(110, 72).addBox(-8.0f, -17.0f, -17.0f, 16.0f, 12.0f, 8.0f, 0.0f, false);
        this.head.setTextureOffset(79, 29).addBox(-4.0f, 10.0f, -17.0f, 8.0f, 2.0f, 4.0f, 0.0f, false);
        this.head.setTextureOffset(46, 108).addBox(-7.0f, -5.0f, -7.0f, 14.0f, 15.0f, 10.0f, 0.0f, false);
        this.head.setTextureOffset(94, 108).addBox(-11.0f, -17.0f, 0.0f, 22.0f, 18.0f, 3.0f, 0.0f, false);
        this.head.setTextureOffset(0, 96).addBox(-14.0f, -20.0f, 0.0f, 28.0f, 21.0f, 0.0f, 0.0f, false);
        this.head.setTextureOffset(79, 0).addBox(-7.0f, -9.0f, -7.0f, 3.0f, 4.0f, 3.0f, 0.0f, false);
        this.head.setTextureOffset(21, 0).addBox(4.0f, -9.0f, -7.0f, 3.0f, 4.0f, 3.0f, 0.0f, false);
        this.head.setTextureOffset(0, 129).addBox(-4.0f, -5.0f, -17.0f, 8.0f, 7.0f, 10.0f, 0.0f, false);
        this.head.setTextureOffset(36, 142).addBox(-4.0f, 2.0f, -17.0f, 8.0f, 8.0f, 4.0f, 0.0f, false);
        this.jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.jaw.setRotationPoint(0.0f, 2.0f, -6.0f);
        this.head.addChild((BasicModelPart)this.jaw);
        this.jaw.setTextureOffset(65, 140).addBox(-4.0f, 0.0f, -7.0f, 8.0f, 8.0f, 6.0f, 0.0f, false);
        this.grassBunch = new AdvancedModelBox((AdvancedEntityModel)this);
        this.grassBunch.setRotationPoint(2.0f, 0.0f, -3.5f);
        this.jaw.addChild((BasicModelPart)this.grassBunch);
        this.grass = new AdvancedModelBox((AdvancedEntityModel)this);
        this.grass.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.grassBunch.addChild((BasicModelPart)this.grass);
        this.grass5 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.grass5.setRotationPoint(2.4246f, -0.4275f, 0.0f);
        this.grass.addChild((BasicModelPart)this.grass5);
        this.setRotateAngle(this.grass5, 0.0f, 0.0f, -0.3491f);
        this.grass5.setTextureOffset(24, 165).addBox(-2.4246f, -0.4275f, -2.5f, 5.0f, 0.0f, 5.0f, 0.0f, false);
        this.grass2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.grass2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.grassBunch.addChild((BasicModelPart)this.grass2);
        this.grass2.setTextureOffset(1, 165).addBox(0.0f, 0.0f, -2.5f, 5.0f, 0.0f, 5.0f, 0.0f, false);
        this.grassBunch2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.grassBunch2.setRotationPoint(-2.0f, 0.0f, -3.5f);
        this.jaw.addChild((BasicModelPart)this.grassBunch2);
        this.grass3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.grass3.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.grassBunch2.addChild((BasicModelPart)this.grass3);
        this.grass6 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.grass6.setRotationPoint(-2.4246f, -0.4275f, 0.0f);
        this.grass3.addChild((BasicModelPart)this.grass6);
        this.setRotateAngle(this.grass6, 0.0f, 0.0f, 0.3491f);
        this.grass6.setTextureOffset(24, 165).addBox(-2.5754f, -0.4275f, -2.5f, 5.0f, 0.0f, 5.0f, 0.0f, true);
        this.grass4 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.grass4.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.grassBunch2.addChild((BasicModelPart)this.grass4);
        this.grass4.setTextureOffset(1, 165).addBox(-5.0f, 0.0f, -2.5f, 5.0f, 0.0f, 5.0f, 0.0f, true);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.bodySpikes, (Object)this.tail, (Object)this.tail2, (Object)this.tailSpike, (Object)this.tail2Spike, (Object)this.neck, (Object)this.head, (Object)this.jaw, (Object)this.larm, (Object)this.rarm, (Object)this.lleg, (Object[])new AdvancedModelBox[]{this.lleg2, this.lfoot, this.rleg, this.rleg2, this.rfoot, this.grassBunch, this.grassBunch2, this.grass, this.grass2, this.grass3, this.grass4, this.grass5, this.grass6});
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(GrottoceratopsEntity.ANIMATION_SPEAK_1);
        this.animator.startKeyframe(5);
        this.animator.move(this.jaw, 0.0f, 1.0f, -1.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(-10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GrottoceratopsEntity.ANIMATION_SPEAK_2);
        this.animator.startKeyframe(5);
        this.animator.move(this.jaw, 0.0f, 1.0f, -0.5f);
        this.animator.move(this.neck, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.head, 0.0f, 2.0f, -2.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(-20.0), (float)Math.toRadians(-10.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(10);
        this.animator.move(this.jaw, 0.0f, 1.0f, -0.5f);
        this.animator.move(this.neck, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.head, 0.0f, 2.0f, -2.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-20.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(-20.0), (float)Math.toRadians(10.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GrottoceratopsEntity.ANIMATION_CHEW_FROM_GROUND);
        this.animator.startKeyframe(5);
        this.animator.move(this.neck, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.head, 0.0f, 3.0f, -2.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.neck, 0.0f, 0.0f, -1.0f);
        this.animator.move(this.head, 0.0f, 3.0f, -2.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(15.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.move(this.neck, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.head, 0.0f, 3.0f, -2.0f);
        this.animator.rotate(this.jaw, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GrottoceratopsEntity.ANIMATION_MELEE_RAM);
        this.animator.startKeyframe(5);
        this.animator.move(this.neck, 0.0f, 0.0f, 2.0f);
        this.animator.move(this.head, 0.0f, 3.0f, -2.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(10.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.startKeyframe(2);
        this.animator.move(this.neck, 0.0f, 0.0f, -4.0f);
        this.animator.move(this.head, 0.0f, 3.0f, -2.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.rotate(this.neck, (float)Math.toRadians(-25.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(3);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GrottoceratopsEntity.ANIMATION_MELEE_TAIL_1);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(20.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.tail2, (float)Math.toRadians(20.0), (float)Math.toRadians(20.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(-20.0), (float)Math.toRadians(-50.0), 0.0f);
        this.animator.rotate(this.tail2, (float)Math.toRadians(-20.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(20.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(3);
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(GrottoceratopsEntity.ANIMATION_MELEE_TAIL_2);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(10.0), 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(20.0), (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.tail2, (float)Math.toRadians(20.0), (float)Math.toRadians(-20.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.neck, 0.0f, (float)Math.toRadians(-10.0), 0.0f);
        this.animator.rotate(this.tail, (float)Math.toRadians(-20.0), (float)Math.toRadians(50.0), 0.0f);
        this.animator.rotate(this.tail2, (float)Math.toRadians(-20.0), (float)Math.toRadians(20.0), (float)Math.toRadians(-20.0));
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(3);
        this.animator.resetKeyframe(5);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            float f = 1.5f;
            this.head.setScale(f, f, f);
            this.head.setShouldScaleChildren(true);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStackIn.m_85837_(0.0, 1.5, 0.0);
            this.parts().forEach(p_228292_8_ -> p_228292_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
            this.head.setScale(1.0f, 1.0f, 1.0f);
        } else {
            matrixStackIn.m_85836_();
            this.parts().forEach(p_228290_8_ -> p_228290_8_.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
        }
    }

    private void setupAnimForAnimation(GrottoceratopsEntity entity, Animation animation, float limbSwing, float limbSwingAmount, float ageInTicks) {
        boolean chewing;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        boolean bl = chewing = animation == GrottoceratopsEntity.ANIMATION_CHEW_FROM_GROUND || animation == GrottoceratopsEntity.ANIMATION_CHEW;
        if (chewing) {
            float animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 3.0f, animation, partialTick, animation == GrottoceratopsEntity.ANIMATION_CHEW_FROM_GROUND ? 15 : 0);
            float jawDown = Math.min(0.0f, ACMath.walkValue(ageInTicks, animationIntensity, 0.4f, 2.0f, 1.0f, true));
            this.head.rotateAngleX += ACMath.walkValue(ageInTicks, animationIntensity, 0.4f, 2.0f, 0.05f, false);
            this.jaw.rotationPointX += ACMath.walkValue(ageInTicks, animationIntensity, 0.4f, 0.5f, 2.0f, true);
            this.jaw.rotationPointY -= jawDown;
            this.grassBunch.rotationPointY -= jawDown * 0.5f;
            this.grassBunch2.rotationPointY -= jawDown * 0.5f;
            this.grassBunch.rotateAngleZ -= ACMath.walkValue(ageInTicks, animationIntensity, 0.4f, 2.0f, 0.3f, true);
            this.grassBunch2.rotateAngleZ -= ACMath.walkValue(ageInTicks, animationIntensity, 0.4f, 2.0f, 0.3f, false);
        }
    }

    public void setupAnim(GrottoceratopsEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean showGrass;
        this.resetToDefaultPose();
        this.animate(entity);
        float walkSpeed = 0.5f;
        float walkDegree = 1.0f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float buryEggsAmount = entity.getBuryEggsProgress(partialTick);
        float stillAmount = 1.0f - limbSwingAmount;
        float danceAmount = entity.getDanceProgress(partialTick);
        float danceSpeed = 0.5f;
        boolean bl = showGrass = entity.getAnimation() == GrottoceratopsEntity.ANIMATION_CHEW_FROM_GROUND && entity.getAnimationTick() > 15 || entity.getAnimation() == GrottoceratopsEntity.ANIMATION_CHEW;
        if (entity.getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            this.setupAnimForAnimation(entity, entity.getAnimation(), limbSwing, limbSwingAmount, ageInTicks);
        }
        float tailSwingYaw = Mth.m_14177_((float)entity.getTailSwingRot(partialTick)) / 57.295776f;
        this.body.rotateAngleY += tailSwingYaw;
        this.grassBunch.showModel = showGrass;
        this.grassBunch2.showModel = showGrass;
        if (buryEggsAmount > 0.0f) {
            limbSwing = ageInTicks;
            limbSwingAmount = buryEggsAmount * 0.5f;
            this.body.swing(0.25f, 0.4f, false, 0.0f, 0.0f, ageInTicks, buryEggsAmount);
            this.neck.swing(0.25f, 0.4f, true, -1.0f, 0.0f, ageInTicks, buryEggsAmount);
        }
        this.progressRotationPrev(this.tail, stillAmount, (float)Math.toRadians(-10.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.neck, 1.0f, 0.0f, 0.0f, 5.0f, 1.0f);
        this.walk(this.tail, 0.1f, 0.1f, false, 0.0f, 0.0f, ageInTicks, stillAmount);
        this.swing(this.tail, 0.1f, 0.2f, false, 2.0f, 0.0f, ageInTicks, stillAmount);
        this.swing(this.tail2, 0.1f, 0.1f, false, 1.0f, 0.0f, ageInTicks, stillAmount);
        this.walk(this.neck, 0.1f, 0.03f, false, 2.0f, 0.0f, ageInTicks, stillAmount);
        this.walk(this.head, 0.1f, 0.03f, true, 1.0f, 0.0f, ageInTicks, stillAmount);
        this.flap(this.body, walkSpeed, walkDegree * 0.1f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.lleg, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.rleg, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.larm, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.rarm, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.neck, walkSpeed, walkDegree * 0.1f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.tail, walkSpeed, walkDegree * 0.4f, false, -1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.tail2, walkSpeed, walkDegree * 0.2f, false, -1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.articulateLegs(entity.legSolver, partialTick);
        float bodyBob = ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed * 1.5f, 0.5f, 2.4f, true);
        this.body.rotationPointY += bodyBob;
        this.walk(this.larm, walkSpeed, walkDegree * 0.4f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.larm.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -1.5f, 5.0f, false)) - bodyBob;
        this.larm.rotationPointZ += ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -1.5f, 1.0f, false);
        this.walk(this.rarm, walkSpeed, walkDegree * 0.4f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.rarm.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -1.5f, 5.0f, true)) - bodyBob;
        this.rarm.rotationPointZ += ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -1.5f, 1.0f, true);
        this.walk(this.lleg, walkSpeed, walkDegree * 0.3f, false, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.lfoot, walkSpeed, walkDegree * 0.2f, false, 3.0f, 0.0f, limbSwing, limbSwingAmount);
        this.lleg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, 5.0f, true)) - bodyBob;
        this.lleg.rotationPointZ += ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, 1.0f, true);
        this.walk(this.rleg, walkSpeed, walkDegree * 0.3f, true, 1.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.rfoot, walkSpeed, walkDegree * 0.2f, true, 3.0f, 0.0f, limbSwing, limbSwingAmount);
        this.rleg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, 5.0f, false)) - bodyBob;
        this.rleg.rotationPointZ += ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, 1.0f, false);
        if (entity.getAnimation() != GrottoceratopsEntity.ANIMATION_MELEE_TAIL_1 && entity.getAnimation() != GrottoceratopsEntity.ANIMATION_MELEE_TAIL_2) {
            float yawAmount = netHeadYaw / 57.295776f;
            float pitchAmount = headPitch / 57.295776f;
            this.neck.rotateAngleX += pitchAmount * 0.1f;
            this.head.rotateAngleX += pitchAmount * 0.2f;
            this.neck.rotateAngleY += yawAmount * 0.3f;
            this.head.rotateAngleY += yawAmount * 0.4f;
        }
        this.neck.rotationPointY += ACMath.walkValue(ageInTicks, danceAmount, danceSpeed * 1.5f, 1.0f, 1.5f, false);
        this.neck.rotationPointX += ACMath.walkValue(ageInTicks, danceAmount, danceSpeed * 1.5f, 0.0f, 3.0f, false);
        this.swing(this.body, danceSpeed, 0.1f, false, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.swing(this.tail, danceSpeed, 0.5f, false, 1.0f, 0.0f, ageInTicks, danceAmount);
        this.swing(this.tail2, danceSpeed, 0.5f, false, 1.0f, 0.0f, ageInTicks, danceAmount);
    }

    private void articulateLegs(LegSolverQuadruped legs, float partialTick) {
        float heightBackLeft = legs.backLeft.getHeight(partialTick);
        float heightBackRight = legs.backRight.getHeight(partialTick);
        float heightFrontLeft = legs.frontLeft.getHeight(partialTick);
        float heightFrontRight = legs.frontRight.getHeight(partialTick);
        float max = Math.max(Math.max(heightBackLeft, heightBackRight), Math.max(heightFrontLeft, heightFrontRight)) * 0.8f;
        this.body.rotationPointY += max * 16.0f;
        this.rarm.rotationPointY += (heightFrontRight - max) * 16.0f;
        this.larm.rotationPointY += (heightFrontLeft - max) * 16.0f;
        this.rleg.rotationPointY += (heightBackRight - max) * 16.0f;
        this.lleg.rotationPointY += (heightBackLeft - max) * 16.0f;
    }

    public void animateSpirit(DinosaurSpiritEntity entityIn, float partialTicks) {
        this.resetToDefaultPose();
    }

    public void renderSpiritToBuffer(PoseStack poseStack, VertexConsumer ivertexbuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.3f, 1.0f);
        this.head.render(poseStack, ivertexbuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        poseStack.m_85849_();
    }
}

