/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.registry;

import com.mrbysco.raided.config.RaidedConfig;
import com.mrbysco.raided.entity.Electromancer;
import com.mrbysco.raided.entity.Incinerator;
import com.mrbysco.raided.entity.Inquisitor;
import com.mrbysco.raided.entity.Necromancer;
import com.mrbysco.raided.entity.Savager;
import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class RaidedSetup {
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(RaidedRegistry.INQUISITOR.getEntityType(), Inquisitor.createAttributes().m_22265_());
        event.put(RaidedRegistry.INCINERATOR.getEntityType(), Incinerator.createAttributes().m_22265_());
        event.put(RaidedRegistry.SAVAGER.getEntityType(), Savager.createAttributes().m_22265_());
        event.put(RaidedRegistry.NECROMANCER.getEntityType(), Necromancer.createAttributes().m_22265_());
        event.put(RaidedRegistry.ELECTROMANCER.getEntityType(), Electromancer.createAttributes().m_22265_());
    }

    public static void initializeRaiderTypes() {
        if (((Boolean)RaidedConfig.COMMON.spawnInquisitor.get()).booleanValue()) {
            RaidedSetup.registerRaiderTypes(RaidedRegistry.INQUISITOR.getEntityType(), (List)RaidedConfig.COMMON.inquisitorSpawnsPerWave.get());
        }
        if (((Boolean)RaidedConfig.COMMON.spawnIncinerator.get()).booleanValue()) {
            RaidedSetup.registerRaiderTypes(RaidedRegistry.INCINERATOR.getEntityType(), (List)RaidedConfig.COMMON.incineratorSpawnsPerWave.get());
        }
        if (((Boolean)RaidedConfig.COMMON.spawnSavager.get()).booleanValue()) {
            RaidedSetup.registerRaiderTypes(RaidedRegistry.SAVAGER.getEntityType(), (List)RaidedConfig.COMMON.savagerSpawnsPerWave.get());
        }
        if (((Boolean)RaidedConfig.COMMON.spawnNecromancer.get()).booleanValue()) {
            RaidedSetup.registerRaiderTypes(RaidedRegistry.NECROMANCER.getEntityType(), (List)RaidedConfig.COMMON.necromancerSpawnsPerWave.get());
        }
        if (((Boolean)RaidedConfig.COMMON.spawnElectromancer.get()).booleanValue()) {
            RaidedSetup.registerRaiderTypes(RaidedRegistry.ELECTROMANCER.getEntityType(), (List)RaidedConfig.COMMON.electromancerSpawnsPerWave.get());
        }
    }

    public static void registerRaiderTypes(EntityType<? extends Raider> type, List<? extends Integer> listValue) {
        int[] intArray = new int[9];
        for (int i = 0; i < listValue.size(); ++i) {
            intArray[i] = listValue.get(i);
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey(type);
        if (key != null) {
            Raid.RaiderType.create((String)key.toString(), type, (int[])intArray);
        }
    }
}

