/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.entity.projectiles;

import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class LightningProjectile
extends AbstractHurtingProjectile {
    @Nullable
    private UUID targetId;

    public LightningProjectile(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public LightningProjectile(Level level, LivingEntity shooter, double offsetX, double offsetY, double offsetZ) {
        super((EntityType)RaidedRegistry.LIGHTNING_PROJECTILE.get(), shooter, offsetX, offsetY, offsetZ, level);
        this.m_7678_(shooter.m_20185_(), shooter.m_20186_() + 2.0, shooter.m_20189_(), this.m_146908_(), this.m_146909_());
    }

    public LightningProjectile(Level level, double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
        super((EntityType)RaidedRegistry.LIGHTNING_PROJECTILE.get(), x, y, z, offsetX, offsetY, offsetZ, level);
    }

    public LightningProjectile(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends AbstractHurtingProjectile>)((EntityType)RaidedRegistry.LIGHTNING_PROJECTILE.get()), level);
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_175830_;
    }

    public void setTarget(@Nullable UUID targetId) {
        this.targetId = targetId;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.targetId != null) {
            tag.m_128362_("Target", this.targetId);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("Target")) {
            this.targetId = tag.m_128342_("Target");
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        Entity entity = hitResult.m_82443_();
        if (this.targetId != null && entity.m_20148_().equals(this.targetId)) {
            this.convertEntity(entity);
        } else {
            entity.m_6469_(this.m_269291_().m_269548_(), 2.0f);
        }
    }

    private void convertEntity(Entity entity) {
        if (!this.m_9236_().f_46443_) {
            AbstractVillager abstractVillager;
            if (entity instanceof Creeper) {
                Creeper creeper = (Creeper)entity;
                if (creeper.m_6084_() && !creeper.m_7090_()) {
                    LightningBolt bolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                    bolt.setDamage(0.0f);
                    creeper.m_8038_((ServerLevel)this.m_9236_(), bolt);
                }
            } else if (entity instanceof Pig) {
                Pig pig = (Pig)entity;
                if (pig.m_6084_()) {
                    LightningBolt bolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
                    bolt.setDamage(0.0f);
                    pig.m_8038_((ServerLevel)this.m_9236_(), bolt);
                }
            } else if (entity instanceof AbstractVillager && !((abstractVillager = (AbstractVillager)entity) instanceof WanderingTrader) && abstractVillager.m_6084_()) {
                ServerLevel level = (ServerLevel)this.m_9236_();
                if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL && ForgeEventFactory.canLivingConvert((LivingEntity)abstractVillager, (EntityType)EntityType.f_20495_, timer -> {})) {
                    Witch witch = (Witch)EntityType.f_20495_.m_20615_((Level)level);
                    witch.m_7678_(abstractVillager.m_20185_(), abstractVillager.m_20186_(), abstractVillager.m_20189_(), abstractVillager.m_146908_(), abstractVillager.m_146909_());
                    witch.m_6518_((ServerLevelAccessor)level, level.m_6436_(witch.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
                    witch.m_21557_(abstractVillager.m_21525_());
                    if (abstractVillager.m_8077_()) {
                        witch.m_6593_(abstractVillager.m_7770_());
                        witch.m_20340_(abstractVillager.m_20151_());
                    }
                    witch.m_21530_();
                    ForgeEventFactory.onLivingConvert((LivingEntity)abstractVillager, (LivingEntity)witch);
                    level.m_47205_((Entity)witch);
                    if (abstractVillager instanceof Villager) {
                        Villager villager = (Villager)abstractVillager;
                        villager.m_35524_();
                    }
                    abstractVillager.m_146870_();
                }
            }
        }
    }

    public boolean m_7337_(Entity entity) {
        return !(entity instanceof Raider) && super.m_7337_(entity);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

