/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.raided.datagen;

import com.mrbysco.raided.registry.RaidRegHelper;
import com.mrbysco.raided.registry.RaidedRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.common.data.SoundDefinitionsProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RaidedDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new Loots(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new EntityTags(packOutput, lookupProvider, helper));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new Language(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new SoundProvider(packOutput, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(PackOutput packOutput) {
            super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(RaidedLootTables::new, LootContextParamSets.f_81415_)));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> table.m_79136_(validationContext));
        }

        public static class RaidedLootTables
        extends EntityLootSubProvider {
            protected RaidedLootTables() {
                super(FeatureFlags.f_244280_.m_247355_());
            }

            public void m_246942_() {
                this.m_245309_(RaidedRegistry.INQUISITOR.getEntityType(), LootTable.m_79147_());
                this.m_245309_(RaidedRegistry.INCINERATOR.getEntityType(), LootTable.m_79147_());
                this.m_245309_(RaidedRegistry.SAVAGER.getEntityType(), LootTable.m_79147_());
                this.m_245309_(RaidedRegistry.NECROMANCER.getEntityType(), LootTable.m_79147_());
                this.m_245309_(RaidedRegistry.ELECTROMANCER.getEntityType(), LootTable.m_79147_());
            }

            protected Stream<EntityType<?>> getKnownEntityTypes() {
                return RaidedRegistry.ENTITY_TYPES.getEntries().stream().map(RegistryObject::get);
            }
        }
    }

    private static class EntityTags
    extends EntityTypeTagsProvider {
        public EntityTags(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(packOutput, provider, "raided", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider provider) {
            this.m_206424_(EntityTypeTags.f_13121_).m_255179_((Object[])new EntityType[]{RaidedRegistry.INQUISITOR.getEntityType(), RaidedRegistry.INCINERATOR.getEntityType(), RaidedRegistry.SAVAGER.getEntityType(), RaidedRegistry.NECROMANCER.getEntityType(), RaidedRegistry.ELECTROMANCER.getEntityType()});
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(PackOutput packOutput) {
            super(packOutput, "raided", "en_us");
        }

        protected void addTranslations() {
            this.addHelper(RaidedRegistry.INQUISITOR, "Inquisitor");
            this.addHelper(RaidedRegistry.INCINERATOR, "Incinerator");
            this.addHelper(RaidedRegistry.SAVAGER, "Savager");
            this.addHelper(RaidedRegistry.NECROMANCER, "Necromancer");
            this.addHelper(RaidedRegistry.ELECTROMANCER, "Electromancer");
            this.addSubtitle((SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get(), "Electromancer prepares conversion");
        }

        private void addHelper(RaidRegHelper helper, String name) {
            this.add(helper.getEntityType(), name);
            this.addItem((Supplier)helper.getSpawnEgg(), name + " Spawn Egg");
            this.addSubtitle(helper.getAmbient(), name + " mutters");
            this.addSubtitle(helper.getDeath(), name + " dies");
            this.addSubtitle(helper.getHurt(), name + " hurts");
            this.addSubtitle(helper.getCelebrate(), name + " cheers");
            if (helper.getCasting() != null) {
                this.addSubtitle(helper.getCasting(), name + " casts spell");
            }
        }

        public void addSubtitle(SoundEvent sound, String name) {
            String path = "raided.subtitle." + sound.m_11660_().m_135815_();
            this.add(path, name);
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "raided", helper);
        }

        protected void registerModels() {
            for (RegistryObject item : RaidedRegistry.ITEMS.getEntries()) {
                if (!(item.get() instanceof SpawnEggItem)) continue;
                this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/template_spawn_egg"));
            }
        }
    }

    private static class SoundProvider
    extends SoundDefinitionsProvider {
        public SoundProvider(PackOutput packOutput, ExistingFileHelper helper) {
            super(packOutput, "raided", helper);
        }

        public void registerSounds() {
            this.addHelper(RaidedRegistry.INQUISITOR);
            this.addHelper(RaidedRegistry.INCINERATOR);
            this.addHelper(RaidedRegistry.SAVAGER);
            this.addHelper(RaidedRegistry.NECROMANCER);
            this.addHelper(RaidedRegistry.ELECTROMANCER);
            this.add((SoundEvent)RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.get(), SoundProvider.definition().with(SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/prepare_wololo"))).subtitle(this.modSubtitle(RaidedRegistry.ELECROMANCER_PREPARE_CONVERSION.getId())));
        }

        private void addHelper(RaidRegHelper helper) {
            this.add(helper.getAmbient(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle2")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle3")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle4"))}).subtitle(this.modSubtitle(helper.getAmbient().m_11660_())));
            this.add(helper.getDeath(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/death1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/death2"))}).subtitle(this.modSubtitle(helper.getDeath().m_11660_())));
            this.add(helper.getHurt(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/hurt1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/hurt2"))}).subtitle(this.modSubtitle(helper.getDeath().m_11660_())));
            this.add(helper.getCelebrate(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/celebrate")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/idle2"))}).subtitle(this.modSubtitle(helper.getCelebrate().m_11660_())));
            if (helper.getCasting() != null) {
                this.add(helper.getCasting(), SoundProvider.definition().with(new SoundDefinition.Sound[]{SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/cast1")), SoundProvider.sound((ResourceLocation)new ResourceLocation("mob/evocation_illager/cast2"))}).subtitle(this.modSubtitle(helper.getCasting().m_11660_())));
            }
        }

        public String modSubtitle(ResourceLocation id) {
            return "raided.subtitle." + id.m_135815_();
        }
    }
}

