/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.config;

import com.cupboard.config.CupboardConfig;
import com.cupboard.config.ICommonConfig;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommonConfiguration
implements ICommonConfig {
    public static CupboardConfig<CommonConfiguration> config = new CupboardConfig("structureessentials", (ICommonConfig)new CommonConfiguration());
    public boolean structurePlacementLogging = false;
    public int structureSearchTimeout = 50;
    public boolean useFastStructureLookup = true;
    public boolean warnMissingRegistryEntry = true;
    public boolean disableLegacyRandomCrashes = true;
    public int mapSearchRadius = 40;
    public int globalSearchRadius = 70;
    public int locateSearchRadius = 110;
    public double spacingSeparationModifier = 1.0;
    public int minimumStructureDistance = 32;
    public boolean minimumStructureDistanceEnabled = false;
    public boolean minimumStructureDistanceLogging = false;
    public Set<String> dimensionWhitelist = new HashSet<String>(List.of("minecraft:overworld", "minecraft:the_end", "minecraft:the_nether"));
    public boolean logDuplicatedSalt = true;
    public boolean autoBiomeCompat = false;
    public boolean autoBiomeCompatLogging = true;
    public double autoBiomeCompatStrictness = 1.2;

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Enables debug logging of structure placement. Warning: This will spam the logs and is only recommended for debugging purposes. Default: false");
        entry.addProperty("structurePlacementLogging", Boolean.valueOf(this.structurePlacementLogging));
        root.add("structurePlacementLogging", (JsonElement)entry);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "The maximum time (in seconds) a structure search is allowed to take. Default: 50");
        entry2.addProperty("structureSearchTimeout", (Number)this.structureSearchTimeout);
        root.add("structureSearchTimeout", (JsonElement)entry2);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "Enables faster structure search. Default: true");
        entry3.addProperty("useFastStructureLookup", Boolean.valueOf(this.useFastStructureLookup));
        root.add("useFastStructureLookup", (JsonElement)entry3);
        JsonObject entry6 = new JsonObject();
        entry6.addProperty("desc:", "Specifies the maximum radius map items can search for structures. Lowering this value reduces the time structure searches stall the server but decreases the range in which structures are found. Vanilla: 50, Default: 40");
        entry6.addProperty("mapSearchRadius", (Number)this.mapSearchRadius);
        root.add("mapSearchRadius", (JsonElement)entry6);
        JsonObject entry8 = new JsonObject();
        entry8.addProperty("desc:", "Sets the search radius for the locate structure command. Vanilla: 100, Default: 110");
        entry8.addProperty("locateSearchRadius", (Number)this.locateSearchRadius);
        root.add("locateSearchRadius", (JsonElement)entry8);
        JsonObject entry7 = new JsonObject();
        entry7.addProperty("desc:", "Sets the global maximum structure search radius. The vanilla locate command uses 100. Lowering this value reduces the time structure searches stall the server but decreases the range in which structures are found. Default: 70");
        entry7.addProperty("globalSearchRadius", (Number)this.globalSearchRadius);
        root.add("globalSearchRadius", (JsonElement)entry7);
        JsonObject entry9 = new JsonObject();
        entry9.addProperty("desc:", "Adjusts the structure spacing (average spawn distance) and separation (minimum spawn distance). Increasing the value makes structures spawn farther apart, while decreasing it makes them spawn closer together. Vanilla Default: 1.0");
        entry9.addProperty("spacingSeparationModifier", (Number)this.spacingSeparationModifier);
        root.add("spacingSeparationModifier", (JsonElement)entry9);
        JsonObject entry14 = new JsonObject();
        entry14.addProperty("desc:", "Structure sets use a salt value to determine the randomness of their placement. Duplicated use of the same salt value can cause structures to spawn on the same place, this config enables logging duplicated salt values. Default: true");
        entry14.addProperty("logDuplicatedSalt", Boolean.valueOf(this.logDuplicatedSalt));
        root.add("logDuplicatedSalt", (JsonElement)entry14);
        JsonObject entry15 = new JsonObject();
        entry15.addProperty("desc:", "Set a minimum distance in blocks between structures generated which prevents structure overlaps(not 100% but close). Not recommended to use higher values, as that may strain the worldgen due to repeated structure retries and can prevent surfaces structures when there is some in a cave below. If you want structures more spaced out than this use the spacing/seperation modifier. Default: 32 blocks, range 16-512");
        entry15.addProperty("minimumStructureDistance", (Number)this.minimumStructureDistance);
        entry15.addProperty("enabled", Boolean.valueOf(this.minimumStructureDistanceEnabled));
        entry15.addProperty("logOverlaps", Boolean.valueOf(this.minimumStructureDistanceLogging));
        root.add("minimumStructureDistance", (JsonElement)entry15);
        JsonObject entry17 = new JsonObject();
        entry17.addProperty("desc:", "Automatically analyzes present biomes and adjust structure spawning to include fitting ones, Note that this may also spawn structures in undesired biomes, check the logging and adjust the strictness up/down to achieve a good result. Default: false");
        entry17.addProperty("enableBiomeCompat", Boolean.valueOf(this.autoBiomeCompat));
        entry17.addProperty("enableLogging", Boolean.valueOf(this.autoBiomeCompatLogging));
        JsonObject strictnessSetting = new JsonObject();
        strictnessSetting.addProperty("desc:", "Sets a modifier for how strict the autoBiomeCompat is, lower allows adding less similar biomes to be added. E.g. 0.5 decreases the similarity requirements by 50% . Default: 1.2");
        strictnessSetting.addProperty("autoBiomeCompatStrictness", (Number)this.autoBiomeCompatStrictness);
        entry17.add("strictness", (JsonElement)strictnessSetting);
        JsonObject whitelist = new JsonObject();
        whitelist.addProperty("desc:", "List of allowed dimensions for automatic structure compat, by default only vanilla dimensions");
        JsonArray dimensions = new JsonArray();
        for (String dimension : this.dimensionWhitelist) {
            dimensions.add(dimension);
        }
        whitelist.add("dimensions", (JsonElement)dimensions);
        entry17.add("dimensionWhitelist", (JsonElement)whitelist);
        root.add("autoBiomeCompat", (JsonElement)entry17);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "Prevents crashes due to missing registry entries (e.g., changes in mod structure IDs) by converting them into log error messages instead. Default: true");
        entry4.addProperty("warnMissingRegistryEntry", Boolean.valueOf(this.warnMissingRegistryEntry));
        root.add("warnMissingRegistryEntry", (JsonElement)entry4);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Prevents crashes caused by multithreaded access to thread-specific random number generators. Default: true");
        entry5.addProperty("disableLegacyRandomCrashes", Boolean.valueOf(this.disableLegacyRandomCrashes));
        root.add("disableLegacyRandomCrashes", (JsonElement)entry5);
        return root;
    }

    public void deserialize(JsonObject data) {
        this.structurePlacementLogging = data.get("structurePlacementLogging").getAsJsonObject().get("structurePlacementLogging").getAsBoolean();
        this.structureSearchTimeout = data.get("structureSearchTimeout").getAsJsonObject().get("structureSearchTimeout").getAsInt();
        this.useFastStructureLookup = data.get("useFastStructureLookup").getAsJsonObject().get("useFastStructureLookup").getAsBoolean();
        this.warnMissingRegistryEntry = data.get("warnMissingRegistryEntry").getAsJsonObject().get("warnMissingRegistryEntry").getAsBoolean();
        this.disableLegacyRandomCrashes = data.get("disableLegacyRandomCrashes").getAsJsonObject().get("disableLegacyRandomCrashes").getAsBoolean();
        this.mapSearchRadius = data.get("mapSearchRadius").getAsJsonObject().get("mapSearchRadius").getAsInt();
        this.globalSearchRadius = data.get("globalSearchRadius").getAsJsonObject().get("globalSearchRadius").getAsInt();
        this.locateSearchRadius = data.get("locateSearchRadius").getAsJsonObject().get("locateSearchRadius").getAsInt();
        this.spacingSeparationModifier = data.get("spacingSeparationModifier").getAsJsonObject().get("spacingSeparationModifier").getAsDouble();
        this.minimumStructureDistance = Math.min(512, Math.max(16, data.get("minimumStructureDistance").getAsJsonObject().get("minimumStructureDistance").getAsInt()));
        this.minimumStructureDistanceEnabled = data.get("minimumStructureDistance").getAsJsonObject().get("enabled").getAsBoolean();
        this.minimumStructureDistanceLogging = data.get("minimumStructureDistance").getAsJsonObject().get("logOverlaps").getAsBoolean();
        this.logDuplicatedSalt = data.get("logDuplicatedSalt").getAsJsonObject().get("logDuplicatedSalt").getAsBoolean();
        this.autoBiomeCompat = data.get("autoBiomeCompat").getAsJsonObject().get("enableBiomeCompat").getAsBoolean();
        this.autoBiomeCompatLogging = data.get("autoBiomeCompat").getAsJsonObject().get("enableLogging").getAsBoolean();
        this.autoBiomeCompatStrictness = data.get("autoBiomeCompat").getAsJsonObject().get("strictness").getAsJsonObject().get("autoBiomeCompatStrictness").getAsDouble();
        this.dimensionWhitelist = new HashSet<String>();
        data.get("autoBiomeCompat").getAsJsonObject().get("dimensionWhitelist").getAsJsonObject().get("dimensions").getAsJsonArray().forEach(e -> this.dimensionWhitelist.add(e.getAsString()));
    }
}

