/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.render;

import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_918;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.render.CustomModels;

public class OrbitingEffectRenderer
implements CustomModelStatusEffect.Renderer {
    private List<Model> models;
    private float scale;
    private float horizontalOffset;

    public OrbitingEffectRenderer(List<Model> models, float scale, float horizontalOffset) {
        this.models = models;
        this.scale = scale;
        this.horizontalOffset = horizontalOffset;
    }

    @Override
    public void renderEffect(int amplifier, class_1309 livingEntity, float delta, class_4587 matrixStack, class_4597 vertexConsumers, int light) {
        matrixStack.method_22903();
        float time = (float)livingEntity.method_37908().method_8510() + delta;
        float initialAngle = time * 2.25f - 45.0f;
        float horizontalOffset = this.horizontalOffset * livingEntity.method_17825();
        float verticalOffset = livingEntity.method_17682() / 2.0f;
        class_918 itemRenderer = class_310.method_1551().method_1480();
        int stacks = amplifier + 1;
        float turnAngle = 360.0f / (float)stacks;
        for (int i = 0; i < stacks; ++i) {
            float angle = initialAngle + turnAngle * (float)i;
            this.renderModel(matrixStack, this.scale, verticalOffset, horizontalOffset, angle, itemRenderer, vertexConsumers, light, livingEntity);
        }
        matrixStack.method_22909();
    }

    private void renderModel(class_4587 matrixStack, float scale, float verticalOffset, float horizontalOffset, float rotation, class_918 itemRenderer, class_4597 vertexConsumers, int light, class_1309 livingEntity) {
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rotation));
        matrixStack.method_46416(0.0f, verticalOffset, -horizontalOffset);
        matrixStack.method_22905(scale, scale, scale);
        for (Model model : this.models) {
            matrixStack.method_22903();
            CustomModels.render(model.layer, itemRenderer, model.modelId, matrixStack, vertexConsumers, light, livingEntity.method_5628());
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
    }

    public record Model(class_1921 layer, class_2960 modelId) {
    }
}

