/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.mixin;

import com.zigythebird.playeranimatorapi.azure.AnimatablePlayerLayer;
import com.zigythebird.playeranimatorapi.azure.PlayerAnimationModel;
import com.zigythebird.playeranimatorapi.mixin.KeyframeAnimationPlayerAccessor;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.model.CoreGeoModel;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationProcessor;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.model.GeoModel;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GeoModel.class})
public abstract class GeoModelMixin_azureOnly<T extends GeoAnimatable> {
    @Shadow(remap=false)
    private long lastRenderedInstance;
    @Shadow(remap=false)
    private double lastGameTickTime;
    @Shadow(remap=false)
    private double animTime;

    @Shadow(remap=false)
    public abstract boolean crashIfBoneMissing();

    @Shadow(remap=false)
    public abstract AnimationProcessor<T> getAnimationProcessor();

    @Inject(method={"handleAnimations"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void inject(T animatable, long instanceId, AnimationState<T> animationState, CallbackInfo ci) {
        if (this instanceof PlayerAnimationModel) {
            boolean isReRender;
            Minecraft mc = Minecraft.m_91087_();
            AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
            Double currentTick = (Double)animationState.getData(DataTickets.TICK);
            CustomModifierLayer modifierLayer = PlayerAnimations.getModifierLayer(((AnimatablePlayerLayer)animatable).getPlayer());
            if (animatableManager.getFirstTickTime() == -1.0) {
                animatableManager.startedAt(currentTick + (double)mc.m_91296_() - (double)modifierLayer.animPlayer.getTick() - (double)((KeyframeAnimationPlayerAccessor)modifierLayer.animPlayer).getTickDelta());
            }
            if (currentTick == null) {
                LivingEntity livingEntity = (LivingEntity)animatable;
                currentTick = livingEntity.f_19797_;
            }
            if (animatableManager.getFirstTickTime() == -1.0) {
                animatableManager.startedAt(currentTick + (double)mc.m_91296_());
            }
            double currentFrameTime = currentTick - animatableManager.getFirstTickTime();
            boolean bl = isReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
            if (isReRender && instanceId == this.lastRenderedInstance) {
                return;
            }
            if (!(isReRender || mc.m_91104_() && !animatable.shouldPlayAnimsWhileGamePaused())) {
                animatableManager.updatedAt(currentFrameTime);
                double lastUpdateTime = animatableManager.getLastUpdateTime();
                this.animTime += lastUpdateTime - this.lastGameTickTime;
                this.lastGameTickTime = lastUpdateTime;
            }
            animationState.animationTick = this.animTime;
            AnimationProcessor<T> processor = this.getAnimationProcessor();
            processor.preAnimationSetup(animationState.getAnimatable(), this.animTime);
            if (!processor.getRegisteredBones().isEmpty()) {
                processor.tickAnimation(animatable, (CoreGeoModel)((GeoModel)this), animatableManager, this.animTime, animationState, this.crashIfBoneMissing());
            }
            ci.cancel();
        }
    }
}

