/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.zigythebird.playeranimatorapi.ModInit;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.gson.AnimationSerializing;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceReloadListener
implements ResourceManagerReloadListener {
    private static final Logger logger = LogManager.getLogger(ModInit.class);

    public void m_6213_(ResourceManager resourceManager) {
        PlayerAnimations.animLengthsMap = new HashMap<ResourceLocation, Float>();
        PlayerAnimations.geckoMap = new HashMap<ResourceLocation, ResourceLocation>();
        for (Map.Entry resource : resourceManager.m_214159_("player_animation", location -> location.m_135815_().endsWith(".json")).entrySet()) {
            try {
                JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)JsonParser.parseReader((Reader)((Resource)resource.getValue()).m_215508_()), (String)"resource");
                if (jsonObject.has("animations")) {
                    for (Map.Entry object : jsonObject.get("animations").getAsJsonObject().asMap().entrySet()) {
                        ResourceLocation resourceLocation = new ResourceLocation(((ResourceLocation)resource.getKey()).m_135827_(), ((String)object.getKey()).toLowerCase(Locale.ROOT));
                        PlayerAnimations.animLengthsMap.put(resourceLocation, Float.valueOf(((JsonElement)object.getValue()).getAsJsonObject().get("animation_length").getAsFloat()));
                        if (!((JsonElement)object.getValue()).getAsJsonObject().has("geckoResource")) continue;
                        PlayerAnimations.geckoMap.put(resourceLocation, new ResourceLocation(((JsonElement)object.getValue()).getAsJsonObject().get("geckoResource").getAsString()));
                    }
                    continue;
                }
                InputStream input = ((Resource)resource.getValue()).m_215507_();
                try {
                    for (KeyframeAnimation animation : AnimationSerializing.deserializeAnimation((InputStream)input)) {
                        PlayerAnimations.animLengthsMap.put(new ResourceLocation(((ResourceLocation)resource.getKey()).m_135827_(), PlayerAnimationRegistry.serializeTextToString((String)((String)animation.extraData.get("name"))).toLowerCase(Locale.ROOT)), Float.valueOf(animation.endTick / 20));
                        if (!jsonObject.has("geckoResource")) continue;
                        PlayerAnimations.geckoMap.put(new ResourceLocation(((ResourceLocation)resource.getKey()).m_135827_(), PlayerAnimationRegistry.serializeTextToString((String)((String)animation.extraData.get("name"))).toLowerCase(Locale.ROOT)), new ResourceLocation(jsonObject.get("geckoResource").getAsString()));
                    }
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            catch (IOException | NullPointerException e) {
                logger.warn("Could not load animation resource " + ((ResourceLocation)resource.getKey()).toString() + " " + String.valueOf(e));
            }
        }
    }
}

