/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.API;

import com.zigythebird.multiloaderutils.misc.ModLoader;
import com.zigythebird.multiloaderutils.utils.Platform;
import com.zigythebird.playeranimatorapi.compatibility.ReplayModCompat;
import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.data.PlayerParts;
import com.zigythebird.playeranimatorapi.modifier.CommonModifier;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerAnimAPIClient {
    public static void playPlayerAnim(AbstractClientPlayer player, ResourceLocation animationID) {
        PlayerAnimAPIClient.playPlayerAnim(player, animationID, PlayerParts.allEnabled, null, -1, -1, 1000, false, true);
    }

    public static void playPlayerAnim(AbstractClientPlayer player, ResourceLocation animationID, PlayerParts parts, List<CommonModifier> modifiers, int priority) {
        PlayerAnimAPIClient.playPlayerAnim(player, animationID, parts, modifiers, -1, -1, priority, false, true);
    }

    public static void playPlayerAnim(AbstractClientPlayer player, PlayerAnimationData data) {
        PlayerAnimations.playAnimation(player, data);
    }

    public static void playPlayerAnim(AbstractClientPlayer player, ResourceLocation animationID, PlayerParts parts, List<CommonModifier> modifiers, int fadeLength, int easeID, int priority, boolean firstPersonEnabled, boolean replaceTick) {
        if (Platform.isModLoaded((String)"replaymod") && Platform.getLoader().equals((Object)ModLoader.Fabric)) {
            ReplayModCompat.playPlayerAnim(player, animationID, parts, modifiers, fadeLength, easeID, priority, firstPersonEnabled, replaceTick);
        }
        PlayerAnimations.playAnimation(player, new PlayerAnimationData(player.m_20148_(), animationID, parts, modifiers, fadeLength, easeID, priority, firstPersonEnabled), replaceTick);
    }

    public static void stopPlayerAnim(AbstractClientPlayer player, ResourceLocation animationID) {
        if (Platform.isModLoaded((String)"replaymod") && Platform.getLoader().equals((Object)ModLoader.Fabric)) {
            ReplayModCompat.stopPlayerAnim(player, animationID);
        }
        PlayerAnimations.stopAnimation(player, animationID);
    }
}

