/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.player;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.client.widget.editor.SkillTreeEditor;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.init.PSTSkillBonuses;
import daripher.skilltree.network.NetworkHelper;
import daripher.skilltree.skill.bonus.EventListenerBonus;
import daripher.skilltree.skill.bonus.SkillBonus;
import daripher.skilltree.skill.bonus.event.AttackEventListener;
import daripher.skilltree.skill.bonus.event.SkillEventListener;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class IgniteBonus
implements EventListenerBonus<IgniteBonus> {
    private float chance;
    private int duration;
    private SkillEventListener eventListener;

    public IgniteBonus(float chance, int duration, SkillEventListener eventListener) {
        this.chance = chance;
        this.duration = duration;
        this.eventListener = eventListener;
    }

    public IgniteBonus(float chance, int duration) {
        this(chance, duration, new AttackEventListener());
    }

    @Override
    public void applyEffect(LivingEntity target) {
        if (target.m_217043_().m_188501_() < this.chance) {
            target.m_20254_(this.duration);
        }
    }

    @Override
    public SkillBonus.Serializer getSerializer() {
        return (SkillBonus.Serializer)PSTSkillBonuses.IGNITE.get();
    }

    public IgniteBonus copy() {
        return new IgniteBonus(this.chance, this.duration, this.eventListener);
    }

    @Override
    public IgniteBonus multiply(double multiplier) {
        this.chance *= (float)multiplier;
        return this;
    }

    @Override
    public boolean canMerge(SkillBonus<?> other) {
        if (!(other instanceof IgniteBonus)) {
            return false;
        }
        IgniteBonus otherBonus = (IgniteBonus)other;
        if (otherBonus.duration != this.duration) {
            return false;
        }
        return Objects.equals(otherBonus.eventListener, this.eventListener);
    }

    @Override
    public SkillBonus<EventListenerBonus<IgniteBonus>> merge(SkillBonus<?> other) {
        if (!(other instanceof IgniteBonus)) {
            throw new IllegalArgumentException();
        }
        IgniteBonus otherBonus = (IgniteBonus)other;
        return new IgniteBonus(otherBonus.chance + this.chance, this.duration, this.eventListener);
    }

    @Override
    public MutableComponent getTooltip() {
        String durationDescription = StringUtil.m_14404_((int)(this.duration * 20));
        String targetDescription = this.eventListener.getTarget().name().toLowerCase();
        String bonusDescription = this.getDescriptionId() + "." + targetDescription;
        if (this.chance < 1.0f) {
            bonusDescription = bonusDescription + ".chance";
        }
        MutableComponent tooltip = Component.m_237110_((String)bonusDescription, (Object[])new Object[]{durationDescription});
        if (this.chance < 1.0f) {
            tooltip = TooltipHelper.getSkillBonusTooltip((Component)tooltip, (double)this.chance, AttributeModifier.Operation.MULTIPLY_BASE);
        }
        tooltip = this.eventListener.getTooltip((Component)tooltip);
        return tooltip.m_130948_(TooltipHelper.getSkillBonusStyle(this.isPositive()));
    }

    @Override
    public boolean isPositive() {
        return this.chance > 0.0f ^ this.eventListener.getTarget() == SkillBonus.Target.PLAYER;
    }

    @Override
    public SkillEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public void addEditorWidgets(SkillTreeEditor editor, int row, Consumer<EventListenerBonus<IgniteBonus>> consumer) {
        editor.addLabel(0, 0, "Chance", ChatFormatting.GOLD);
        editor.addLabel(110, 0, "Duration", ChatFormatting.GOLD);
        editor.increaseHeight(19);
        editor.addNumericTextField(0, 0, 90, 14, this.chance).setNumericResponder(value -> this.selectChance(consumer, (Double)value));
        editor.addNumericTextField(110, 0, 90, 14, this.duration).setNumericResponder(value -> this.selectDuration(consumer, (Double)value));
        editor.increaseHeight(19);
        editor.addLabel(0, 0, "Event", ChatFormatting.GOLD);
        editor.increaseHeight(19);
        editor.addSelectionMenu(0, 0, 200, this.eventListener).setResponder(eventListener -> this.selectEventListener(editor, consumer, (SkillEventListener)eventListener)).setMenuInitFunc(() -> this.addEventListenerWidgets(editor, consumer));
        editor.increaseHeight(19);
    }

    private void addEventListenerWidgets(SkillTreeEditor editor, Consumer<EventListenerBonus<IgniteBonus>> consumer) {
        this.eventListener.addEditorWidgets(editor, eventListener -> {
            this.setEventListener((SkillEventListener)eventListener);
            consumer.accept(this.copy());
        });
    }

    private void selectEventListener(SkillTreeEditor editor, Consumer<EventListenerBonus<IgniteBonus>> consumer, SkillEventListener eventListener) {
        this.setEventListener(eventListener);
        consumer.accept(this.copy());
        editor.rebuildWidgets();
    }

    private void selectDuration(Consumer<EventListenerBonus<IgniteBonus>> consumer, Double value) {
        this.setDuration(value.intValue());
        consumer.accept(this.copy());
    }

    private void selectChance(Consumer<EventListenerBonus<IgniteBonus>> consumer, Double value) {
        this.setChance(value.floatValue());
        consumer.accept(this.copy());
    }

    public void setEventListener(SkillEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public static class Serializer
    implements SkillBonus.Serializer {
        @Override
        public IgniteBonus deserialize(JsonObject json) throws JsonParseException {
            float chance = SerializationHelper.getElement(json, "chance").getAsFloat();
            int duration = SerializationHelper.getElement(json, "duration").getAsInt();
            IgniteBonus bonus = new IgniteBonus(chance, duration);
            bonus.eventListener = SerializationHelper.deserializeEventListener(json);
            return bonus;
        }

        @Override
        public void serialize(JsonObject json, SkillBonus<?> bonus) {
            if (!(bonus instanceof IgniteBonus)) {
                throw new IllegalArgumentException();
            }
            IgniteBonus aBonus = (IgniteBonus)bonus;
            json.addProperty("chance", (Number)Float.valueOf(aBonus.chance));
            json.addProperty("duration", (Number)aBonus.duration);
            SerializationHelper.serializeEventListener(json, aBonus.eventListener);
        }

        @Override
        public IgniteBonus deserialize(CompoundTag tag) {
            float chance = tag.m_128457_("chance");
            int duration = tag.m_128451_("duration");
            IgniteBonus bonus = new IgniteBonus(chance, duration);
            bonus.eventListener = SerializationHelper.deserializeEventListener(tag);
            return bonus;
        }

        @Override
        public CompoundTag serialize(SkillBonus<?> bonus) {
            if (!(bonus instanceof IgniteBonus)) {
                throw new IllegalArgumentException();
            }
            IgniteBonus aBonus = (IgniteBonus)bonus;
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("chance", aBonus.chance);
            tag.m_128405_("duration", aBonus.duration);
            SerializationHelper.serializeEventListener(tag, aBonus.eventListener);
            return tag;
        }

        @Override
        public IgniteBonus deserialize(FriendlyByteBuf buf) {
            float amount = buf.readFloat();
            int duration = buf.readInt();
            IgniteBonus bonus = new IgniteBonus(amount, duration);
            bonus.eventListener = NetworkHelper.readEventListener(buf);
            return bonus;
        }

        @Override
        public void serialize(FriendlyByteBuf buf, SkillBonus<?> bonus) {
            if (!(bonus instanceof IgniteBonus)) {
                throw new IllegalArgumentException();
            }
            IgniteBonus aBonus = (IgniteBonus)bonus;
            buf.writeFloat(aBonus.chance);
            buf.writeInt(aBonus.duration);
            NetworkHelper.writeEventListener(buf, aBonus.eventListener);
        }

        @Override
        public SkillBonus<?> createDefaultInstance() {
            return new IgniteBonus(0.05f, 5);
        }
    }
}

