/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.multiplier;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.tooltip.TooltipHelper;
import daripher.skilltree.client.widget.editor.SkillTreeEditor;
import daripher.skilltree.init.PSTLivingMultipliers;
import daripher.skilltree.skill.bonus.SkillBonus;
import daripher.skilltree.skill.bonus.multiplier.LivingMultiplier;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;

public final class MissingHealthPercentageMultiplier
implements LivingMultiplier {
    private float divisor;

    public MissingHealthPercentageMultiplier(float divisor) {
        this.divisor = divisor;
    }

    @Override
    public float getValue(LivingEntity entity) {
        return (int)(100.0f - entity.m_21223_() / entity.m_21233_() * 100.0f);
    }

    @Override
    public MutableComponent getTooltip(MutableComponent bonusTooltip, SkillBonus.Target target) {
        String multiplierDescription = this.getDescriptionId(target);
        String divisorDescription = TooltipHelper.formatNumber(this.divisor) + "%";
        return Component.m_237110_((String)multiplierDescription, (Object[])new Object[]{bonusTooltip, divisorDescription});
    }

    @Override
    public void addEditorWidgets(SkillTreeEditor editor, Consumer<LivingMultiplier> consumer) {
        editor.addLabel(0, 0, "Divisor", ChatFormatting.GREEN);
        editor.increaseHeight(19);
        editor.addNumericTextField(0, 0, 50, 14, this.divisor).setNumericFilter(value -> value > 0.0).setNumericResponder(value -> this.selectDivisor(consumer, (Double)value));
        editor.increaseHeight(19);
    }

    private void selectDivisor(Consumer<LivingMultiplier> consumer, Double value) {
        this.setDivisor(value.floatValue());
        consumer.accept(this);
    }

    @Override
    public LivingMultiplier.Serializer getSerializer() {
        return (LivingMultiplier.Serializer)PSTLivingMultipliers.MISSING_HEALTH_PERCENTAGE.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MissingHealthPercentageMultiplier that = (MissingHealthPercentageMultiplier)o;
        return Float.compare(this.divisor, that.divisor) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.divisor));
    }

    public void setDivisor(float divisor) {
        this.divisor = divisor;
    }

    public static class Serializer
    implements LivingMultiplier.Serializer {
        @Override
        public LivingMultiplier deserialize(JsonObject json) throws JsonParseException {
            return new MissingHealthPercentageMultiplier(json.get("divisor").getAsFloat());
        }

        @Override
        public void serialize(JsonObject json, LivingMultiplier multiplier) {
            if (!(multiplier instanceof MissingHealthPercentageMultiplier)) {
                throw new IllegalArgumentException();
            }
            MissingHealthPercentageMultiplier aMultiplier = (MissingHealthPercentageMultiplier)multiplier;
            json.addProperty("divisor", (Number)Float.valueOf(aMultiplier.divisor));
        }

        @Override
        public LivingMultiplier deserialize(CompoundTag tag) {
            float divisor = tag.m_128457_("divisor");
            return new MissingHealthPercentageMultiplier(divisor);
        }

        @Override
        public CompoundTag serialize(LivingMultiplier multiplier) {
            if (!(multiplier instanceof MissingHealthPercentageMultiplier)) {
                throw new IllegalArgumentException();
            }
            MissingHealthPercentageMultiplier aMultiplier = (MissingHealthPercentageMultiplier)multiplier;
            CompoundTag tag = new CompoundTag();
            tag.m_128350_("divisor", aMultiplier.divisor);
            return tag;
        }

        @Override
        public LivingMultiplier deserialize(FriendlyByteBuf buf) {
            return new MissingHealthPercentageMultiplier(buf.readFloat());
        }

        @Override
        public void serialize(FriendlyByteBuf buf, LivingMultiplier multiplier) {
            if (!(multiplier instanceof MissingHealthPercentageMultiplier)) {
                throw new IllegalArgumentException();
            }
            MissingHealthPercentageMultiplier aMultiplier = (MissingHealthPercentageMultiplier)multiplier;
            buf.writeFloat(aMultiplier.divisor);
        }

        @Override
        public LivingMultiplier createDefaultInstance() {
            return new MissingHealthPercentageMultiplier(10.0f);
        }
    }
}

