/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.skill.bonus.condition.living;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import daripher.skilltree.client.widget.editor.SkillTreeEditor;
import daripher.skilltree.init.PSTLivingConditions;
import daripher.skilltree.skill.bonus.condition.living.LivingCondition;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;

public final class EffectAmountCondition
implements LivingCondition {
    private int min;
    private int max;

    public EffectAmountCondition(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean met(LivingEntity living) {
        int effects = living.m_21220_().size();
        if (this.min == -1) {
            return effects <= this.max;
        }
        if (this.max == -1) {
            return effects >= this.min;
        }
        return effects <= this.max && effects >= this.min;
    }

    @Override
    public MutableComponent getTooltip(MutableComponent bonusTooltip, String target) {
        String key = this.getDescriptionId();
        MutableComponent targetDescription = Component.m_237115_((String)"%s.target.%s".formatted(key, target));
        if (this.min == -1) {
            return Component.m_237110_((String)(key + ".max"), (Object[])new Object[]{bonusTooltip, targetDescription, this.max});
        }
        if (this.max == -1) {
            if (this.min == 1) {
                return Component.m_237110_((String)(key + ".min.1"), (Object[])new Object[]{bonusTooltip, targetDescription, this.min});
            }
            return Component.m_237110_((String)(key + ".min"), (Object[])new Object[]{bonusTooltip, targetDescription, this.min});
        }
        return Component.m_237110_((String)(key + ".range"), (Object[])new Object[]{bonusTooltip, targetDescription, this.min, this.max});
    }

    @Override
    public LivingCondition.Serializer getSerializer() {
        return (LivingCondition.Serializer)PSTLivingConditions.EFFECT_AMOUNT.get();
    }

    @Override
    public void addEditorWidgets(SkillTreeEditor editor, Consumer<LivingCondition> consumer) {
        editor.addLabel(0, 0, "Min", ChatFormatting.GREEN);
        editor.addLabel(55, 0, "Max", ChatFormatting.GREEN);
        editor.increaseHeight(19);
        editor.addNumericTextField(0, 0, 50, 14, this.min).setNumericResponder(value -> this.selectMinimum(consumer, (Double)value));
        editor.addNumericTextField(55, 0, 50, 14, this.max).setNumericResponder(value -> this.selectMaximum(consumer, (Double)value));
        editor.increaseHeight(19);
    }

    private void selectMaximum(Consumer<LivingCondition> consumer, Double value) {
        this.setMax(value.intValue());
        consumer.accept(this);
    }

    private void selectMinimum(Consumer<LivingCondition> consumer, Double value) {
        this.setMin(value.intValue());
        consumer.accept(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EffectAmountCondition that = (EffectAmountCondition)o;
        return this.min == that.min && this.max == that.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public void setMin(int min) {
        this.min = min;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public static class Serializer
    implements LivingCondition.Serializer {
        @Override
        public LivingCondition deserialize(JsonObject json) throws JsonParseException {
            int min = json.has("min") ? json.get("min").getAsInt() : -1;
            int max = json.has("max") ? json.get("max").getAsInt() : -1;
            return new EffectAmountCondition(min, max);
        }

        @Override
        public void serialize(JsonObject json, LivingCondition condition) {
            if (!(condition instanceof EffectAmountCondition)) {
                throw new IllegalArgumentException();
            }
            EffectAmountCondition aCondition = (EffectAmountCondition)condition;
            if (aCondition.min != -1) {
                json.addProperty("min", (Number)aCondition.min);
            }
            if (aCondition.max != -1) {
                json.addProperty("max", (Number)aCondition.max);
            }
        }

        @Override
        public LivingCondition deserialize(CompoundTag tag) {
            int min = tag.m_128441_("Min") ? tag.m_128451_("Min") : -1;
            int max = tag.m_128441_("Max") ? tag.m_128451_("Max") : -1;
            return new EffectAmountCondition(min, max);
        }

        @Override
        public CompoundTag serialize(LivingCondition condition) {
            if (!(condition instanceof EffectAmountCondition)) {
                throw new IllegalArgumentException();
            }
            EffectAmountCondition aCondition = (EffectAmountCondition)condition;
            CompoundTag tag = new CompoundTag();
            if (aCondition.min != -1) {
                tag.m_128405_("Min", aCondition.min);
            }
            if (aCondition.max != -1) {
                tag.m_128405_("Max", aCondition.max);
            }
            return tag;
        }

        @Override
        public LivingCondition deserialize(FriendlyByteBuf buf) {
            return new EffectAmountCondition(buf.readInt(), buf.readInt());
        }

        @Override
        public void serialize(FriendlyByteBuf buf, LivingCondition condition) {
            if (!(condition instanceof EffectAmountCondition)) {
                throw new IllegalArgumentException();
            }
            EffectAmountCondition aCondition = (EffectAmountCondition)condition;
            buf.writeInt(aCondition.min);
            buf.writeInt(aCondition.max);
        }

        @Override
        public LivingCondition createDefaultInstance() {
            return new EffectAmountCondition(1, -1);
        }
    }
}

