/*
 * Decompiled with CFR 0.152.
 */
package daripher.skilltree.data.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import daripher.skilltree.data.serializers.SerializationHelper;
import daripher.skilltree.item.gem.GemType;
import daripher.skilltree.item.gem.bonus.GemBonusProvider;
import daripher.skilltree.skill.bonus.condition.item.ItemCondition;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;

public class GemTypeSerializer
implements JsonSerializer<GemType>,
JsonDeserializer<GemType> {
    public GemType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = (JsonObject)json;
        HashMap<ItemCondition, GemBonusProvider> bonuses = new HashMap<ItemCondition, GemBonusProvider>();
        jsonObj.getAsJsonArray("bonuses").forEach(jsonElement -> {
            JsonObject jsonBonus = (JsonObject)jsonElement;
            ItemCondition itemCondition = SerializationHelper.deserializeItemCondition(jsonBonus);
            GemBonusProvider bonusProvider = SerializationHelper.deserializeGemBonusProvider(jsonBonus);
            bonuses.put(itemCondition, bonusProvider);
        });
        ResourceLocation id = new ResourceLocation(jsonObj.get("id").getAsString());
        return new GemType(id, bonuses);
    }

    public JsonElement serialize(GemType src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        JsonArray jsonBonuses = new JsonArray();
        src.bonuses().forEach((c, p) -> {
            JsonObject jsonBonus = new JsonObject();
            SerializationHelper.serializeItemCondition(jsonBonus, c);
            SerializationHelper.serializeGemBonusProvider(jsonBonus, p);
            jsonBonuses.add((JsonElement)jsonBonus);
        });
        json.add("bonuses", (JsonElement)jsonBonuses);
        json.addProperty("id", src.id().toString());
        return json;
    }
}

