/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato.client.gui;

import com.tarinoita.solsweetpotato.client.gui.FoodBookScreen;
import com.tarinoita.solsweetpotato.client.gui.elements.UIBox;
import com.tarinoita.solsweetpotato.client.gui.elements.UIElement;
import com.tarinoita.solsweetpotato.client.gui.elements.UIImage;
import com.tarinoita.solsweetpotato.client.gui.elements.UILabel;
import com.tarinoita.solsweetpotato.client.gui.elements.UIStack;
import com.tarinoita.solsweetpotato.lib.Localization;
import java.awt.Rectangle;

abstract class Page
extends UIElement {
    final UIStack mainStack = new UIStack();
    final int spacing = 6;
    final UILabel headerLabel;

    Page(Rectangle frame, String header) {
        super(frame);
        this.mainStack.axis = UIStack.Axis.VERTICAL;
        this.mainStack.spacing = 6;
        this.headerLabel = new UILabel(header);
        this.mainStack.addChild(this.headerLabel);
        this.mainStack.addChild(this.makeSeparatorLine());
        this.children.add(this.mainStack);
        this.updateMainStack();
    }

    public void setHeaderTooltip(String tooltip) {
        this.headerLabel.tooltip = tooltip;
    }

    void updateMainStack() {
        this.mainStack.setCenterX(this.getCenterX());
        this.mainStack.setMinY(this.getMinY() + 17);
        this.mainStack.updateFrames();
    }

    String fraction(int numerator, int denominator) {
        return Localization.localized("gui", "food_book.fraction", numerator, denominator);
    }

    UIElement makeSeparatorLine() {
        return UIBox.horizontalLine(0, this.getWidth() / 2, 0, FoodBookScreen.leastBlack);
    }

    UIImage icon(UIImage.Image image) {
        UIImage icon = new UIImage(image);
        icon.setWidth(11);
        icon.setHeight(11);
        return icon;
    }

    UIElement statWithIcon(UIImage icon, String value, String name) {
        UIStack valueStack = new UIStack();
        valueStack.axis = UIStack.Axis.HORIZONTAL;
        valueStack.spacing = 3;
        valueStack.addChild(icon);
        valueStack.addChild(new UILabel(value));
        UIStack fullStack = new UIStack();
        fullStack.axis = UIStack.Axis.VERTICAL;
        fullStack.spacing = 2;
        fullStack.addChild(valueStack);
        UILabel nameLabel = new UILabel(name);
        nameLabel.color = FoodBookScreen.lessBlack;
        fullStack.addChild(nameLabel);
        return fullStack;
    }
}

