/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato;

import com.tarinoita.solsweetpotato.SOLSweetPotato;
import com.tarinoita.solsweetpotato.SOLSweetPotatoConfig;
import com.tarinoita.solsweetpotato.communication.ConfigMessage;
import com.tarinoita.solsweetpotato.tracking.FoodInstance;
import com.tarinoita.solsweetpotato.tracking.benefits.Benefit;
import com.tarinoita.solsweetpotato.tracking.benefits.BenefitList;
import com.tarinoita.solsweetpotato.utils.BenefitsParser;
import com.tarinoita.solsweetpotato.utils.ComplexityParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="solapplepie")
public class ConfigHandler {
    public static Map<FoodInstance, Double> complexityMap = new HashMap<FoodInstance, Double>();
    public static List<Double> thresholds = new ArrayList<Double>();
    public static BenefitList benefitsList = new BenefitList(new ArrayList<List<Benefit>>());
    public static final String COMPLEXITY_MAP_KEY = "complexity_map";
    public static final String THRESHOLDS_KEY = "thresholds";
    public static final String BENEFITS_KEY = "benefits_list";
    public static final String FOOD_KEY = "food";
    public static final String COMPLEXITY_VALUE_KEY = "complexity";
    public static final String ENTRY_KEY = "entries";
    public static boolean isFirstAid = false;

    public static CompoundTag serializeComplexityMap() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Map.Entry<FoodInstance, Double> entry : complexityMap.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            String encoded = entry.getKey().encode();
            entryTag.m_128365_(FOOD_KEY, (Tag)StringTag.m_129297_((String)encoded));
            entryTag.m_128365_(COMPLEXITY_VALUE_KEY, (Tag)DoubleTag.m_128500_((double)entry.getValue()));
            list.add((Object)entryTag);
        }
        tag.m_128365_(ENTRY_KEY, (Tag)list);
        return tag;
    }

    public static ListTag serializeThresholds() {
        ListTag tag = new ListTag();
        for (double t : thresholds) {
            tag.add((Object)DoubleTag.m_128500_((double)t));
        }
        return tag;
    }

    public static CompoundTag serializeBenefitsList() {
        return benefitsList.serializeNBT();
    }

    public static CompoundTag serializeConfig() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(COMPLEXITY_MAP_KEY, (Tag)ConfigHandler.serializeComplexityMap());
        tag.m_128365_(THRESHOLDS_KEY, (Tag)ConfigHandler.serializeThresholds());
        tag.m_128365_(BENEFITS_KEY, (Tag)ConfigHandler.serializeBenefitsList());
        return tag;
    }

    public static void deserializeConfig(CompoundTag tag) {
        ConfigHandler.deserializeComplexityMap(tag.m_128469_(COMPLEXITY_MAP_KEY));
        ConfigHandler.deserializeThresholds(tag.m_128437_(THRESHOLDS_KEY, 6));
        ConfigHandler.deserializeBenefitsList(tag.m_128469_(BENEFITS_KEY));
    }

    public static void deserializeBenefitsList(CompoundTag tag) {
        benefitsList.deserializeNBT(tag);
    }

    public static void deserializeComplexityMap(CompoundTag tag) {
        ListTag list = tag.m_128437_(ENTRY_KEY, 10);
        HashMap<FoodInstance, Double> newComplexityMap = new HashMap<FoodInstance, Double>();
        for (Tag nbt : list) {
            CompoundTag cnbt = (CompoundTag)nbt;
            String foodString = cnbt.m_128461_(FOOD_KEY);
            FoodInstance food = FoodInstance.decode(foodString);
            double complexity = cnbt.m_128459_(COMPLEXITY_VALUE_KEY);
            newComplexityMap.put(food, complexity);
        }
        complexityMap = newComplexityMap;
    }

    public static void deserializeThresholds(ListTag tag) {
        ArrayList<Double> newThresholds = new ArrayList<Double>();
        tag.stream().map(nbt -> (DoubleTag)nbt).map(DoubleTag::m_7061_).forEach(newThresholds::add);
        thresholds = newThresholds;
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        complexityMap = ComplexityParser.parse(SOLSweetPotatoConfig.getComplexityUnparsed());
        thresholds = SOLSweetPotatoConfig.getThresholds();
        List<List<Benefit>> benefits = BenefitsParser.parse(SOLSweetPotatoConfig.getBenefitsUnparsed());
        benefitsList = new BenefitList(benefits);
        isFirstAid = ModList.get().isLoaded("firstaid");
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ConfigHandler.syncConfig(event.getEntity());
    }

    public static List<List<Benefit>> getBenefitsList() {
        return benefitsList.getBenefits();
    }

    public static void syncConfig(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer target = (ServerPlayer)player;
        SOLSweetPotato.channel.sendTo((Object)new ConfigMessage(), target.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

