/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtower;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.lichtower.TowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class TowerRoofGableForwardsComponent
extends TowerRoofComponent {
    public TowerRoofGableForwardsComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFLTRGF.get(), nbt);
    }

    public TowerRoofGableForwardsComponent(int i, TowerWingComponent wing, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFLTRGF.get(), i, x, y, z);
        this.m_73519_(wing.m_73549_());
        this.height = this.size = wing.size + 2;
        this.makeAttachedOverhangBB(wing);
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockState birchSlab = Blocks.f_50400_.m_49966_();
        BlockState birchPlanks = Blocks.f_50742_.m_49966_();
        int slopeChange = this.slopeChangeForSize();
        for (int y = 0; y <= this.height; ++y) {
            int max;
            int min;
            if (y < slopeChange) {
                min = y;
                max = this.size - y - 1;
            } else {
                min = (y + slopeChange) / 2;
                max = this.size - (y + slopeChange) / 2 - 1;
            }
            for (int x = 0; x <= this.size - 2; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (z == min || z == max) {
                        this.m_73434_(world, birchPlanks, x, y, z, sbb);
                        continue;
                    }
                    if (x >= this.size - 2) continue;
                    this.m_73434_(world, birchPlanks, x, y, z, sbb);
                }
            }
        }
        int top = this.size + 1 - slopeChange;
        int zMid = this.size / 2;
        this.m_73434_(world, (BlockState)birchSlab.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP), this.size - 1, top - 1, zMid, sbb);
        this.m_73434_(world, birchSlab, 0, top, zMid, sbb);
        this.m_73434_(world, birchSlab, this.size - 3, top, zMid, sbb);
        this.m_73434_(world, birchPlanks, this.size - 2, top, zMid, sbb);
        this.m_73434_(world, birchPlanks, this.size - 1, top, zMid, sbb);
        this.m_73434_(world, birchPlanks, this.size - 1, top + 1, zMid, sbb);
    }

    public int slopeChangeForSize() {
        if (this.size > 10) {
            return 3;
        }
        if (this.size > 6) {
            return 2;
        }
        return 1;
    }
}

