/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFConfig;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.client.renderer.TFWeatherRenderer;
import twilightforest.entity.ai.control.NoClipMoveControl;
import twilightforest.entity.ai.goal.GhastguardHomedFlightGoal;
import twilightforest.entity.ai.goal.UrGhastFlightGoal;
import twilightforest.entity.boss.IBossLootBuffer;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.entity.projectile.UrGhastFireball;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.init.TFPOITypes;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.loot.TFLootTables;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.EntityUtil;
import twilightforest.util.LandmarkUtil;

public class UrGhast
extends CarminiteGhastguard
implements IBossLootBuffer {
    private static final Vec3 DYING_DECENT = new Vec3(0.0, -0.03, 0.0);
    private static final EntityDataAccessor<Boolean> DATA_TANTRUM = SynchedEntityData.m_135353_(UrGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final NonNullList<ItemStack> dyingInventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private List<BlockPos> trapLocations;
    private int nextTantrumCry;
    private float damageUntilNextPhase = 10.0f;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();

    public UrGhast(EntityType<? extends UrGhast> type, Level world) {
        super(type, world);
        this.wanderFactor = 32.0f;
        this.f_19794_ = true;
        this.setInTantrum(false);
        this.f_21364_ = 317;
        this.f_21342_ = new NoClipMoveControl((Mob)this);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return CarminiteGhastguard.registerAttributes().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_TANTRUM, (Object)false);
    }

    public List<BlockPos> getTrapLocations() {
        return this.trapLocations;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.trapLocations = new ArrayList<BlockPos>();
        this.f_21345_.f_25345_.removeIf(e -> e.m_26015_() instanceof GhastguardHomedFlightGoal);
        this.f_21345_.m_25352_(5, (Goal)new UrGhastFlightGoal(this));
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            if (this.isRestrictionPointValid(this.m_9236_().m_46472_()) && this.m_9236_().m_46749_(this.getRestrictionPoint().m_122646_())) {
                this.m_9236_().m_46597_(this.getRestrictionPoint().m_122646_(), ((Block)TFBlocks.UR_GHAST_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    @Override
    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.UR_GHAST_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.UR_GHAST_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.UR_GHAST_DEATH.get();
    }

    @Override
    public SoundEvent getFireSound() {
        return (SoundEvent)TFSounds.UR_GHAST_SHOOT.get();
    }

    @Override
    public SoundEvent getWarnSound() {
        return (SoundEvent)TFSounds.UR_GHAST_WARN.get();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        } else if (this.isInTantrum() && !this.m_21224_()) {
            this.m_9236_().m_7106_((ParticleOptions)TFParticleType.BOSS_TEAR.get(), this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 0.75, this.m_20186_() + this.m_217043_().m_188500_() * (double)this.m_20206_() * 0.5, this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_() * 0.75, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6673_(DamageSource src) {
        return src.m_276093_(DamageTypes.f_268612_) || src.m_269533_(DamageTypeTags.f_268745_) || super.m_6673_(src);
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    public boolean m_6469_(DamageSource source, float damage) {
        ServerPlayer player;
        if (this.isInTantrum()) {
            damage /= 10.0f;
        }
        float oldHealth = this.m_21223_();
        boolean attackSuccessful = "fireball".equals(source.m_19385_()) && source.m_7639_() instanceof Player ? super.m_6469_(this.m_269291_().m_269390_(source.m_7639_(), source.m_7640_()), damage) : super.m_6469_(source, damage);
        float lastDamage = oldHealth - this.m_21223_();
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
            this.hurtBy.add(player);
        }
        if (!this.m_9236_().m_5776_() && this.f_20916_ == this.f_20917_ && !this.m_21224_()) {
            this.damageUntilNextPhase -= lastDamage;
            if (this.damageUntilNextPhase <= 0.0f) {
                this.switchPhase();
            }
        }
        return attackSuccessful;
    }

    private void switchPhase() {
        if (this.isInTantrum()) {
            this.setInTantrum(false);
        } else {
            this.startTantrum();
        }
        this.resetDamageUntilNextPhase();
    }

    public void resetDamageUntilNextPhase() {
        this.damageUntilNextPhase = 18.0f;
    }

    private void startTantrum() {
        ServerLevel serverLevel;
        LightningBolt lightningbolt;
        this.setInTantrum(true);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel && (lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)(serverLevel = (ServerLevel)level))) != null) {
            BlockPos blockpos = serverLevel.m_143288_(BlockPos.m_274446_((Position)this.m_20182_().m_82549_(new Vec3(18.0, 0.0, 0.0).m_82524_((float)Math.toRadians(this.m_217043_().m_188503_(360))))));
            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)blockpos));
            lightningbolt.m_20874_(true);
            serverLevel.m_7967_((Entity)lightningbolt);
        }
        this.spawnGhastsAtTraps();
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_() && !this.m_21224_() && this.isInTantrum()) {
            TFWeatherRenderer.urGhastAlive = true;
        }
        super.m_8119_();
    }

    public void spawnGhastsAtTraps() {
        ArrayList<BlockPos> ghastSpawns = new ArrayList<BlockPos>(this.trapLocations);
        Collections.shuffle(ghastSpawns);
        int numSpawns = Math.min(2, ghastSpawns.size());
        for (int i = 0; i < numSpawns; ++i) {
            BlockPos spawnCoord = (BlockPos)ghastSpawns.get(i);
            this.spawnMinionGhastsAt(spawnCoord.m_123341_(), spawnCoord.m_123342_(), spawnCoord.m_123343_());
        }
    }

    private void spawnMinionGhastsAt(int x, int y, int z) {
        int tries = 24;
        int spawns = 0;
        int maxSpawns = 6;
        int rangeXZ = 4;
        int rangeY = 8;
        LightningBolt bolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
        bolt.m_6034_((double)x, (double)(y + 4), (double)z);
        bolt.m_20874_(true);
        this.m_9236_().m_7967_((Entity)bolt);
        for (int i = 0; i < tries; ++i) {
            CarminiteGhastling minion = (CarminiteGhastling)((EntityType)TFEntities.CARMINITE_GHASTLING.get()).m_20615_(this.m_9236_());
            double sx = (double)x + (this.m_217043_().m_188500_() - this.m_217043_().m_188500_()) * (double)rangeXZ;
            double sy = (double)y + this.m_217043_().m_188500_() * (double)rangeY;
            double sz = (double)z + (this.m_217043_().m_188500_() - this.m_217043_().m_188500_()) * (double)rangeXZ;
            minion.m_7678_(sx, sy, sz, this.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
            minion.makeBossMinion();
            if (minion.m_5545_((LevelAccessor)this.m_9236_(), MobSpawnType.MOB_SUMMONED)) {
                this.m_9236_().m_7967_((Entity)minion);
                minion.m_21373_();
            }
            if (++spawns >= maxSpawns) break;
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        for (CarminiteGhastling ghast : this.m_9236_().m_45976_(CarminiteGhastling.class, this.m_20191_().m_82400_(1.0))) {
            ghast.m_21373_();
            ghast.m_146870_();
            this.m_5634_(2.0f);
        }
        if (this.f_19797_ % 60 == 0 && !this.getTrapLocations().isEmpty()) {
            this.getTrapLocations().removeIf(pos -> !this.m_9236_().m_8055_(pos).m_60713_((Block)TFBlocks.GHAST_TRAP.get()) || !this.m_9236_().m_45527_(pos.m_7494_()));
        }
        if (this.f_19803_ || this.f_19797_ % 100 == 0) {
            List<BlockPos> addedPositions = this.scanForTraps((ServerLevel)this.m_9236_());
            addedPositions.removeIf(pos -> this.getTrapLocations().contains(pos));
            if (!addedPositions.isEmpty()) {
                this.getTrapLocations().addAll(addedPositions);
            }
        }
        if (this.isInTantrum()) {
            this.m_6710_(null);
            if (--this.nextTantrumCry <= 0) {
                this.m_5496_((SoundEvent)TFSounds.UR_GHAST_TANTRUM.get(), this.m_6121_(), this.m_6100_());
                this.f_21363_ = -this.m_8100_();
                this.nextTantrumCry = 20 + this.m_217043_().m_188503_(30);
            }
            if (this.f_19797_ % 10 == 0) {
                this.doTantrumDamageEffects();
            }
        }
    }

    public BlockPos getLogicalScanPoint() {
        return !this.isRestrictionPointValid(this.m_9236_().m_46472_()) ? this.m_20183_() : this.getRestrictionPoint().m_122646_();
    }

    private List<BlockPos> scanForTraps(ServerLevel level) {
        PoiManager poimanager = level.m_8904_();
        Stream stream = poimanager.m_27181_(type -> type.m_203565_(TFPOITypes.GHAST_TRAP.getKey()), this.getLogicalScanPoint(), this.getHomeRadius(), PoiManager.Occupancy.ANY);
        return stream.map(PoiRecord::m_27257_).filter(trapPos -> level.m_45527_(trapPos.m_7494_())).sorted(Comparator.comparingDouble(trapPos -> trapPos.m_123331_((Vec3i)this.getLogicalScanPoint()))).collect(Collectors.toList());
    }

    private void doTantrumDamageEffects() {
        AABB below = this.m_20191_().m_82386_(0.0, -16.0, 0.0).m_82377_(0.0, 16.0, 0.0);
        for (Player player : this.m_9236_().m_45976_(Player.class, below)) {
            if (!this.m_9236_().m_46861_(player.m_20183_())) continue;
            player.m_6469_(TFDamageTypes.getEntityDamageSource(this.m_9236_(), TFDamageTypes.GHAST_TEAR, (Entity)this, (EntityType)TFEntities.UR_GHAST.get()), 3.0f);
        }
        for (CarminiteGhastling ghast : this.m_9236_().m_45976_(CarminiteGhastling.class, below)) {
            ghast.m_5997_(0.0, 1.0, 0.0);
        }
    }

    public boolean checkGhastsAtTraps() {
        int trapsWithEnoughGhasts = 0;
        for (BlockPos trap : this.getTrapLocations()) {
            AABB aabb = new AABB(trap, trap.m_7918_(1, 1, 1)).m_82377_(8.0, 16.0, 8.0);
            List nearbyGhasts = this.m_9236_().m_45976_(CarminiteGhastling.class, aabb);
            if (nearbyGhasts.size() < 4) continue;
            ++trapsWithEnoughGhasts;
        }
        return trapsWithEnoughGhasts >= 1;
    }

    @Override
    public void spitFireball() {
        double offsetX = this.m_5448_().m_20185_() - this.m_20185_();
        double offsetY = this.m_5448_().m_20191_().f_82289_ + (double)(this.m_5448_().m_20206_() / 2.0f) - (this.m_20186_() + (double)(this.m_20206_() / 2.0f));
        double offsetZ = this.m_5448_().m_20189_() - this.m_20189_();
        UrGhastFireball entityFireball = new UrGhastFireball(this.m_9236_(), this, offsetX, offsetY, offsetZ, 1);
        double shotSpawnDistance = 8.5;
        Vec3 lookVec = this.m_20252_(1.0f);
        entityFireball.m_6034_(this.m_20185_() + lookVec.m_7096_() * shotSpawnDistance, this.m_20186_() + (double)(this.m_20206_() / 2.0f) + lookVec.m_7098_() * shotSpawnDistance, this.m_20189_() + lookVec.m_7094_() * shotSpawnDistance);
        this.m_9236_().m_7967_((Entity)entityFireball);
        for (int i = 0; i < 2; ++i) {
            entityFireball = new UrGhastFireball(this.m_9236_(), this, offsetX + (double)((this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 8.0f), offsetY, offsetZ + (double)((this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 8.0f), 1);
            entityFireball.m_6034_(this.m_20185_() + lookVec.m_7096_() * shotSpawnDistance, this.m_20186_() + (double)(this.m_20206_() / 2.0f) + lookVec.m_7098_() * shotSpawnDistance, this.m_20189_() + lookVec.m_7094_() * shotSpawnDistance);
            this.m_9236_().m_7967_((Entity)entityFireball);
        }
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean isInTantrum() {
        return (Boolean)this.m_20088_().m_135370_(DATA_TANTRUM);
    }

    public void setInTantrum(boolean inTantrum) {
        this.m_20088_().m_135381_(DATA_TANTRUM, (Object)inTantrum);
        this.resetDamageUntilNextPhase();
    }

    @Override
    protected float m_6121_() {
        return 16.0f;
    }

    public float m_6100_() {
        return (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 0.5f;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128379_("inTantrum", this.isInTantrum());
        this.addDeathItemsSaveData(compound);
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setInTantrum(compound.m_128471_("inTantrum"));
        this.readDeathItemsSaveData(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.bossInfo.m_142711_(0.0f);
            IBossLootBuffer.saveDropsIntoBoss(this, TFLootTables.createLootParams((LivingEntity)this, true, cause).m_287235_(LootContextParamSets.f_81415_), serverLevel);
            LandmarkUtil.markStructureConquered(this.m_9236_(), this, TFStructures.DARK_TOWER, true);
            for (ServerPlayer player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
            }
            LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
            if (lightningbolt != null) {
                lightningbolt.m_20219_(this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() * 0.5f), 0.0));
                lightningbolt.m_20874_(true);
                serverLevel.m_7967_((Entity)lightningbolt);
            }
        }
    }

    protected void m_6153_() {
        ++this.f_20919_;
        int maxDeath = 80;
        if (this.f_20919_ <= maxDeath / 2) {
            float bbWidth = this.m_20205_();
            float bbHeight = this.m_20206_();
            for (int k = 0; k < 12; ++k) {
                double d = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? (this.f_19796_.m_188499_() ? ParticleTypes.f_123759_ : ParticleTypes.f_123813_) : DustParticleOptions.f_123656_), this.m_20185_() + (double)(this.f_19796_.m_188501_() * bbWidth * 1.8f) - (double)bbWidth, this.m_20186_() + (double)(this.f_19796_.m_188501_() * bbHeight), this.m_20189_() + (double)(this.f_19796_.m_188501_() * bbWidth * 1.8f) - (double)bbWidth, d, d1, d2);
            }
        } else if (this.m_9236_() instanceof ServerLevel) {
            double z;
            double y;
            double x;
            int i;
            if (this.f_20919_ >= maxDeath && !this.m_213877_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            Vec3 start = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() * 0.5f), 0.0);
            Vec3 end = Vec3.m_82512_((Vec3i)EntityUtil.bossChestLocation(this));
            Vec3 diff = end.m_82546_(start);
            int deathTime2 = this.f_20919_ - maxDeath / 2 + 1;
            double factor = (double)deathTime2 / (double)(maxDeath / 2);
            Vec3 particlePos = start.m_82549_(diff.m_82490_(factor)).m_82520_(Math.sin((double)deathTime2 * Math.PI * 0.1), Math.sin((double)deathTime2 * Math.PI * 0.05), Math.cos((double)deathTime2 * Math.PI * 0.1125));
            ParticlePacket particlePacket = new ParticlePacket();
            if (this.f_20919_ >= maxDeath - 2) {
                for (i = 0; i < 40; ++i) {
                    x = (this.f_19796_.m_188500_() - 0.5) * 0.075 * (double)i;
                    y = (this.f_19796_.m_188500_() - 0.5) * 0.075 * (double)i;
                    z = (this.f_19796_.m_188500_() - 0.5) * 0.075 * (double)i;
                    particlePacket.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, end.m_82520_(x, y, z), Vec3.f_82478_);
                }
            }
            for (i = 0; i < 40; ++i) {
                x = (this.f_19796_.m_188500_() - 0.5) * 0.05 * (double)i;
                y = (this.f_19796_.m_188500_() - 0.5) * 0.05 * (double)i;
                z = (this.f_19796_.m_188500_() - 0.5) * 0.05 * (double)i;
                particlePacket.queueParticle((ParticleOptions)DustParticleOptions.f_123656_, false, particlePos.m_82520_(x, y, z), Vec3.f_82478_);
            }
            TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)particlePacket);
        }
    }

    public Vec3 m_20184_() {
        return this.m_21224_() ? DYING_DECENT : super.m_20184_();
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Level level;
        if (reason.equals((Object)Entity.RemovalReason.KILLED) && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            IBossLootBuffer.depositDropsIntoChest(this, ((TFChestBlock)((Object)TFBlocks.DARK_CHEST.get())).m_49966_(), EntityUtil.bossChestLocation(this), serverLevel);
        }
        super.m_142687_(reason);
    }

    protected boolean m_6125_() {
        return (Boolean)TFConfig.COMMON_CONFIG.bossDropChests.get() == false;
    }

    @Override
    public boolean shouldAttack(LivingEntity living) {
        return !this.isInTantrum();
    }

    @Override
    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    @Override
    public NonNullList<ItemStack> getItemStacks() {
        return this.dyingInventory;
    }
}

