/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.HostileWolfModel;
import twilightforest.entity.monster.HostileWolf;

public class MistWolfRenderer
extends MobRenderer<HostileWolf, HostileWolfModel<HostileWolf>> {
    private static HostileWolf parent;
    private static final ResourceLocation textureLoc;

    public MistWolfRenderer(EntityRendererProvider.Context manager) {
        super(manager, (EntityModel)new HostileWolfModel<HostileWolf>(manager.m_174023_(TFModelLayers.HOSTILE_WOLF)){

            public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int light, int overlay, float r, float g, float b, float a) {
                float brightness = parent.m_9236_().m_46803_(parent.m_20183_());
                float misty = Math.min(1.0f, brightness * 3.0f + 0.25f);
                float smoky = brightness * 2.0f + 0.6f;
                super.m_7695_(poseStack, buffer, light, overlay, misty, misty, misty, smoky);
            }
        }, 0.5f);
        this.f_114477_ = 1.0f;
    }

    protected void scale(HostileWolf entity, PoseStack stack, float partialTicks) {
        float wolfScale = 1.9f;
        stack.m_85841_(wolfScale, wolfScale, wolfScale);
    }

    public void render(HostileWolf wolf, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        parent = wolf;
        super.m_7392_((Mob)wolf, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
        parent = null;
    }

    protected float getBob(HostileWolf p_116528_, float p_116529_) {
        return p_116528_.getTailAngle();
    }

    @Nullable
    protected RenderType getRenderType(HostileWolf entity, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity));
    }

    public ResourceLocation getTextureLocation(HostileWolf entity) {
        return textureLoc;
    }

    static {
        textureLoc = TwilightForestMod.getModelTexture("mistwolf.png");
    }
}

